/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import buildcraft.api.tools.IToolPipette;
import forestry.core.config.Config;
import forestry.core.gui.ContainerLiquidTanks;
import forestry.core.gui.GfxSlot;
import forestry.core.gui.GfxSlotManager;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;

public class LiquidTankSlot
extends GfxSlot {
    protected int overlayTexX = 176;
    protected int overlayTexY = 0;
    protected ILiquidTank tank;
    protected int slot = 0;

    public LiquidTankSlot(GfxSlotManager manager, int xPos, int yPos, ILiquidTankContainer tile, int slot) {
        this(manager, xPos, yPos, tile.getTanks(ForgeDirection.UNKNOWN)[slot], slot);
    }

    public LiquidTankSlot(GfxSlotManager manager, int xPos, int yPos, ILiquidTank tank, int slot) {
        super(manager, xPos, yPos);
        this.tank = tank;
        this.slot = slot;
        this.height = 58;
    }

    public LiquidTankSlot setOverlayOrigin(int x2, int y2) {
        this.overlayTexX = x2;
        this.overlayTexY = y2;
        return this;
    }

    @Override
    public void draw(int startX, int startY) {
        int x2;
        if (this.tank == null) {
            return;
        }
        up content = null;
        int liquidImgIndex = 0;
        int liquidId = this.tank.getLiquid().itemID;
        int liquidMeta = this.tank.getLiquid().itemMeta;
        int squaled = this.tank.getLiquid().amount * this.height / this.tank.getCapacity();
        if (liquidId <= 0) {
            return;
        }
        if (liquidId < amq.p.length && amq.p[liquidId] != null) {
            content = amq.p[liquidId];
            liquidImgIndex = amq.p[liquidId].cl;
            Proxies.common.bindTexture(((amq)content).getTextureFile());
        } else {
            content = up.e[liquidId];
            liquidImgIndex = up.e[liquidId].b(liquidMeta);
            Proxies.common.bindTexture(content.getTextureFile());
        }
        int imgLine = liquidImgIndex / 16;
        int imgColumn = liquidImgIndex - imgLine * 16;
        int start = 0;
        GL11.glDisable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        do {
            x2 = 0;
            if (squaled > 16) {
                x2 = 16;
                squaled -= 16;
            } else {
                x2 = squaled;
                squaled = 0;
            }
            this.manager.gui.b(startX + this.xPos, startY + this.yPos + 58 - x2 - start, imgColumn * 16, imgLine * 16, 16, 16 - (16 - x2));
            start += 16;
        } while (x2 != 0 && squaled != 0);
        int tex = this.manager.minecraft.o.b(this.manager.gui.textureFile);
        this.manager.minecraft.o.b(tex);
        this.manager.gui.b(startX + this.xPos, startY + this.yPos, this.overlayTexX, this.overlayTexY, 16, 60);
        GL11.glEnable((int)2896);
    }

    @Override
    public String getTooltip(qx player) {
        LiquidStack liquidStack = this.tank.getLiquid();
        if (liquidStack != null && liquidStack.itemID > 0) {
            String tooltip = up.e[liquidStack.itemID].l(liquidStack.asItemStack());
            if (Config.tooltipLiquidAmount) {
                tooltip = tooltip + " (" + this.tank.getLiquid().amount + ")";
            }
            return tooltip;
        }
        return StringUtil.localize("gui.empty");
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        ur itemstack = this.manager.minecraft.g.bJ.n();
        if (itemstack == null) {
            return;
        }
        up held = itemstack.b();
        if (held instanceof IToolPipette && this.manager.gui.inventorySlots instanceof ContainerLiquidTanks) {
            ((ContainerLiquidTanks)this.manager.gui.inventorySlots).handlePipetteClick(this.slot, (qx)this.manager.minecraft.g);
        }
    }
}

