/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.core.EnumTemperature;
import forestry.core.genetics.ClimateHelper;
import forestry.core.gui.Ledger;
import forestry.core.gui.LedgerManager;
import forestry.core.interfaces.IClimatised;
import forestry.core.utils.StringUtil;

public class ClimateLedger
extends Ledger {
    IClimatised tile;

    public ClimateLedger(LedgerManager manager, IClimatised tile) {
        super(manager);
        this.tile = tile;
        this.maxHeight = 72;
        this.overlayColor = manager.gui.fontColor.get("ledger.climate.background");
    }

    @Override
    public void draw(int x2, int y2) {
        EnumTemperature temperature = this.tile.getTemperature();
        this.drawBackground(x2, y2);
        this.drawIcon("/gfx/forestry/gui/habitats.png", temperature.getIconIndex(), x2 + 3, y2 + 4);
        if (!this.isFullyOpened()) {
            return;
        }
        this.manager.minecraft.p.a(StringUtil.localize("gui.climate"), x2 + 22, y2 + 8, this.manager.gui.fontColor.get("ledger.climate.header"));
        this.manager.minecraft.p.a(StringUtil.localize("gui.temperature") + ":", x2 + 22, y2 + 20, this.manager.gui.fontColor.get("ledger.climate.subheader"));
        this.manager.minecraft.p.b(ClimateHelper.toDisplay(temperature) + " " + StringUtil.floatAsPercent(this.tile.getExactTemperature()), x2 + 22, y2 + 32, this.manager.gui.fontColor.get("ledger.climate.text"));
        this.manager.minecraft.p.a(StringUtil.localize("gui.humidity") + ":", x2 + 22, y2 + 44, this.manager.gui.fontColor.get("ledger.climate.subheader"));
        this.manager.minecraft.p.b(ClimateHelper.toDisplay(this.tile.getHumidity()) + " " + StringUtil.floatAsPercent(this.tile.getExactHumidity()), x2 + 22, y2 + 56, this.manager.gui.fontColor.get("ledger.climate.text"));
    }

    @Override
    public String getTooltip() {
        return "T: " + ClimateHelper.toDisplay(this.tile.getTemperature()) + " / H: " + ClimateHelper.toDisplay(this.tile.getHumidity());
    }
}

