/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import forestry.api.arboriculture.ITree;
import forestry.api.genetics.IIndividual;

public abstract class Individual
implements IIndividual {
    protected boolean isAnalyzed = false;

    @Override
    public boolean isAnalyzed() {
        return this.isAnalyzed;
    }

    @Override
    public boolean analyze() {
        if (this.isAnalyzed) {
            return false;
        }
        this.isAnalyzed = true;
        return true;
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        if (nbttagcompound == null) {
            return;
        }
        this.isAnalyzed = nbttagcompound.n("IsAnalyzed");
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        nbttagcompound.a("IsAnalyzed", this.isAnalyzed);
    }

    @Override
    public boolean hasEffect() {
        return this.getGenome().getPrimary().hasEffect();
    }

    @Override
    public boolean isSecret() {
        return this.getGenome().getPrimary().isSecret();
    }

    @Override
    public boolean isGeneticEqual(IIndividual other) {
        if (!(other instanceof ITree)) {
            return false;
        }
        ITree tree = (ITree)other;
        return this.getGenome().isGeneticEqual(tree.getGenome());
    }
}

