/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gadgets;

import forestry.core.TemperatureState;
import forestry.core.gadgets.Gadget;
import forestry.core.gadgets.TileEngine;
import forestry.core.network.IndexInPayload;
import forestry.core.network.PacketPayload;
import forestry.core.utils.TankSlot;
import ic2.api.Direction;
import net.minecraftforge.liquids.LiquidContainerData;

public abstract class Engine
extends Gadget {
    protected int currentOutput = 0;
    public int maxEnergy;
    public int maxEnergyExtracted;
    public int storedEnergy;
    public int heat;
    protected int maxHeat;
    protected boolean forceCooldown = false;
    public float progress;

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayload payload = new PacketPayload(6, 0, 0);
        payload.intPayload[0] = this.maxEnergy;
        payload.intPayload[1] = this.maxEnergyExtracted;
        payload.intPayload[2] = this.storedEnergy;
        payload.intPayload[3] = this.maxHeat;
        payload.intPayload[4] = this.heat;
        return payload;
    }

    @Override
    public void fromPacketPayload(PacketPayload payload, IndexInPayload index) {
        this.maxEnergy = payload.intPayload[index.intIndex + 0];
        this.maxEnergyExtracted = payload.intPayload[index.intIndex + 1];
        this.storedEnergy = payload.intPayload[index.intIndex + 2];
        this.maxHeat = payload.intPayload[index.intIndex + 3];
        this.heat = payload.intPayload[index.intIndex + 4];
    }

    public Engine(TileEngine tile) {
        super(tile);
    }

    protected ur replenishByContainer(ur inventoryStack, LiquidContainerData container, TankSlot tank) {
        if (container == null) {
            return inventoryStack;
        }
        if (tank.fill(container.stillLiquid, false) >= container.stillLiquid.amount) {
            tank.fill(container.stillLiquid, true);
            if (container.filled != null && container.filled.b().s()) {
                inventoryStack = container.container.l();
            } else {
                --inventoryStack.a;
            }
        }
        return inventoryStack;
    }

    public void addEnergy(int addition) {
        this.storedEnergy += addition;
        if (this.storedEnergy > this.maxEnergy) {
            this.storedEnergy = this.maxEnergy;
        }
    }

    public int extractEnergy(int min, int max, boolean doExtract) {
        int extracted;
        if (this.storedEnergy < min) {
            return 0;
        }
        int ceiling = max > this.maxEnergyExtracted ? this.maxEnergyExtracted : max;
        if (this.storedEnergy >= ceiling) {
            extracted = ceiling;
            if (doExtract) {
                this.storedEnergy -= ceiling;
            }
        } else {
            extracted = this.storedEnergy;
            if (doExtract) {
                this.storedEnergy = 0;
            }
        }
        return extracted;
    }

    protected void addHeat(int i) {
        this.heat += i;
        if (this.heat > this.maxHeat) {
            this.heat = this.maxHeat;
        }
    }

    public abstract int dissipateHeat();

    public abstract int generateHeat();

    public int maxEnergyReceived() {
        return 200;
    }

    public boolean mayBurn() {
        return !this.forceCooldown;
    }

    public abstract void burn();

    @Override
    public void updateServerSide() {
        TemperatureState energyState = this.getTemperatureState();
        if (energyState == TemperatureState.MELTING && this.heat > 0) {
            this.forceCooldown = true;
        } else if (this.forceCooldown && this.heat <= 0) {
            this.forceCooldown = false;
        }
    }

    protected double getHeatLevel() {
        return (double)this.heat / (double)this.maxHeat;
    }

    public abstract boolean isBurning();

    public int getBurnTimeRemainingScaled(int i) {
        return 0;
    }

    public boolean hasFuelMin(float percentage) {
        return false;
    }

    public int getCurrentOutput() {
        if (this.isBurning() && this.tile.isActivated()) {
            return this.currentOutput;
        }
        return 0;
    }

    public int getEnergyStored() {
        return this.storedEnergy;
    }

    public int getHeat() {
        return this.heat;
    }

    public TemperatureState getTemperatureState() {
        double scaledHeat = (double)this.heat / (double)this.maxHeat;
        if (scaledHeat < 0.2) {
            return TemperatureState.COOL;
        }
        if (scaledHeat < 0.45) {
            return TemperatureState.WARMED_UP;
        }
        if (scaledHeat < 0.65) {
            return TemperatureState.OPERATING_TEMPERATURE;
        }
        if (scaledHeat < 0.85) {
            return TemperatureState.RUNNING_HOT;
        }
        if (scaledHeat < 1.0) {
            return TemperatureState.OVERHEATING;
        }
        return TemperatureState.MELTING;
    }

    public float getPistonSpeed() {
        switch (this.getTemperatureState()) {
            case COOL: {
                return 0.03f;
            }
            case WARMED_UP: {
                return 0.04f;
            }
            case OPERATING_TEMPERATURE: {
                return 0.05f;
            }
            case RUNNING_HOT: {
                return 0.06f;
            }
            case OVERHEATING: {
                return 0.07f;
            }
            case MELTING: {
                return 0.08f;
            }
        }
        return 0.0f;
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        this.heat = nbttagcompound.e("EngineHeat");
        this.storedEnergy = nbttagcompound.e("EngineStoredEnergy");
        this.progress = nbttagcompound.g("EngineProgress");
        this.forceCooldown = nbttagcompound.n("ForceCooldown");
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        nbttagcompound.a("EngineHeat", this.heat);
        nbttagcompound.a("EngineStoredEnergy", this.storedEnergy);
        nbttagcompound.a("EngineProgress", this.progress);
        nbttagcompound.a("ForceCooldown", this.forceCooldown);
    }

    public boolean acceptsEnergyFrom(any emitter, Direction direction) {
        return false;
    }

    public boolean isAddedToEnergyNet() {
        return false;
    }

    public int demandsEnergy() {
        return 0;
    }

    public int injectEnergy(Direction directionFrom, int amount) {
        return 0;
    }

    public int getSocketCount() {
        return 0;
    }

    public ur getSocket(int slot) {
        return null;
    }

    public void setSocket(int slot, ur stack) {
    }
}

