/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.circuits.ICircuitLayout;
import forestry.core.circuits.EnumCircuitBoardType;
import java.util.ArrayList;
import java.util.List;

public class CircuitBoard
implements ICircuitBoard {
    EnumCircuitBoardType type;
    ICircuitLayout layout;
    ICircuit[] circuits;

    public CircuitBoard(EnumCircuitBoardType type, ICircuitLayout layout, ICircuit[] circuits) {
        this.type = type;
        this.layout = layout;
        this.circuits = circuits;
    }

    public CircuitBoard(bq nbttagcompound) {
        this.readFromNBT(nbttagcompound);
    }

    @Override
    public int getPrimaryColor() {
        return this.type.primaryColor;
    }

    @Override
    public int getSecondaryColor() {
        return this.type.secondaryColor;
    }

    @Override
    public void addTooltip(List list) {
        if (this.layout != null) {
            list.add("\u00a76" + this.layout.getUsage() + ":");
        }
        for (ICircuit circuit : this.circuits) {
            if (circuit == null) continue;
            circuit.addTooltip(list);
        }
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        this.type = EnumCircuitBoardType.values()[nbttagcompound.d("T")];
        if (nbttagcompound.b("LY")) {
            this.layout = ChipsetManager.circuitRegistry.getLayout(nbttagcompound.i("LY"));
        }
        if (this.layout == null) {
            ChipsetManager.circuitRegistry.getDefaultLayout();
        }
        ArrayList<ICircuit> readcircuits = new ArrayList<ICircuit>();
        if (nbttagcompound.b("CS")) {
            by nbttaglist = nbttagcompound.m("CS");
            for (int i = 0; i < nbttaglist.c(); ++i) {
                bq nbttagcompound1 = (bq)nbttaglist.b(i);
                readcircuits.add(ChipsetManager.circuitRegistry.getFromLegacyMap(nbttagcompound1.e("I")));
            }
            this.circuits = readcircuits.toArray(new ICircuit[0]);
            return;
        }
        if (nbttagcompound.b("CL")) {
            by nbttaglist = nbttagcompound.m("CL");
            for (int i = 0; i < nbttaglist.c(); ++i) {
                bq nbttagcompound1 = (bq)nbttaglist.b(i);
                readcircuits.add(ChipsetManager.circuitRegistry.getCircuit(nbttagcompound1.i("I")));
            }
            this.circuits = readcircuits.toArray(new ICircuit[0]);
            return;
        }
        if (this.circuits != null) {
            return;
        }
        this.circuits = new ICircuit[4];
        for (int i = 0; i < 4; ++i) {
            if (!nbttagcompound.b("CA.I" + i)) continue;
            this.circuits[i] = ChipsetManager.circuitRegistry.getCircuit(nbttagcompound.i("CA.I" + i));
        }
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        nbttagcompound.a("T", (short)this.type.ordinal());
        if (this.layout != null) {
            nbttagcompound.a("LY", this.layout.getUID());
        }
        for (int i = 0; i < this.circuits.length; ++i) {
            ICircuit circuit = this.circuits[i];
            if (circuit == null) continue;
            nbttagcompound.a("CA.I" + i, circuit.getUID());
        }
    }

    @Override
    public void onInsertion(any tile) {
        for (int i = 0; i < this.circuits.length; ++i) {
            if (this.circuits[i] == null) continue;
            this.circuits[i].onInsertion(i, tile);
        }
    }

    @Override
    public void onLoad(any tile) {
        for (int i = 0; i < this.circuits.length; ++i) {
            if (this.circuits[i] == null) continue;
            this.circuits[i].onLoad(i, tile);
        }
    }

    @Override
    public void onRemoval(any tile) {
        for (int i = 0; i < this.circuits.length; ++i) {
            if (this.circuits[i] == null) continue;
            this.circuits[i].onRemoval(i, tile);
        }
    }

    @Override
    public void onTick(any tile) {
        for (int i = 0; i < this.circuits.length; ++i) {
            if (this.circuits[i] == null) continue;
            this.circuits[i].onTick(i, tile);
        }
    }
}

