/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import cpw.mods.fml.common.IWorldGenerator;
import forestry.api.core.IPlugin;
import forestry.core.config.Config;
import forestry.core.config.ForestryBlock;
import forestry.core.proxy.Proxies;
import forestry.core.worldgen.WorldGenMinableMeta;
import forestry.plugins.PluginManager;
import java.util.Random;

public class WorldGenerator
implements IWorldGenerator {
    private WorldGenMinableMeta apatiteGenerator;
    private WorldGenMinableMeta copperGenerator;
    private WorldGenMinableMeta tinGenerator;

    public void generate(Random random, int chunkX, int chunkZ, yc world, zw chunkGenerator, zw chunkProvider) {
        int randPosZ;
        int randPosY;
        int randPosX;
        int i;
        int randPosZ2;
        int randPosY2;
        int randPosX2;
        if (this.apatiteGenerator == null) {
            this.apatiteGenerator = new WorldGenMinableMeta(ForestryBlock.resources.cm, 0, 36);
            this.copperGenerator = new WorldGenMinableMeta(ForestryBlock.resources.cm, 1, 6);
            this.tinGenerator = new WorldGenMinableMeta(ForestryBlock.resources.cm, 2, 6);
        }
        if (Config.generateApatiteOre && random.nextFloat() < 0.75f && this.apatiteGenerator.a(world, random, randPosX2 = (chunkX <<= 4) + random.nextInt(16), randPosY2 = random.nextInt(world.P() - 72) + 64, randPosZ2 = (chunkZ <<= 4) + random.nextInt(16))) {
            Proxies.log.finest("Generated apatite vein around %s/%s/%s", randPosX2, randPosY2, randPosZ2);
        }
        if (Config.generateCopperOre) {
            for (i = 0; i < 20; ++i) {
                randPosX = chunkX + random.nextInt(16);
                randPosY = random.nextInt(76) + 32;
                randPosZ = chunkZ + random.nextInt(16);
                this.copperGenerator.a(world, random, randPosX, randPosY, randPosZ);
            }
        }
        if (Config.generateTinOre) {
            for (i = 0; i < 18; ++i) {
                randPosX = chunkX + random.nextInt(16);
                randPosY = random.nextInt(76) + 16;
                randPosZ = chunkZ + random.nextInt(16);
                this.tinGenerator.a(world, random, randPosX, randPosY, randPosZ);
            }
        }
        for (IPlugin plugin : PluginManager.plugins) {
            if (!plugin.isAvailable()) continue;
            plugin.generateSurface(world, random, chunkX, chunkZ);
        }
    }
}

