/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import forestry.core.config.Config;
import forestry.core.config.Configuration;
import forestry.core.config.ForestryBlock;
import forestry.core.config.ForestryItem;
import forestry.core.config.Property;
import forestry.core.interfaces.IGameMode;

public class GameMode
implements IGameMode {
    private static IGameMode activeMode;
    private String identifier = "EASY";
    private float energyDemandModifier = 1.0f;
    private int fertilizerFarmValue = 2000;
    private ur recipeFertilizerOutputApatite = new ur(ForestryItem.fertilizerCompound, 8);
    private ur recipeFertilizerOutputAsh = new ur(ForestryItem.fertilizerCompound, 16);
    private ur recipeCompostOutputWheat = new ur(ForestryItem.fertilizerBio, 4);
    private ur recipeCompostOutputAsh = new ur(ForestryItem.fertilizerBio, 1);
    private ur recipeHumusOutputFertilizer = new ur(ForestryBlock.soil, 8, 0);
    private ur recipeHumusOutputCompost = new ur(ForestryBlock.soil, 8, 0);
    private ur recipeBogEarthOutputBucket = new ur(ForestryBlock.soil, 6, 1);
    private ur recipeBogEarthOutputCans = new ur(ForestryBlock.soil, 8, 1);
    private ur recipeCanOutput = new ur(ForestryItem.canEmpty, 12);
    private ur recipeCapsuleOutput = new ur(ForestryItem.waxCapsule, 4);
    private ur recipeRefractoryOutput = new ur(ForestryItem.refractoryEmpty, 4);
    private int fermentationCyclesFertilizer = 200;
    private int fermentationCyclesCompost = 250;
    private int fermentationPerCycleFertilizer = 56;
    private int fermentationPerCycleCompost = 48;
    private int fermentedPerSapling = 800;
    private int fermentedPerCacti = 100;
    private int fermentedPerWheat = 100;
    private int fermentedPerCane = 100;
    private int fermentedPerMushroom = 100;
    private int squeezedLiquidPerSeed = 20;

    public static IGameMode getGameMode() {
        if (activeMode == null) {
            activeMode = new GameMode(Config.gameMode);
        }
        return activeMode;
    }

    public GameMode(String identifier) {
        this.identifier = identifier;
        String category = "gamemodes/" + identifier;
        Configuration config = Config.config;
        Property property = config.get("energy.demand.modifier", category, this.energyDemandModifier);
        property.Comment = "modifies the energy required to activate machines, as well as the max amount of energy stored and accepted.";
        this.energyDemandModifier = Float.parseFloat(property.Value);
        property = config.get("farms.fertilizer.value", category, this.fertilizerFarmValue);
        property.Comment = "modifies the time fertilizer lasts in a farm.";
        this.fertilizerFarmValue = Integer.parseInt(property.Value);
        property = config.get("recipe.output.fertilizer.apatite", category, this.recipeFertilizerOutputApatite.a);
        property.Comment = "amount of fertilizer yielded by the recipe using apatite.";
        this.recipeFertilizerOutputApatite = new ur(this.recipeFertilizerOutputApatite.c, Integer.parseInt(property.Value), this.recipeFertilizerOutputApatite.j());
        property = config.get("recipe.output.fertilizer.ash", category, this.recipeFertilizerOutputAsh.a);
        property.Comment = "amount of fertilizer yielded by the recipe using ash.";
        this.recipeFertilizerOutputAsh = new ur(this.recipeFertilizerOutputAsh.c, Integer.parseInt(property.Value), this.recipeFertilizerOutputAsh.j());
        property = config.get("recipe.output.compost.wheat", category, this.recipeCompostOutputWheat.a);
        property.Comment = "amount of compost yielded by the recipe using wheat.";
        this.recipeCompostOutputWheat = new ur(this.recipeCompostOutputWheat.c, Integer.parseInt(property.Value), this.recipeCompostOutputWheat.j());
        property = config.get("recipe.output.compost.ash", category, this.recipeCompostOutputAsh.a);
        property.Comment = "amount of compost yielded by the recipe using ash.";
        this.recipeCompostOutputAsh = new ur(this.recipeCompostOutputAsh.c, Integer.parseInt(property.Value), this.recipeCompostOutputAsh.j());
        property = config.get("recipe.output.humus.fertilizer", category, this.recipeHumusOutputFertilizer.a);
        property.Comment = "amount of humus yielded by the recipe using fertilizer.";
        this.recipeHumusOutputFertilizer = new ur(this.recipeHumusOutputFertilizer.c, Integer.parseInt(property.Value), this.recipeHumusOutputFertilizer.j());
        property = config.get("recipe.output.humus.compost", category, this.recipeHumusOutputCompost.a);
        property.Comment = "amount of humus yielded by the recipe using compost.";
        this.recipeHumusOutputCompost = new ur(this.recipeHumusOutputCompost.c, Integer.parseInt(property.Value), this.recipeHumusOutputCompost.j());
        property = config.get("recipe.output.bogearth.bucket", category, this.recipeBogEarthOutputBucket.a);
        property.Comment = "amount of bog earth yielded by the recipe using buckets.";
        this.recipeBogEarthOutputBucket = new ur(this.recipeBogEarthOutputBucket.c, Integer.parseInt(property.Value), this.recipeBogEarthOutputBucket.j());
        property = config.get("recipe.output.bogearth.can", category, this.recipeBogEarthOutputCans.a);
        property.Comment = "amount of bog earth yielded by the recipes using cans, cells or capsules.";
        this.recipeBogEarthOutputCans = new ur(this.recipeBogEarthOutputCans.c, Integer.parseInt(property.Value), this.recipeBogEarthOutputCans.j());
        property = config.get("recipe.output.can", category, this.recipeCanOutput.a);
        property.Comment = "amount yielded by the recipe for tin cans.";
        this.recipeCanOutput = new ur(this.recipeCanOutput.c, Integer.parseInt(property.Value), this.recipeCanOutput.j());
        property = config.get("recipe.output.capsule", category, this.recipeCapsuleOutput.a);
        property.Comment = "amount yielded by the recipe for wax capsules.";
        this.recipeCapsuleOutput = new ur(this.recipeCapsuleOutput.c, Integer.parseInt(property.Value), this.recipeCapsuleOutput.j());
        property = config.get("recipe.output.refractory", category, this.recipeRefractoryOutput.a);
        property.Comment = "amount yielded by the recipe for refractory capsules.";
        this.recipeRefractoryOutput = new ur(this.recipeRefractoryOutput.c, Integer.parseInt(property.Value), this.recipeRefractoryOutput.j());
        property = config.get("fermenter.cycles.fertilizer", category, this.fermentationCyclesFertilizer);
        property.Comment = "modifies the amount of cycles a fertilizer can keep a fermenter going.";
        this.fermentationCyclesFertilizer = Integer.parseInt(property.Value);
        property = config.get("fermenter.cycles.compost", category, this.fermentationCyclesCompost);
        property.Comment = "modifies the amount of cycles compost can keep a fermenter going.";
        this.fermentationCyclesCompost = Integer.parseInt(property.Value);
        property = config.get("fermenter.value.fertilizer", category, this.fermentationPerCycleFertilizer);
        property.Comment = "modifies the amount of biomass per cycle a fermenter will produce using fertilizer.";
        this.fermentationPerCycleFertilizer = Integer.parseInt(property.Value);
        property = config.get("fermenter.value.compost", category, this.fermentationPerCycleCompost);
        property.Comment = "modifies the amount of biomass per cycle a fermenter will produce using compost.";
        this.fermentationPerCycleCompost = Integer.parseInt(property.Value);
        property = config.get("fermenter.yield.sapling", category, this.fermentedPerSapling);
        property.Comment = "modifies the amount of biomass a sapling will yield in a fermenter.";
        this.fermentedPerSapling = Integer.parseInt(property.Value);
        property = config.get("fermenter.yield.cactus", category, this.fermentedPerCacti);
        property.Comment = "modifies the amount of biomass a piece of cactus will yield in a fermenter.";
        this.fermentedPerCacti = Integer.parseInt(property.Value);
        property = config.get("fermenter.yield.wheat", category, this.fermentedPerWheat);
        property.Comment = "modifies the amount of biomass a piece of wheat will yield in a fermenter.";
        this.fermentedPerWheat = Integer.parseInt(property.Value);
        property = config.get("fermenter.yield.cane", category, this.fermentedPerCane);
        property.Comment = "modifies the amount of biomass a piece of sugar cane will yield in a fermenter.";
        this.fermentedPerCane = Integer.parseInt(property.Value);
        property = config.get("fermenter.yield.mushroom", category, this.fermentedPerMushroom);
        property.Comment = "modifies the amount of biomass a mushroom will yield in a fermenter.";
        this.fermentedPerMushroom = Integer.parseInt(property.Value);
        property = config.get("squeezer.liquid.seed", category, this.squeezedLiquidPerSeed);
        property.Comment = "modifies the amount of seed oil squeezed from a single seed.";
        this.squeezedLiquidPerSeed = Integer.parseInt(property.Value);
        config.save();
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public float getEnergyDemandModifier() {
        return this.energyDemandModifier;
    }

    @Override
    public int getFertilizerFarmValue() {
        return this.fertilizerFarmValue;
    }

    @Override
    public ur getRecipeFertilizerOutputApatite() {
        return this.recipeFertilizerOutputApatite;
    }

    @Override
    public ur getRecipeFertilizerOutputAsh() {
        return this.recipeFertilizerOutputAsh;
    }

    @Override
    public ur getRecipeCompostOutputWheat() {
        return this.recipeCompostOutputWheat;
    }

    @Override
    public ur getRecipeCompostOutputAsh() {
        return this.recipeCompostOutputAsh;
    }

    @Override
    public ur getRecipeHumusOutputFertilizer() {
        return this.recipeHumusOutputFertilizer;
    }

    @Override
    public ur getRecipeHumusOutputCompost() {
        return this.recipeHumusOutputCompost;
    }

    @Override
    public ur getRecipeBogEarthOutputBucket() {
        return this.recipeBogEarthOutputBucket;
    }

    @Override
    public ur getRecipeBogEarthOutputCans() {
        return this.recipeBogEarthOutputCans;
    }

    @Override
    public ur getRecipeCanOutput() {
        return this.recipeCanOutput;
    }

    @Override
    public ur getRecipeCapsuleOutput() {
        return this.recipeCapsuleOutput;
    }

    @Override
    public ur getRecipeRefractoryOutput() {
        return this.recipeRefractoryOutput;
    }

    @Override
    public int getFermentationCyclesFertilizer() {
        return this.fermentationCyclesFertilizer;
    }

    @Override
    public int getFermentationCyclesCompost() {
        return this.fermentationCyclesCompost;
    }

    @Override
    public int getFermentationPerCycleFertilizer() {
        return this.fermentationPerCycleFertilizer;
    }

    @Override
    public int getFermentationPerCycleCompost() {
        return this.fermentationPerCycleCompost;
    }

    @Override
    public int getFermentedPerSapling() {
        return this.fermentedPerSapling;
    }

    @Override
    public int getFermentedPerCacti() {
        return this.fermentedPerCacti;
    }

    @Override
    public int getFermentedPerWheat() {
        return this.fermentedPerWheat;
    }

    @Override
    public int getFermentedPerCane() {
        return this.fermentedPerCane;
    }

    @Override
    public int getFermentedPerMushroom() {
        return this.fermentedPerMushroom;
    }

    @Override
    public int getSqueezedLiquidPerSeed() {
        return this.squeezedLiquidPerSeed;
    }
}

