/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.config.ForestryBlock;
import forestry.core.worldgen.BlockType;
import forestry.core.worldgen.WorldGenBase;

public class WorldGenWillow
extends WorldGenTree {
    public WorldGenWillow(ITreeGenData tree) {
        super(tree);
    }

    @Override
    public void generate() {
        this.generateTreeTrunk(this.height, this.girth, 0.8f);
        this.generateSupportStems(this.height, this.girth, 0.2f, 0.2f);
        int leafSpawn = this.height + 1;
        this.generateCylinder(new WorldGenBase.Vector(0.0f, leafSpawn--, 0.0f), 1.0f, 1, this.leaf, false);
        this.generateCylinder(new WorldGenBase.Vector(0.0f, leafSpawn--, 0.0f), 2.5f, 1, this.leaf, false);
        this.generateCylinder(new WorldGenBase.Vector(0.0f, leafSpawn--, 0.0f), 3.5f, 1, this.leaf, false);
        this.generateCylinder(new WorldGenBase.Vector(0.0f, leafSpawn--, 0.0f), 4.0f, 1, this.leaf, false);
        this.generateCylinder(new WorldGenBase.Vector(0.0f, leafSpawn--, 0.0f), 4.0f, 1, this.leaf, false);
        while (leafSpawn > 2) {
            this.generateCircle(new WorldGenBase.Vector(0.0f, leafSpawn--, 0.0f), 4.0f, 2, 1, this.leaf, false);
        }
        this.generateCircle(new WorldGenBase.Vector(0.0f, leafSpawn--, 0.0f), 4.0f, 1, 1, this.leaf, false);
        this.generateCircle(new WorldGenBase.Vector(0.0f, leafSpawn--, 0.0f), 4.0f, 1, 1, this.leaf, false);
        this.generateCircle(new WorldGenBase.Vector(0.0f, leafSpawn--, 0.0f), 4.0f, 1, 1, this.leaf, 0.4f, false);
    }

    @Override
    public void preGenerate() {
        this.height = this.determineHeight(5, 2);
        this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
    }

    @Override
    public BlockType getWood() {
        return new BlockType(ForestryBlock.log4.cm, 0);
    }
}

