/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.config.ForestryBlock;
import forestry.core.worldgen.BlockType;
import forestry.core.worldgen.WorldGenBase;

public class WorldGenTeak
extends WorldGenTree {
    public WorldGenTeak(ITreeGenData tree) {
        super(tree);
    }

    @Override
    public void generate() {
        this.generateTreeTrunk(this.height, this.girth);
        int leafSpawn = this.height + 1;
        this.generateCylinder(new WorldGenBase.Vector(0.0f, leafSpawn--, 0.0f), 1.0f, 1, this.leaf, false);
        this.generateCylinder(new WorldGenBase.Vector(0.0f, leafSpawn--, 0.0f), 1.5f, 1, this.leaf, false);
        this.generateCylinder(new WorldGenBase.Vector(0.0f, leafSpawn--, 0.0f), 2.9f, 1, this.leaf, false);
        this.generateCylinder(new WorldGenBase.Vector(0.0f, leafSpawn--, 0.0f), 2.9f, 1, this.leaf, false);
        if (this.rand.nextBoolean()) {
            this.generateCylinder(new WorldGenBase.Vector(0.0f, leafSpawn--, 0.0f), 2.9f, 1, this.leaf, false);
        }
        this.generateCylinder(new WorldGenBase.Vector(0.0f, leafSpawn--, 0.0f), 1.5f, 1, this.leaf, false);
    }

    @Override
    public void preGenerate() {
        this.height = this.determineHeight(6, 3);
        this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
    }

    @Override
    public BlockType getWood() {
        return new BlockType(ForestryBlock.log1.cm, 1);
    }
}

