/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.config.ForestryBlock;
import forestry.core.worldgen.BlockType;
import forestry.core.worldgen.WorldGenBase;

public class WorldGenSequoia
extends WorldGenTree {
    public WorldGenSequoia(ITreeGenData tree) {
        super(tree);
    }

    @Override
    public void generate() {
        this.generateTreeTrunk(this.height, this.girth);
        int topLength = this.height / 4;
        int topHeight = this.height - topLength + this.rand.nextInt(this.height / 4);
        int leafSpawn = this.height + 2;
        this.generateCylinder(new WorldGenBase.Vector(0.0f, leafSpawn--, 0.0f), 1.0f, 1, this.leaf, false);
        this.generateCylinder(new WorldGenBase.Vector(0.0f, leafSpawn--, 0.0f), 2.0f, 1, this.leaf, false);
        this.generateCylinder(new WorldGenBase.Vector(0.0f, leafSpawn--, 0.0f), 3.0f, 1, this.leaf, false);
        while (leafSpawn > topHeight) {
            this.generateCylinder(new WorldGenBase.Vector(0.0f, leafSpawn--, 0.0f), 4.0f, 1, this.leaf, false);
        }
        this.generateCylinder(new WorldGenBase.Vector(0.0f, leafSpawn--, 0.0f), 3.0f, 1, this.leaf, false);
        for (int times = 0; times < this.height / 4; ++times) {
            int h = 15 + this.rand.nextInt(this.height - 10);
            if (this.rand.nextBoolean() && h < this.height / 2) {
                h = this.height / 2 + this.rand.nextInt(this.height / 2);
            }
            int x_off = -1 + this.rand.nextInt(3);
            int y_off = -1 + this.rand.nextInt(3);
            this.generateSphere(new WorldGenBase.Vector(x_off, h, y_off), 1 + this.rand.nextInt(2), this.leaf, false);
        }
    }

    @Override
    public void preGenerate() {
        this.height = this.determineHeight(20, 5);
        this.girth = this.determineGirth(this.tree.getGirth(this.world, this.startX, this.startY, this.startZ));
    }

    @Override
    public BlockType getWood() {
        return new BlockType(ForestryBlock.log2.cm, 3);
    }
}

