/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.IAlleleGrowth;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.IGrowthProvider;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IChromosome;
import forestry.arboriculture.genetics.TreeTemplates;
import forestry.core.genetics.Allele;
import forestry.core.genetics.AllelePlantType;
import forestry.core.genetics.Chromosome;
import forestry.core.genetics.Genome;
import java.util.EnumSet;

public class TreeGenome
extends Genome
implements ITreeGenome {
    public TreeGenome(IChromosome[] chromosomes) {
        super(TreeTemplates.getOakTemplate(), chromosomes);
    }

    public TreeGenome(bq nbttagcompound) {
        super(TreeTemplates.getOakTemplate(), nbttagcompound);
    }

    @Override
    public IAlleleSpecies getPrimary() {
        return (IAlleleSpecies)this.getActiveAllele(EnumTreeChromosome.SPECIES.ordinal());
    }

    @Override
    public IAlleleSpecies getSecondary() {
        return (IAlleleSpecies)this.getInactiveAllele(EnumTreeChromosome.SPECIES.ordinal());
    }

    @Override
    public IAlleleTreeSpecies getPrimaryAsTree() {
        return (IAlleleTreeSpecies)this.getActiveAllele(EnumTreeChromosome.SPECIES.ordinal());
    }

    @Override
    public IAlleleTreeSpecies getSecondaryAsTree() {
        return (IAlleleTreeSpecies)this.getInactiveAllele(EnumTreeChromosome.SPECIES.ordinal());
    }

    @Override
    public IFruitProvider getFruitProvider() {
        return ((IAlleleFruit)this.getActiveAllele(EnumTreeChromosome.FRUITS.ordinal())).getProvider();
    }

    @Override
    public IGrowthProvider getGrowthProvider() {
        return ((IAlleleGrowth)this.getActiveAllele(EnumTreeChromosome.GROWTH.ordinal())).getProvider();
    }

    @Override
    public float getHeight() {
        return ((IAlleleFloat)this.getActiveAllele(EnumTreeChromosome.HEIGHT.ordinal())).getValue();
    }

    @Override
    public float getFertility() {
        return ((IAlleleFloat)this.getActiveAllele(EnumTreeChromosome.FERTILITY.ordinal())).getValue();
    }

    @Override
    public float getYield() {
        return ((IAlleleFloat)this.getActiveAllele(EnumTreeChromosome.YIELD.ordinal())).getValue();
    }

    @Override
    public float getSappiness() {
        IAllele allele;
        if (this.getChromosomes()[EnumTreeChromosome.SAPPINESS.ordinal()] == null) {
            this.getChromosomes()[EnumTreeChromosome.SAPPINESS.ordinal()] = new Chromosome(Allele.sappinessLowest);
        }
        if ((allele = this.getActiveAllele(EnumTreeChromosome.SAPPINESS.ordinal())) instanceof IAlleleFloat) {
            return ((IAlleleFloat)allele).getValue();
        }
        this.getChromosomes()[EnumTreeChromosome.SAPPINESS.ordinal()] = new Chromosome(Allele.sappinessLowest);
        return 0.1f;
    }

    @Override
    public EnumSet getPlantTypes() {
        if (!(this.getActiveAllele(EnumTreeChromosome.PLANT.ordinal()) instanceof AllelePlantType)) {
            this.getChromosomes()[EnumTreeChromosome.PLANT.ordinal()] = new Chromosome(Allele.plantTypeNone);
        }
        return ((AllelePlantType)this.getActiveAllele(EnumTreeChromosome.PLANT.ordinal())).getPlantTypes();
    }

    @Override
    public int getMaturationTime() {
        if (this.getChromosomes()[EnumTreeChromosome.MATURATION.ordinal()] == null) {
            this.getChromosomes()[EnumTreeChromosome.MATURATION.ordinal()] = new Chromosome(Allele.maturationSlowest);
        }
        return ((IAlleleInteger)this.getActiveAllele(EnumTreeChromosome.MATURATION.ordinal())).getValue();
    }
}

