/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.EnumGrowthConditions;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreeMutation;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IGenome;
import forestry.api.world.ITreeGenData;
import forestry.arboriculture.genetics.TreeGenome;
import forestry.core.genetics.Chromosome;
import forestry.core.genetics.Individual;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.IPlantable;

public class Tree
extends Individual
implements ITree,
ITreeGenData,
IPlantable {
    private ITreeGenome genome;
    private ITreeGenome mate;
    private EnumPlantType plantType;

    public Tree(bq nbttagcompound) {
        this.readFromNBT(nbttagcompound);
    }

    public Tree(ITreeGenome genome) {
        this.genome = genome;
    }

    public Tree(yc world, ITreeGenome genome) {
        this.genome = genome;
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound.b("Genome")) {
            this.genome = new TreeGenome(nbttagcompound.l("Genome"));
        }
        if (nbttagcompound.b("Mate")) {
            this.mate = new TreeGenome(nbttagcompound.l("Mate"));
        }
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        bq NBTmachine;
        super.writeToNBT(nbttagcompound);
        if (this.genome != null) {
            NBTmachine = new bq();
            this.genome.writeToNBT(NBTmachine);
            nbttagcompound.a("Genome", (cd)NBTmachine);
        }
        if (this.mate != null) {
            NBTmachine = new bq();
            this.mate.writeToNBT(NBTmachine);
            nbttagcompound.a("Mate", (cd)NBTmachine);
        }
    }

    @Override
    public void mate(ITree other) {
        this.mate = new TreeGenome(other.getGenome().getChromosomes());
    }

    @Override
    public IEffectData[] doEffect(IEffectData[] storedData, yc world, int biomeid, int x, int y2, int z) {
        return null;
    }

    @Override
    public IEffectData[] doFX(IEffectData[] storedData, yc world, int biomeid, int x, int y2, int z) {
        return null;
    }

    @Override
    public abm getTreeGenerator(yc world, int x, int y2, int z, boolean wasBonemealed) {
        return this.genome.getPrimaryAsTree().getGenerator(this, world, x, y2, z);
    }

    @Override
    public boolean canStay(yc world, int x, int y2, int z) {
        amq block = amq.p[world.a(x, y2 - 1, z)];
        if (block == null) {
            return false;
        }
        Iterator i$ = this.getPlantTypes().iterator();
        while (i$.hasNext()) {
            EnumPlantType type;
            this.plantType = type = (EnumPlantType)i$.next();
            if (!block.canSustainPlant(world, x, y2 - 1, z, ForgeDirection.UP, (IPlantable)this)) continue;
            return true;
        }
        return false;
    }

    public EnumPlantType getPlantType(yc world, int x, int y2, int z) {
        return this.plantType;
    }

    public int getPlantID(yc world, int x, int y2, int z) {
        return 0;
    }

    public int getPlantMetadata(yc world, int x, int y2, int z) {
        return 0;
    }

    @Override
    public boolean canGrow(yc world, int x, int y2, int z, int expectedGirth, int expectedHeight) {
        return this.genome.getGrowthProvider().canGrow(this.genome, world, x, y2, z, expectedGirth, expectedHeight);
    }

    @Override
    public int getRequiredMaturity() {
        return this.genome.getMaturationTime();
    }

    @Override
    public EnumGrowthConditions getGrowthCondition(yc world, int x, int y2, int z) {
        return this.genome.getGrowthProvider().getGrowthConditions(this.getGenome(), world, x, y2, z);
    }

    @Override
    public int getGirth(yc world, int x, int y2, int z) {
        return this.genome.getPrimaryAsTree().getGirth();
    }

    @Override
    public float getHeightModifier() {
        return this.genome.getHeight();
    }

    @Override
    public void setLeaves(yc world, int x, int y2, int z) {
        TreeManager.treeInterface.setLeaves(world, this, x, y2, z);
    }

    @Override
    public String getIdent() {
        return this.genome.getPrimary().getUID();
    }

    @Override
    public String getDisplayName() {
        return this.genome.getPrimary().getName();
    }

    @Override
    public ITreeGenome getMate() {
        return this.mate;
    }

    @Override
    public ITreeGenome getGenome() {
        return this.genome;
    }

    @Override
    public boolean isPureBred(EnumTreeChromosome chromosome) {
        return this.genome.getActiveAllele(chromosome.ordinal()).getUID().equals(this.genome.getInactiveAllele(chromosome.ordinal()).getUID());
    }

    @Override
    public EnumSet getPlantTypes() {
        EnumSet tolerated = this.genome.getPlantTypes();
        tolerated.add(this.genome.getPrimaryAsTree().getPlantType());
        return tolerated;
    }

    @Override
    public void addTooltip(List list) {
        if (!this.isAnalyzed) {
            list.add("<" + StringUtil.localize("gui.unknown") + ">");
            return;
        }
        IAlleleTreeSpecies primary = this.genome.getPrimaryAsTree();
        IAlleleTreeSpecies secondary = this.genome.getSecondaryAsTree();
        if (!this.isPureBred(EnumTreeChromosome.SPECIES)) {
            list.add("\u00a79" + primary.getName() + "-" + secondary.getName() + " " + StringUtil.localize("gui.hybrid"));
        }
        list.add("H: " + Tree.rateHeight(this.genome.getHeight()));
        list.add("\u00a7aF: " + StringUtil.localize(this.genome.getFruitProvider().getDescription()));
    }

    @Override
    public ITree[] getSaplings(yc world, int x, int y2, int z, float modifier) {
        ArrayList<ITree> prod = new ArrayList<ITree>();
        float chance = this.genome.getFertility() * modifier;
        if (world.t.nextFloat() <= chance) {
            if (this.getMate() == null) {
                prod.add(TreeManager.treeInterface.getTree(world, new TreeGenome(this.genome.getChromosomes())));
            } else {
                prod.add(this.createOffspring(world, x, y2, z));
            }
        }
        return prod.toArray(new ITree[0]);
    }

    private ITree createOffspring(yc world, int x, int y2, int z) {
        IChromosome[] chromosomes = new IChromosome[this.genome.getChromosomes().length];
        IChromosome[] parent1 = this.genome.getChromosomes();
        IChromosome[] parent2 = this.mate.getChromosomes();
        IChromosome[] mutated = this.mutateSpecies(world, x, y2, z, this.genome, this.mate);
        if (mutated == null) {
            mutated = this.mutateSpecies(world, x, y2, z, this.mate, this.genome);
        }
        if (mutated != null) {
            return new Tree(world, new TreeGenome(mutated));
        }
        for (int i = 0; i < parent1.length; ++i) {
            if (parent1[i] == null || parent2[i] == null) continue;
            chromosomes[i] = Chromosome.inheritChromosome(world.t, parent1[i], parent2[i]);
        }
        return new Tree(world, new TreeGenome(chromosomes));
    }

    private IChromosome[] mutateSpecies(yc world, int x, int y2, int z, IGenome genomeOne, IGenome genomeTwo) {
        IGenome genome1;
        IGenome genome0;
        IAllele allele1;
        IAllele allele0;
        IChromosome[] parent1 = genomeOne.getChromosomes();
        IChromosome[] parent2 = genomeTwo.getChromosomes();
        if (world.t.nextBoolean()) {
            allele0 = parent1[EnumTreeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = parent2[EnumTreeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeOne;
            genome1 = genomeTwo;
        } else {
            allele0 = parent2[EnumTreeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = parent1[EnumTreeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeTwo;
            genome1 = genomeOne;
        }
        Collections.shuffle(TreeManager.treeMutations);
        for (ITreeMutation mutation : TreeManager.treeMutations) {
            int chance = 0;
            chance = mutation.getChance(world, x, y2, z, allele0, allele1, genome0, genome1);
            if (chance <= 0 || world.t.nextInt(100) >= chance) continue;
            return TreeManager.treeInterface.templateAsChromosomes(mutation.getTemplate());
        }
        return null;
    }

    @Override
    public boolean canBearFruit() {
        return this.genome.getPrimaryAsTree().getSuitableFruit().contains(this.genome.getFruitProvider().getFamily());
    }

    @Override
    public ur[] getProduceList() {
        return this.genome.getFruitProvider().getProducts();
    }

    @Override
    public ur[] getSpecialtyList() {
        return this.genome.getFruitProvider().getSpecialty();
    }

    @Override
    public ur[] produceStacks(yc world, int x, int y2, int z, int ripeningTime) {
        return this.genome.getFruitProvider().getFruits(this.genome, world, x, y2, z, ripeningTime);
    }

    @Override
    public ITree copy() {
        bq nbttagcompound = new bq();
        this.writeToNBT(nbttagcompound);
        return new Tree(nbttagcompound);
    }

    public static String rateHeight(float height) {
        if (height >= 2.0f) {
            return StringUtil.localize("gui.gigantic");
        }
        if (height >= 1.75f) {
            return StringUtil.localize("gui.largest");
        }
        if (height >= 1.5f) {
            return StringUtil.localize("gui.larger");
        }
        if (height >= 1.25f) {
            return StringUtil.localize("gui.large");
        }
        if (height >= 1.0f) {
            return StringUtil.localize("gui.average");
        }
        if (height >= 0.75f) {
            return StringUtil.localize("gui.small");
        }
        if (height >= 0.5f) {
            return StringUtil.localize("gui.smaller");
        }
        return StringUtil.localize("gui.smallest");
    }

    public static String rateFertility(float height) {
        if (height >= 0.3f) {
            return StringUtil.localize("gui.triple");
        }
        if (height >= 0.2f) {
            return StringUtil.localize("gui.double");
        }
        return StringUtil.localize("gui.normal");
    }

    public static String rateYield(float yield) {
        if (yield >= 0.35f) {
            return StringUtil.localize("gui.largest");
        }
        if (yield >= 0.3f) {
            return StringUtil.localize("gui.larger");
        }
        if (yield >= 0.25f) {
            return StringUtil.localize("gui.large");
        }
        if ((double)yield >= 0.2) {
            return StringUtil.localize("gui.normal");
        }
        if (yield >= 0.15f) {
            return StringUtil.localize("gui.low");
        }
        if (yield >= 0.1f) {
            return StringUtil.localize("gui.lower");
        }
        return StringUtil.localize("gui.lowest");
    }

    public static String rateSappiness(float sappiness) {
        if (sappiness >= 0.35f) {
            return StringUtil.localize("gui.highest");
        }
        if (sappiness >= 0.3f) {
            return StringUtil.localize("gui.higher");
        }
        if (sappiness >= 0.25f) {
            return StringUtil.localize("gui.high");
        }
        if ((double)sappiness >= 0.2) {
            return StringUtil.localize("gui.average");
        }
        if (sappiness >= 0.15f) {
            return StringUtil.localize("gui.low");
        }
        if (sappiness >= 0.1f) {
            return StringUtil.localize("gui.lower");
        }
        return StringUtil.localize("gui.lowest");
    }

    public static String rateMaturity(int maturity) {
        if (maturity >= 8) {
            return StringUtil.localize("gui.slowestspeed");
        }
        if (maturity >= 7) {
            return StringUtil.localize("gui.slowerspeed");
        }
        if (maturity >= 6) {
            return StringUtil.localize("gui.slowspeed");
        }
        if (maturity >= 5) {
            return StringUtil.localize("gui.normalspeed");
        }
        if (maturity >= 4) {
            return StringUtil.localize("gui.fastspeed");
        }
        if (maturity >= 3) {
            return StringUtil.localize("gui.fasterspeed");
        }
        return StringUtil.localize("gui.fastestspeed");
    }
}

