/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITree;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IFruitFamily;
import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenBalsa;
import forestry.core.genetics.AlleleSpecies;
import java.util.ArrayList;
import net.minecraftforge.common.EnumPlantType;

public class AlleleTreeSpecies
extends AlleleSpecies
implements IAlleleTreeSpecies {
    private Class generatorClass = WorldGenBalsa.class;
    private int iconIndexFancy = 48;
    private int iconIndexPlain = 64;
    private int iconIndexChanged = 80;
    private int girth = 1;
    private EnumPlantType nativeType = EnumPlantType.Plains;
    private ArrayList fruits = new ArrayList();

    public AlleleTreeSpecies(String uid, boolean isDominant, String name, IClassification branch, String binomial, int primaryColor, int secondaryColor) {
        super(uid, isDominant, name, branch, binomial, primaryColor, secondaryColor);
    }

    public AlleleTreeSpecies(String uid, boolean isDominant, String name, IClassification branch, String binomial, int primaryColor, int secondaryColor, Class generator) {
        super(uid, isDominant, name, branch, binomial, primaryColor, secondaryColor);
        this.generatorClass = generator;
    }

    public AlleleTreeSpecies setPlantType(EnumPlantType type) {
        this.nativeType = type;
        return this;
    }

    public AlleleTreeSpecies setGirth(int girth) {
        this.girth = girth;
        return this;
    }

    public AlleleTreeSpecies addFruitFamily(IFruitFamily family) {
        this.fruits.add(family);
        return this;
    }

    public AlleleTreeSpecies setLeafIndices(int fancy, int plain, int changed) {
        this.iconIndexFancy = fancy;
        this.iconIndexPlain = plain;
        this.iconIndexChanged = changed;
        return this;
    }

    @Override
    public EnumPlantType getPlantType() {
        return this.nativeType;
    }

    @Override
    public ArrayList getSuitableFruit() {
        return this.fruits;
    }

    @Override
    public int getGirth() {
        return this.girth;
    }

    @Override
    public abm getGenerator(ITree tree, yc world, int x, int y2, int z) {
        try {
            return (abm)this.generatorClass.getConstructor(ITreeGenData.class).newInstance(tree);
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to instantiate generator of class " + this.generatorClass.getName());
        }
    }

    @Override
    public Class[] getGeneratorClasses() {
        return new Class[]{this.generatorClass};
    }

    @Override
    public int getLeafTextureIndex(ITree tree, boolean fancy) {
        if (!fancy) {
            return this.iconIndexPlain;
        }
        if (tree.getMate() != null) {
            return this.iconIndexChanged;
        }
        return this.iconIndexFancy;
    }

    @Override
    public int getGermlingIconIndex(EnumGermlingType type) {
        return this.getBodyType();
    }

    public AlleleTreeSpecies setGenerator(Class generatorClass) {
        this.generatorClass = generatorClass;
        return this;
    }
}

