/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.IToolGrafter;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.arboriculture.gadgets.BlockTreeContainer;
import forestry.arboriculture.gadgets.TileLeaves;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StackUtils;
import forestry.plugins.PluginForestryArboriculture;
import java.util.ArrayList;
import java.util.Random;
import net.minecraftforge.common.ForgeDirection;

public class BlockLeaves
extends BlockTreeContainer {
    int[] adjacentTreeBlocks;

    public BlockLeaves(int id) {
        super(id, agi.j);
        this.setTextureFile("/gfx/forestry/blocks/arboriculture.png");
        this.b(true);
        this.r();
        this.c(0.2f);
        this.h(1);
        this.a(g);
    }

    public static TileLeaves getLeafTile(ym world, int x, int y2, int z) {
        any tile = world.q(x, y2, z);
        if (!(tile instanceof TileLeaves)) {
            return null;
        }
        return (TileLeaves)tile;
    }

    public any a(yc world) {
        return new TileLeaves();
    }

    public boolean removeBlockByPlayer(yc world, qx player, int x, int y2, int z) {
        int metadata = world.h(x, y2, z);
        if (Proxies.common.isSimulating(world) && this.canHarvestBlock(player, metadata)) {
            ur held = player.bJ.g();
            float saplingModifier = 1.0f;
            if (held != null && held.b() instanceof IToolGrafter) {
                saplingModifier = ((IToolGrafter)held.b()).getSaplingModifier(held, world, x, y2, z);
            }
            this.spawnLeafDrops(world, x, y2, z, metadata, saplingModifier);
        }
        return world.e(x, y2, z, 0);
    }

    public ArrayList getBlockDropped(yc world, int x, int y2, int z, int metadata, int fortune) {
        return new ArrayList();
    }

    private void removeLeaves(yc world, int x, int y2, int z) {
        this.spawnLeafDrops(world, x, y2, z, world.h(x, y2, z), 1.0f);
        world.e(x, y2, z, 0);
    }

    private void spawnLeafDrops(yc world, int x, int y2, int z, int metadata, float saplingModifier) {
        for (ur drop : this.getLeafDrop(world, x, y2, z, metadata, saplingModifier)) {
            if (drop == null) continue;
            StackUtils.dropItemStackAsEntity(drop, world, x, y2, z);
        }
    }

    private ArrayList getLeafDrop(yc world, int x, int y2, int z, int metadata, float saplingModifier) {
        ITree[] saplings;
        ArrayList<Object> prod = new ArrayList<Object>();
        TileLeaves tile = BlockLeaves.getLeafTile((ym)world, x, y2, z);
        if (tile == null) {
            return prod;
        }
        if (tile.getTree() == null) {
            return prod;
        }
        for (ITree iTree : saplings = tile.getTree().getSaplings(world, x, y2, z, saplingModifier)) {
            if (iTree == null) continue;
            prod.add(TreeManager.treeInterface.getGermlingStack(iTree, EnumGermlingType.SAPLING));
        }
        if (tile.hasFruit()) {
            for (ITree iTree : tile.getTree().produceStacks(world, x, y2, z, tile.getRipeningTime())) {
                prod.add(iTree);
            }
        }
        return prod;
    }

    public boolean c() {
        return !Proxies.render.fancyGraphicsEnabled();
    }

    public int d() {
        return PluginForestryArboriculture.modelIdLeaves;
    }

    @SideOnly(value=Side.CLIENT)
    public int o() {
        double var1 = 0.5;
        double var3 = 1.0;
        return xy.a((double)var1, (double)var3);
    }

    @SideOnly(value=Side.CLIENT)
    public int b(ym world, int x, int y2, int z) {
        TileLeaves leaves = BlockLeaves.getLeafTile(world, x, y2, z);
        if (leaves == null) {
            return xy.c();
        }
        int colour = leaves.getFoliageColour();
        if (colour == PluginForestryArboriculture.proxy.getFoliageColorBasic()) {
            colour = world.a(x, z).l();
        }
        return colour;
    }

    public int d(ym world, int x, int y2, int z, int side) {
        TileLeaves leaves = BlockLeaves.getLeafTile(world, x, y2, z);
        if (leaves != null) {
            return leaves.getTextureIndex(Proxies.render.fancyGraphicsEnabled());
        }
        return 48;
    }

    @Override
    public void b(yc world, int x, int y2, int z, Random random) {
        super.b(world, x, y2, z, random);
        if (!Proxies.common.isSimulating(world)) {
            return;
        }
        int meta = world.h(x, y2, z);
        if ((meta & 8) != 0 && (meta & 4) == 0) {
            int var12;
            int offset = 4;
            int shift = offset + 1;
            int var9 = 32;
            int var10 = var9 * var9;
            int var11 = var9 / 2;
            if (this.adjacentTreeBlocks == null) {
                this.adjacentTreeBlocks = new int[var9 * var9 * var9];
            }
            if (world.d(x - shift, y2 - shift, z - shift, x + shift, y2 + shift, z + shift)) {
                int var15;
                int var14;
                int var13;
                for (var12 = -offset; var12 <= offset; ++var12) {
                    for (var13 = -offset; var13 <= offset; ++var13) {
                        for (var14 = -offset; var14 <= offset; ++var14) {
                            var15 = world.a(x + var12, y2 + var13, z + var14);
                            amq block = amq.p[var15];
                            this.adjacentTreeBlocks[(var12 + var11) * var10 + (var13 + var11) * var9 + var14 + var11] = block != null && block.canSustainLeaves(world, x + var12, y2 + var13, z + var14) ? 0 : (block != null && block.isLeaves(world, x + var12, y2 + var13, z + var14) ? -2 : -1);
                        }
                    }
                }
                for (var12 = 1; var12 <= 4; ++var12) {
                    for (var13 = -offset; var13 <= offset; ++var13) {
                        for (var14 = -offset; var14 <= offset; ++var14) {
                            for (var15 = -offset; var15 <= offset; ++var15) {
                                if (this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11) * var9 + var15 + var11] != var12 - 1) continue;
                                if (this.adjacentTreeBlocks[(var13 + var11 - 1) * var10 + (var14 + var11) * var9 + var15 + var11] == -2) {
                                    this.adjacentTreeBlocks[(var13 + var11 - 1) * var10 + (var14 + var11) * var9 + var15 + var11] = var12;
                                }
                                if (this.adjacentTreeBlocks[(var13 + var11 + 1) * var10 + (var14 + var11) * var9 + var15 + var11] == -2) {
                                    this.adjacentTreeBlocks[(var13 + var11 + 1) * var10 + (var14 + var11) * var9 + var15 + var11] = var12;
                                }
                                if (this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11 - 1) * var9 + var15 + var11] == -2) {
                                    this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11 - 1) * var9 + var15 + var11] = var12;
                                }
                                if (this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11 + 1) * var9 + var15 + var11] == -2) {
                                    this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11 + 1) * var9 + var15 + var11] = var12;
                                }
                                if (this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11) * var9 + (var15 + var11 - 1)] == -2) {
                                    this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11) * var9 + (var15 + var11 - 1)] = var12;
                                }
                                if (this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11) * var9 + var15 + var11 + 1] != -2) continue;
                                this.adjacentTreeBlocks[(var13 + var11) * var10 + (var14 + var11) * var9 + var15 + var11 + 1] = var12;
                            }
                        }
                    }
                }
            }
            if ((var12 = this.adjacentTreeBlocks[var11 * var10 + var11 * var9 + var11]) >= 0) {
                world.d(x, y2, z, meta & 0xFFFFFFF7);
            } else {
                this.removeLeaves(world, x, y2, z);
            }
        }
    }

    public void a(yc world, int x, int y2, int z, int par5, int par6) {
        int offset = 1;
        int shift = offset + 1;
        if (world.d(x - shift, y2 - shift, z - shift, x + shift, y2 + shift, z + shift)) {
            for (int i = -offset; i <= offset; ++i) {
                for (int j = -offset; j <= offset; ++j) {
                    for (int k = -offset; k <= offset; ++k) {
                        int block = world.a(x + i, y2 + j, z + k);
                        if (amq.p[block] == null) continue;
                        amq.p[block].beginLeavesDecay(world, x + i, y2 + j, z + k);
                    }
                }
            }
        }
        super.a(world, x, y2, z, par5, par6);
    }

    public void beginLeavesDecay(yc world, int x, int y2, int z) {
        world.d(x, y2, z, world.h(x, y2, z) | 8);
    }

    public int getFlammability(ym world, int x, int y2, int z, int metadata, ForgeDirection face) {
        return 60;
    }

    public boolean isFlammable(ym world, int x, int y2, int z, int metadata, ForgeDirection face) {
        return true;
    }

    public int getFireSpreadSpeed(yc world, int x, int y2, int z, int metadata, ForgeDirection face) {
        if (face == ForgeDirection.DOWN) {
            return 20;
        }
        if (face != ForgeDirection.UP) {
            return 10;
        }
        return 5;
    }

    public boolean isLeaves(yc world, int x, int y2, int z) {
        return true;
    }
}

