/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.arboriculture.ITreeGenome;
import forestry.api.genetics.IFruitFamily;
import forestry.arboriculture.FruitProviderNone;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class FruitProviderRandom
extends FruitProviderNone {
    String key;
    IFruitFamily family;
    HashMap products = new HashMap();
    int textureIndex;
    int colour = 0xFFFFFF;

    public FruitProviderRandom(String key, IFruitFamily family, ur product, float modifier, int textureIndex) {
        this.key = key;
        this.family = family;
        this.products.put(product, Float.valueOf(modifier));
        this.textureIndex = textureIndex;
    }

    public FruitProviderRandom setColour(int colour) {
        this.colour = colour;
        return this;
    }

    @Override
    public IFruitFamily getFamily() {
        return this.family;
    }

    @Override
    public String getDescription() {
        return "fruits." + this.key;
    }

    @Override
    public int getColour(ITreeGenome genome, ym world, int x, int y2, int z, int ripeningTime) {
        return this.colour;
    }

    @Override
    public ur[] getFruits(ITreeGenome genome, yc world, int x, int y2, int z, int ripeningTime) {
        ArrayList<ur> product = new ArrayList<ur>();
        for (Map.Entry entry : this.products.entrySet()) {
            if (!(world.t.nextFloat() <= genome.getYield() * ((Float)entry.getValue()).floatValue())) continue;
            product.add(((ur)entry.getKey()).l());
        }
        return product.toArray(new ur[0]);
    }

    @Override
    public ur[] getProducts() {
        return this.products.keySet().toArray(new ur[0]);
    }

    @Override
    public ur[] getSpecialty() {
        return new ur[0];
    }

    @Override
    public boolean markAsFruitLeaf(ITreeGenome genome, yc world, int x, int y2, int z) {
        return true;
    }

    @Override
    public int getTextureIndex(ITreeGenome genome, ym world, int x, int y2, int z, int ripeningTime, boolean fancy) {
        return this.textureIndex;
    }
}

