/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IAlleleBeeEffect;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.core.genetics.Allele;
import forestry.core.genetics.EffectData;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Vect;
import forestry.plugins.PluginForestryApiculture;

public abstract class AlleleEffectThrottled
extends Allele
implements IAlleleBeeEffect {
    private String name;
    private boolean isCombinable = false;
    private int throttle;

    public AlleleEffectThrottled(String uid, String name, boolean isDominant, int throttle, boolean isCombinable) {
        super(uid, isDominant);
        this.name = "apiculture.effect." + name;
        this.throttle = throttle;
        this.isCombinable = isCombinable;
    }

    @Override
    public String getIdentifier() {
        return StringUtil.localize(this.name);
    }

    public int getThrottle() {
        return this.throttle;
    }

    @Override
    public boolean isCombinable() {
        return this.isCombinable;
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData instanceof EffectData) {
            return storedData;
        }
        return new EffectData(1, 0);
    }

    public boolean isThrottled(IEffectData storedData) {
        int throttle = storedData.getInteger(0);
        storedData.setInteger(0, ++throttle);
        if (throttle < this.getThrottle()) {
            return true;
        }
        storedData.setInteger(0, 0);
        return false;
    }

    @Override
    public IEffectData doFX(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        int[] area = this.getModifiedArea(genome, housing);
        PluginForestryApiculture.proxy.addBeeHiveFX("/gfx/forestry/particles/swarm_bee.png", housing.getWorld(), housing.getXCoord(), housing.getYCoord(), housing.getZCoord(), genome.getPrimaryAsBee().getPrimaryColor(), area[0], area[1], area[2]);
        return storedData;
    }

    @Override
    public String getIconTextureFile() {
        return null;
    }

    @Override
    public int getIconIndex() {
        return -1;
    }

    protected int[] getModifiedArea(IBeeGenome genome, IBeeHousing housing) {
        int[] area = genome.getTerritory();
        area[0] = (int)((float)area[0] * (housing.getTerritoryModifier(genome) * 3.0f));
        area[1] = (int)((float)area[1] * (housing.getTerritoryModifier(genome) * 3.0f));
        area[2] = (int)((float)area[2] * (housing.getTerritoryModifier(genome) * 3.0f));
        if (area[0] < 1) {
            area[0] = 1;
        }
        if (area[1] < 1) {
            area[1] = 1;
        }
        if (area[2] < 1) {
            area[2] = 1;
        }
        return area;
    }

    protected aoe getBounding(IBeeGenome genome, IBeeHousing housing, float modifier) {
        int[] areaAr = genome.getTerritory();
        Vect area = new Vect(areaAr[0], areaAr[1], areaAr[2]).multiply(modifier);
        Vect offset = new Vect(-Math.round(area.x / 2), -Math.round(area.y / 2), -Math.round(area.z / 2));
        Vect min = new Vect(housing.getXCoord() + offset.x, housing.getYCoord() + offset.y, housing.getZCoord() + offset.z);
        Vect max = new Vect(housing.getXCoord() + offset.x + area.x, housing.getYCoord() + offset.y + area.y, housing.getZCoord() + offset.z + area.z);
        return aoe.a().a((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
    }
}

