/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.AlleleEffectThrottled;
import forestry.apiculture.items.ItemArmorApiarist;
import forestry.core.genetics.EffectData;
import java.util.List;

public class AlleleEffectCreeper
extends AlleleEffectThrottled {
    private int explosionChance = 50;
    byte defaultForce = (byte)12;
    byte indexExplosionTimer = 1;
    byte indexExplosionForce = (byte)2;

    public AlleleEffectCreeper(String uid) {
        super(uid, "creeper", true, 20, true);
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (!(storedData instanceof EffectData)) {
            return new EffectData(3, 0);
        }
        if (((EffectData)storedData).getIntSize() < 3) {
            return new EffectData(3, 0);
        }
        return storedData;
    }

    @Override
    public IEffectData doEffect(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        yc world = housing.getWorld();
        if (this.isThrottled(storedData)) {
            return storedData;
        }
        if (storedData.getInteger(this.indexExplosionTimer) > 0) {
            this.progressExplosion(storedData, world, housing.getXCoord(), housing.getYCoord(), housing.getZCoord());
            return storedData;
        }
        aoe infectionBox = this.getBounding(genome, housing, 1.0f);
        List list = world.a(qx.class, infectionBox);
        for (Object obj : list) {
            qx player = (qx)obj;
            int chance = this.explosionChance;
            storedData.setInteger(this.indexExplosionForce, this.defaultForce);
            int count = ItemArmorApiarist.wearsItems(player);
            if (count > 3) continue;
            if (count > 2) {
                chance = 5;
                storedData.setInteger(this.indexExplosionForce, 6);
            } else if (count > 1) {
                chance = 20;
                storedData.setInteger(this.indexExplosionForce, 8);
            } else if (count > 0) {
                chance = 35;
                storedData.setInteger(this.indexExplosionForce, 10);
            }
            if (world.t.nextInt(1000) >= chance) continue;
            world.a((double)housing.getXCoord(), (double)housing.getYCoord(), (double)housing.getZCoord(), "mob.creeper", 4.0f, (1.0f + (world.t.nextFloat() - world.t.nextFloat()) * 0.2f) * 0.7f);
            storedData.setInteger(this.indexExplosionTimer, 2);
        }
        return storedData;
    }

    private void progressExplosion(IEffectData storedData, yc world, int x, int y2, int z) {
        int explosionTimer = storedData.getInteger(this.indexExplosionTimer);
        storedData.setInteger(this.indexExplosionTimer, --explosionTimer);
        if (explosionTimer > 0) {
            return;
        }
        world.a(null, (double)x, (double)y2, (double)z, (float)storedData.getInteger(this.indexExplosionForce), false);
    }
}

