/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import buildcraft.api.inventory.ISpecialInventory;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlvearyComponent;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.core.ForestryAPI;
import forestry.apiculture.gadgets.TileAlveary;
import forestry.apiculture.worldgen.WorldGenHive;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.TileInventoryAdapter;
import java.util.Map;
import java.util.Stack;
import net.minecraftforge.common.ForgeDirection;

public class TileAlvearySwarmer
extends TileAlveary
implements ISpecialInventory {
    public static final int TEXTURE_OFF = 55;
    public static final int TEXTURE_ON = 56;
    TileInventoryAdapter swarmerInventory;
    private Stack pendingSpawns = new Stack();

    public TileAlvearySwarmer() {
        super(2);
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.swarmerInventory == null) {
            this.createInventory();
        }
    }

    @Override
    public void openGui(qx player) {
        player.openGui(ForestryAPI.instance, GuiId.AlvearySwarmerGUI.ordinal(), this.k, this.l, this.m, this.n);
    }

    @Override
    protected void updateServerSide() {
        super.updateServerSide();
        if (this.k.G() % 100L != 0L && this.pendingSpawns.size() > 0) {
            this.trySpawnSwarm();
        }
        if (this.k.G() % 500L != 0L) {
            return;
        }
        if (!this.hasMaster()) {
            return;
        }
        IAlvearyComponent master = (IAlvearyComponent)this.getCentralTE();
        if (!(master instanceof IBeeHousing)) {
            return;
        }
        IBeeHousing housing = (IBeeHousing)((Object)master);
        ur queenstack = housing.getQueen();
        if (queenstack == null) {
            return;
        }
        if (!BeeManager.beeInterface.isMated(queenstack)) {
            return;
        }
        int slot = this.getInducerSlot();
        if (slot < 0) {
            return;
        }
        int chance = this.getChanceFor(this.swarmerInventory.a(slot));
        this.swarmerInventory.a(slot, 1);
        if (this.k.t.nextInt(1000) >= chance) {
            return;
        }
        IBee spawn = BeeManager.beeInterface.getBee(queenstack);
        spawn.setIsNatural(false);
        this.pendingSpawns.push(BeeManager.beeInterface.getBeeStack(spawn, EnumBeeType.PRINCESS));
    }

    private int getChanceFor(ur stack) {
        for (Map.Entry entry : BeeManager.inducers.entrySet()) {
            if (!((ur)entry.getKey()).a(stack)) continue;
            return (Integer)entry.getValue();
        }
        return 0;
    }

    private int getInducerSlot() {
        for (int i = 0; i < this.swarmerInventory.k_(); ++i) {
            if (this.swarmerInventory.a(i) == null) continue;
            for (Map.Entry entry : BeeManager.inducers.entrySet()) {
                if (!((ur)entry.getKey()).a(this.swarmerInventory.a(i))) continue;
                return i;
            }
        }
        return -1;
    }

    private void trySpawnSwarm() {
        ur toSpawn = (ur)this.pendingSpawns.peek();
        WorldGenHive generator = new WorldGenHive(new ur[]{toSpawn});
        for (int i = 0; i < 10; ++i) {
            int spawnZ;
            int spawnY;
            int spawnX = this.l + this.k.t.nextInt(80) - 40;
            if (!generator.a(this.k, this.k.t, spawnX, spawnY = this.m + this.k.t.nextInt(40), spawnZ = this.n + this.k.t.nextInt(80) - 40)) continue;
            this.pendingSpawns.pop();
            break;
        }
    }

    @Override
    public boolean hasFunction() {
        return true;
    }

    @Override
    public int getBlockTexture(int side, int metadata) {
        if (this.pendingSpawns.size() > 0) {
            return 56;
        }
        return 55;
    }

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        if (this.swarmerInventory == null) {
            this.createInventory();
        }
        this.swarmerInventory.readFromNBT(nbttagcompound);
        by nbttaglist = nbttagcompound.m("PendingSpawns");
        for (int i = 0; i < nbttaglist.c(); ++i) {
            bq nbttagcompound1 = (bq)nbttaglist.b(i);
            this.pendingSpawns.add(ur.a((bq)nbttagcompound1));
        }
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        if (this.swarmerInventory != null) {
            this.swarmerInventory.writeToNBT(nbttagcompound);
        }
        by nbttaglist = new by();
        ur[] offspring = this.pendingSpawns.toArray(new ur[this.pendingSpawns.size()]);
        for (int i = 0; i < offspring.length; ++i) {
            if (offspring[i] == null) continue;
            bq nbttagcompound1 = new bq();
            nbttagcompound1.a("Slot", (byte)i);
            offspring[i].b(nbttagcompound1);
            nbttaglist.a((cd)nbttagcompound1);
        }
        nbttagcompound.a("PendingSpawns", (cd)nbttaglist);
    }

    @Override
    protected void createInventory() {
        this.swarmerInventory = new TileInventoryAdapter(this, 4, "SwarmInv");
    }

    @Override
    public la getInventory() {
        return this.swarmerInventory;
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        if (this.swarmerInventory != null) {
            return this.swarmerInventory.addStack(stack, false, doAdd);
        }
        return 0;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        return null;
    }

    public int k_() {
        if (this.swarmerInventory != null) {
            return this.swarmerInventory.k_();
        }
        return 0;
    }

    public ur a(int slotIndex) {
        if (this.swarmerInventory != null) {
            return this.swarmerInventory.a(slotIndex);
        }
        return null;
    }

    public ur a(int slotIndex, int amount) {
        if (this.swarmerInventory != null) {
            return this.swarmerInventory.a(slotIndex, amount);
        }
        return null;
    }

    public ur a_(int slotIndex) {
        if (this.swarmerInventory != null) {
            return this.swarmerInventory.a_(slotIndex);
        }
        return null;
    }

    public void a(int slotIndex, ur itemstack) {
        if (this.swarmerInventory == null && !Proxies.common.isSimulating(this.k)) {
            this.createInventory();
        }
        if (this.swarmerInventory != null) {
            this.swarmerInventory.a(slotIndex, itemstack);
        }
    }

    @Override
    public String b() {
        return "tile.alvearySwarmer";
    }

    public int c() {
        if (this.swarmerInventory != null) {
            return this.swarmerInventory.c();
        }
        return 0;
    }

    public void l_() {
    }

    public void f() {
    }
}

