/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import forestry.api.apiculture.IAlvearyComponent;
import forestry.api.core.ForestryAPI;
import forestry.apiculture.gadgets.TileAlveary;
import forestry.core.config.ForestryItem;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.GenericInventoryAdapter;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.StackUtils;
import forestry.core.utils.TankSlot;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidStack;

public class TileAlvearyHygroregulator
extends TileAlveary
implements la,
ILiquidTankContainer {
    public static final int TEXTURE_EMPTY = 73;
    private HygroregulatorRecipe[] recipes;
    GenericInventoryAdapter canInventory = new GenericInventoryAdapter(1, "CanInv");
    private TankSlot liquidTank = new TankSlot(10000);
    private HygroregulatorRecipe currentRecipe;
    private int transferTime;

    public TileAlvearyHygroregulator() {
        super(5);
        this.recipes = new HygroregulatorRecipe[]{new HygroregulatorRecipe(new LiquidStack(amq.E, 1), 1, 0.01f, -0.005f), new HygroregulatorRecipe(new LiquidStack(amq.G, 1), 10, -0.01f, 0.005f), new HygroregulatorRecipe(new LiquidStack(ForestryItem.liquidIce, 1), 10, 0.02f, -0.01f)};
    }

    @Override
    public void openGui(qx player) {
        player.openGui(ForestryAPI.instance, GuiId.HygroregulatorGUI.ordinal(), this.k, this.l, this.m, this.n);
    }

    @Override
    public String b() {
        return "tile.alveary.5";
    }

    private HygroregulatorRecipe getRecipe(LiquidStack liquid) {
        HygroregulatorRecipe recipe = null;
        for (HygroregulatorRecipe rec : this.recipes) {
            if (!rec.liquid.isLiquidEqual(liquid)) continue;
            recipe = rec;
            break;
        }
        return recipe;
    }

    @Override
    protected void updateServerSide() {
        LiquidContainerData container;
        super.updateServerSide();
        if (this.transferTime <= 0 && this.liquidTank.quantity > 0) {
            this.currentRecipe = this.getRecipe(this.liquidTank.getLiquid());
            if (this.currentRecipe != null) {
                this.liquidTank.drain(this.currentRecipe.liquid.amount, true);
                this.transferTime = this.currentRecipe.transferTime;
            }
        }
        if (this.transferTime > 0) {
            --this.transferTime;
            if (this.currentRecipe != null) {
                IAlvearyComponent component = (IAlvearyComponent)this.getCentralTE();
                if (component != null) {
                    component.addHumidityChange(this.currentRecipe.humidChange, 0.0f, 1.0f);
                    component.addTemperatureChange(this.currentRecipe.tempChange, 0.0f, 2.0f);
                }
            } else {
                this.transferTime = 0;
            }
        }
        if (this.k.G() % 20L * 10L != 0L) {
            return;
        }
        if (this.canInventory.a(0) != null && (container = LiquidHelper.getLiquidContainer(this.canInventory.a(0))) != null && (container.stillLiquid.itemID == amq.E.cm || container.stillLiquid.itemID == amq.G.cm)) {
            this.canInventory.a(0, StackUtils.replenishByContainer(this, this.canInventory.a(0), container, this.liquidTank));
            if (this.canInventory.a((int)0).a <= 0) {
                this.canInventory.a(0, null);
            }
        }
    }

    @Override
    public boolean hasFunction() {
        return true;
    }

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this.canInventory.readFromNBT(nbttagcompound);
        this.liquidTank = new TankSlot(10000);
        if (nbttagcompound.b("LiquidTank")) {
            this.liquidTank.readFromNBT(nbttagcompound.l("LiquidTank"));
        }
        this.transferTime = nbttagcompound.e("TransferTime");
        if (nbttagcompound.b("CurrentLiquid")) {
            LiquidStack liquid = LiquidStack.loadLiquidStackFromNBT((bq)nbttagcompound.l("CurrentLiquid"));
            this.currentRecipe = this.getRecipe(liquid);
        }
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        this.canInventory.writeToNBT(nbttagcompound);
        bq NBTresourceSlot = new bq();
        this.liquidTank.writeToNBT(NBTresourceSlot);
        nbttagcompound.a("LiquidTank", (cd)NBTresourceSlot);
        nbttagcompound.a("TransferTime", this.transferTime);
        if (this.currentRecipe != null) {
            bq subcompound = new bq();
            this.currentRecipe.liquid.writeToNBT(subcompound);
            nbttagcompound.a("CurrentLiquid", (cd)subcompound);
        }
    }

    @Override
    public int getBlockTexture(int side, int metadata) {
        return 73;
    }

    @Override
    public la getInventory() {
        return this.canInventory;
    }

    public int k_() {
        if (this.canInventory != null) {
            return this.canInventory.k_();
        }
        return 0;
    }

    public ur a(int slotIndex) {
        if (this.canInventory != null) {
            return this.canInventory.a(slotIndex);
        }
        return null;
    }

    public ur a(int slotIndex, int amount) {
        if (this.canInventory != null) {
            return this.canInventory.a(slotIndex, amount);
        }
        return null;
    }

    public ur a_(int slotIndex) {
        if (this.canInventory != null) {
            return this.canInventory.a_(slotIndex);
        }
        return null;
    }

    public void a(int slotIndex, ur itemstack) {
        if (this.canInventory == null && !Proxies.common.isSimulating(this.k)) {
            this.createInventory();
        }
        if (this.canInventory != null) {
            this.canInventory.a(slotIndex, itemstack);
        }
    }

    public int c() {
        if (this.canInventory != null) {
            return this.canInventory.c();
        }
        return 0;
    }

    public void l_() {
    }

    public void f() {
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return this.liquidTank.fill(resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(0, maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return this.liquidTank.drain(maxDrain, doDrain);
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this.liquidTank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.liquidTank;
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.liquidTank.liquidId = j;
                break;
            }
            case 1: {
                this.liquidTank.quantity = j;
                break;
            }
            case 2: {
                this.liquidTank.liquidMeta = j;
            }
        }
    }

    public void sendGUINetworkData(rq container, rw iCrafting) {
        iCrafting.a(container, 0, this.liquidTank.liquidId);
        iCrafting.a(container, 1, this.liquidTank.quantity);
        iCrafting.a(container, 2, this.liquidTank.liquidMeta);
    }

    private static class HygroregulatorRecipe {
        public final LiquidStack liquid;
        public final int transferTime;
        public final float humidChange;
        public final float tempChange;

        public HygroregulatorRecipe(LiquidStack liquid, int transferTime, float humidChange, float tempChange) {
            this.liquid = liquid;
            this.transferTime = transferTime;
            this.humidChange = humidChange;
            this.tempChange = tempChange;
        }
    }
}

