/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeekeepingMode;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IApiaristTracker;
import forestry.core.config.Version;
import forestry.core.proxy.Proxies;
import forestry.core.utils.CommandMC;
import forestry.core.utils.StringUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class CommandBeekeepingMode
extends CommandMC {
    String[] modeStrings = new String[BeeManager.breedingManager.getBeekeepingModes().size()];

    public CommandBeekeepingMode() {
        for (int i = 0; i < BeeManager.breedingManager.getBeekeepingModes().size(); ++i) {
            this.modeStrings[i] = ((IBeekeepingMode)BeeManager.breedingManager.getBeekeepingModes().get(i)).getName();
        }
    }

    public int compareTo(Object arg0) {
        return this.c().compareTo(((y)arg0).c());
    }

    public String c() {
        return "beekeeping";
    }

    public String a(aa var1) {
        return "/" + this.c() + " help";
    }

    public List b() {
        return null;
    }

    public void b(aa sender, String[] arguments) {
        if (arguments.length <= 0) {
            throw new av("Type '" + this.a(sender) + "' for help.", new Object[0]);
        }
        if (arguments[0].matches("list")) {
            this.listModes(sender, arguments);
        } else if (arguments[0].matches("info")) {
            this.listModeInfo(sender, arguments);
        } else if (arguments[0].matches("set")) {
            if (arguments.length <= 1) {
                throw new av("/" + this.c() + " set [<world-#>] <mode-name>", new Object[0]);
            }
            yc world = this.getWorld(sender, arguments);
            String desired = arguments[arguments.length - 1];
            IBeekeepingMode mode = BeeManager.breedingManager.getBeekeepingMode(desired);
            if (mode == null) {
                throw new aq("A bekeeping mode called '%s' is not available.", new Object[]{desired});
            }
            BeeManager.breedingManager.setBeekeepingMode(world, mode.getName());
            CommandBeekeepingMode.a((aa)sender, (String)"Beekeeping mode set to %s.", (Object[])new Object[]{mode.getName()});
        } else if (arguments[0].matches("save")) {
            if (arguments.length <= 1) {
                throw new av("/" + this.c() + " save <player-name>", new Object[0]);
            }
            this.saveStatistics(sender, arguments);
        } else if (arguments[0].matches("help")) {
            sender.a("Format: '/" + this.c() + " <command> <arguments>'");
            sender.a("Available commands:");
            sender.a("- list [<world-#>]: lists current and available beekeeping modes.");
            sender.a("- info <mode-name> : information on beekeeping mode.");
            sender.a("- set [<world-#>] <mode-name>: set beekeeping mode for world.");
            sender.a("- save [<world-#>] <player-name>: save beekeeping statistics for the given player.");
        }
    }

    private void saveStatistics(aa sender, String[] arguments) {
        String newLine = System.getProperty("line.separator");
        yc world = this.getWorld(sender, arguments);
        String player = arguments[1];
        ArrayList<String> statistics = new ArrayList<String>();
        statistics.add(String.format("Beekeeping statistics for %s on %s:", player, DateFormat.getInstance().format(new Date())));
        statistics.add("");
        statistics.add("MODE: " + BeeManager.breedingManager.getBeekeepingMode(world).getName());
        statistics.add("");
        IApiaristTracker tracker = BeeManager.breedingManager.getApiaristTracker(world, player);
        if (tracker == null) {
            statistics.add("No statistics found.");
        } else {
            statistics.add("BRED:");
            statistics.add("-----");
            statistics.add("");
            statistics.add("Queens:\t\t" + tracker.getQueenCount());
            statistics.add("Princesses:\t" + tracker.getPrincessCount());
            statistics.add("Drones:\t\t" + tracker.getDroneCount());
            statistics.add("");
            ArrayList<IAlleleBeeSpecies> species = new ArrayList<IAlleleBeeSpecies>();
            for (IAllele iAllele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
                if (!(iAllele instanceof IAlleleBeeSpecies)) continue;
                species.add((IAlleleBeeSpecies)iAllele);
            }
            statistics.add(String.format("SPECIES (%s):", species.size()));
            statistics.add("-------------");
            statistics.add("");
            for (IAlleleBeeSpecies iAlleleBeeSpecies : species) {
                statistics.add(this.generateSpeciesListEntry(iAlleleBeeSpecies, tracker));
            }
        }
        File file = new File(Proxies.common.getForestryRoot(), "config/" + "Forestry".toLowerCase(Locale.ENGLISH) + "/stats/" + player + ".log");
        try {
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists() && !file.createNewFile()) {
                sender.a("Log file could not be created. Failed to save statistics.");
                return;
            }
            if (!file.canWrite()) {
                sender.a("Cannot write to log file. Failed to save statistics.");
                return;
            }
            FileOutputStream fileout = new FileOutputStream(file);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileout, "UTF-8"));
            bufferedWriter.write("# Forestry" + newLine + "# " + Version.getVersion() + newLine);
            for (String line : statistics) {
                bufferedWriter.write(line + newLine);
            }
            bufferedWriter.close();
        }
        catch (Exception ex) {
            sender.a("Write operation threw an exception. Failed to save statistics.");
            ex.printStackTrace();
        }
        sender.a("Saved statistics for player " + player);
    }

    private String generateSpeciesListEntry(IAlleleBeeSpecies species, IApiaristTracker tracker) {
        String discovered = "[   ]";
        if (tracker.isDiscovered(species)) {
            discovered = "[ X ]";
        }
        String blacklisted = "[    ]";
        if (AlleleManager.alleleRegistry.isBlacklisted(species.getUID())) {
            blacklisted = "[ BL ]";
        }
        String notcounted = "[    ]";
        if (!species.isCounted()) {
            notcounted = "[ NC ]";
        }
        return String.format("%s %s %s\t%-40s %-20s %-20s", discovered, blacklisted, notcounted, species.getUID(), species.getName(), species.getAuthority());
    }

    private void listModes(aa sender, String[] arguments) {
        yc world = this.getWorld(sender, arguments);
        sender.a("Current: " + BeeManager.breedingManager.getBeekeepingMode(world).getName() + " (#" + world.K().j() + ")");
        String help = "";
        for (IBeekeepingMode mode : BeeManager.breedingManager.getBeekeepingModes()) {
            if (!help.isEmpty()) {
                help = help + ", ";
            }
            help = help + mode.getName();
        }
        sender.a("Available modes: " + help);
    }

    private void listModeInfo(aa sender, String[] arguments) {
        if (arguments.length <= 1) {
            throw new av("/" + this.c() + " info <mode-name>", new Object[0]);
        }
        IBeekeepingMode found = null;
        for (IBeekeepingMode mode : BeeManager.breedingManager.getBeekeepingModes()) {
            if (!mode.getName().equalsIgnoreCase(arguments[1])) continue;
            found = mode;
            break;
        }
        if (found == null) {
            throw new aq("No beekeeping mode called '%s' is available.", new Object[]{arguments[1]});
        }
        sender.a("\u00a7aMode: " + found.getName());
        for (String desc : found.getDescription()) {
            sender.a(StringUtil.localize(desc));
        }
    }

    public boolean b(aa sender) {
        if (sender instanceof qx) {
            return Proxies.common.isOp((qx)sender);
        }
        return sender.a(4, this.c());
    }

    public List a(aa sender, String[] incomplete) {
        return CommandBeekeepingMode.a((String[])incomplete, (String[])this.modeStrings);
    }
}

