/*
 * Decompiled with CFR 0.152.
 */
package uristqwerty.CraftGuide.api;

import java.util.ArrayList;
import java.util.List;
import uristqwerty.CraftGuide.api.ItemFilter;
import uristqwerty.CraftGuide.api.ItemSlot;
import uristqwerty.CraftGuide.api.Renderer;
import uristqwerty.CraftGuide.api.SlotType;

public class InfoSlot
extends ItemSlot {
    private final ur displayed;
    private final String[] format;
    private boolean clickable;
    private boolean searchable;

    public InfoSlot(int x, int y, ur displayedStack, String[] lines) {
        super(x, y, 16, 16, true);
        this.displayed = displayedStack;
        this.format = lines;
    }

    @Override
    public void draw(Renderer renderer, int x, int y, Object[] data, int dataIndex, boolean isMouseOver) {
        ItemSlot.implementation.draw(this, renderer, x, y, this.displayed, isMouseOver && this.clickable);
    }

    @Override
    public ItemFilter getClickedFilter(int x, int y, Object[] data, int dataIndex) {
        return this.clickable ? null : ItemSlot.implementation.getClickedFilter(x, y, this.displayed);
    }

    @Override
    public List getTooltip(int x, int y, Object[] data, int dataIndex) {
        ArrayList<String> tooltip = new ArrayList<String>();
        if (data[dataIndex] instanceof Object[]) {
            for (int i = 0; i < this.format.length; ++i) {
                tooltip.add(String.format(this.format[i], (Object[])data[dataIndex]));
            }
        } else {
            for (int i = 0; i < this.format.length; ++i) {
                tooltip.add(String.format(this.format[i], data[dataIndex]));
            }
        }
        return tooltip;
    }

    @Override
    public boolean matches(ItemFilter filter, Object[] data, int dataIndex, SlotType type) {
        return this.searchable && ItemSlot.implementation.matches(this, filter, this.displayed, type);
    }

    public InfoSlot setSeachable(boolean searchable) {
        this.searchable = searchable;
        return this;
    }

    public InfoSlot setClickable(boolean clickable) {
        this.clickable = clickable;
        return this;
    }
}

