/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.plugins.craftguide;

import java.lang.reflect.Method;
import java.util.logging.Level;
import railcraft.common.plugins.craftguide.BlastFurnacePlugin;
import railcraft.common.plugins.craftguide.CokeOvenPlugin;
import railcraft.common.plugins.craftguide.RecipeFilter;
import railcraft.common.plugins.craftguide.RockCrusherPlugin;
import railcraft.common.plugins.craftguide.RollingMachinePlugin;
import railcraft.common.util.misc.Game;

public class CraftGuidePlugin {
    private static Method register;

    public static void init() {
        try {
            CraftGuidePlugin.registerCraftGuideObject(new BlastFurnacePlugin());
            CraftGuidePlugin.registerCraftGuideObject(new CokeOvenPlugin());
            CraftGuidePlugin.registerCraftGuideObject(new RockCrusherPlugin());
            CraftGuidePlugin.registerCraftGuideObject(new RollingMachinePlugin());
            CraftGuidePlugin.registerCraftGuideObject(new RecipeFilter());
        }
        catch (Throwable error) {
            Game.log(Level.FINEST, "Could not register CraftGuide plugins: {0}", error.getMessage());
        }
    }

    public static void registerCraftGuideObject(Object obj) {
        try {
            if (register == null) {
                Class<?> api = Class.forName("uristqwerty.CraftGuide.ReflectionAPI");
                register = api.getMethod("registerAPIObject", Object.class);
            }
            register.invoke(null, obj);
            Game.log(Level.FINEST, "Successfully registered CraftGuide plugin: {0}", obj.getClass().getSimpleName());
        }
        catch (Exception e) {
            Game.log(Level.FINEST, "Could not register CraftGuide plugin: {0}", obj.getClass().getSimpleName());
        }
    }
}

