/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.plugins.buildcraft.triggers;

import buildcraft.api.gates.ITriggerParameter;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.plugins.buildcraft.triggers.ITemperature;
import railcraft.common.plugins.buildcraft.triggers.TriggerBase;

public class TriggerTemp
extends TriggerBase {
    private final int min;
    private final int max;
    private final int texture;
    private String tag;

    public TriggerTemp(int id, String tag, int texture, int min, int max) {
        super(id);
        this.tag = tag;
        this.min = min;
        this.max = max;
        this.texture = texture;
    }

    @Override
    public String getDescription() {
        return RailcraftLanguage.translate("gates.trigger.temp." + this.tag);
    }

    @Override
    public int getIndexInTexture() {
        return this.texture;
    }

    @Override
    public boolean isTriggerActive(any tile, ITriggerParameter parameter) {
        if (tile instanceof ITemperature) {
            float temp = ((ITemperature)tile).getTemperature();
            return temp >= (float)this.min && temp < (float)this.max;
        }
        return false;
    }
}

