/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.modules;

import ic2.api.Ic2Recipes;
import java.util.ArrayList;
import java.util.logging.Level;
import net.minecraftforge.common.MinecartRegistry;
import net.minecraftforge.oredict.OreDictionary;
import railcraft.common.api.core.items.ItemRegistry;
import railcraft.common.blocks.RailcraftBlocks;
import railcraft.common.blocks.detector.BlockDetector;
import railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import railcraft.common.carts.EntityCartEnergy;
import railcraft.common.carts.EnumCart;
import railcraft.common.carts.ItemCart;
import railcraft.common.core.Railcraft;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.items.ItemRailcraft;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.modules.RailcraftModule;
import railcraft.common.plugins.forge.CraftingPlugin;
import railcraft.common.plugins.ic2.IC2Plugin;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;

public class ModuleIC2
extends RailcraftModule {
    public static up lapotronUpgrade;

    @Override
    public boolean canModuleLoad() {
        return IC2Plugin.isIC2Installed();
    }

    @Override
    public void printLoadError() {
        Game.log(Level.FINER, "Module disabled: {0}, IC2 not detected", this);
    }

    @Override
    public void initFirst() {
        ur stack;
        ItemCart item;
        boolean mfsuEnabled;
        int id;
        ur stack2;
        RailcraftBlocks.registerBlockDetector();
        RailcraftBlocks.registerBlockMachineGamma();
        EnumMachineGamma type = EnumMachineGamma.ENERGY_LOADER;
        if (type.isEnabled()) {
            stack2 = type.getItem();
            RailcraftLanguage.getInstance().registerItemName(stack2, type.getTag());
        }
        if ((type = EnumMachineGamma.ENERGY_UNLOADER).isEnabled()) {
            stack2 = type.getItem();
            RailcraftLanguage.getInstance().registerItemName(stack2, type.getTag());
        }
        if ((id = RailcraftConfig.getItemId("ic2.upgrade.lapotron")) > 0) {
            lapotronUpgrade = new ItemRailcraft(id).b("lapotronUpgrade").c(183).d(9);
            RailcraftLanguage.getInstance().registerItemName(lapotronUpgrade, "ic2.upgrade.lapotron");
            ItemRegistry.registerItem("ic2.upgrade.lapotron", new ur(lapotronUpgrade));
        }
        int batId = RailcraftConfig.getItemId("item.cart.batbox");
        int mfeId = RailcraftConfig.getItemId("item.cart.mfe");
        int mfsuId = RailcraftConfig.getItemId("item.cart.mfsu");
        boolean batEnabled = RailcraftConfig.isCartEnabled("cart.energy.batbox") && batId > 0;
        boolean mfeEnabled = RailcraftConfig.isCartEnabled("cart.energy.mfe") && mfeId > 0;
        boolean bl = mfsuEnabled = RailcraftConfig.isCartEnabled("cart.energy.mfsu") && mfsuId > 0;
        if (batEnabled || mfeEnabled || mfsuEnabled) {
            MiscTools.registerMinecart(Railcraft.getMod(), EntityCartEnergy.class, "cart.energy", EnumCart.BATBOX.getId());
        }
        if (batEnabled) {
            item = new ItemCart(batId, EnumCart.BATBOX);
            stack = new ur((up)item);
            MinecartRegistry.registerMinecart(EntityCartEnergy.class, (int)0, (ur)stack);
            RailcraftLanguage.getInstance().registerItemName(stack, EnumCart.BATBOX.getTag());
            ItemRegistry.registerItem("cart.energy.batbox", stack);
        }
        if (mfeEnabled) {
            item = new ItemCart(mfeId, EnumCart.MFE);
            stack = new ur((up)item);
            MinecartRegistry.registerMinecart(EntityCartEnergy.class, (int)1, (ur)stack);
            RailcraftLanguage.getInstance().registerItemName(stack, EnumCart.MFE.getTag());
            ItemRegistry.registerItem("cart.energy.mfe", stack);
        }
        if (mfsuEnabled) {
            item = new ItemCart(mfsuId, EnumCart.MFSU);
            stack = new ur((up)item);
            MinecartRegistry.registerMinecart(EntityCartEnergy.class, (int)2, (ur)stack);
            RailcraftLanguage.getInstance().registerItemName(stack, EnumCart.MFSU.getTag());
            ItemRegistry.registerItem("cart.energy.mfsu", stack);
        }
    }

    @Override
    public void postInit() {
        ArrayList reIron;
        if (RailcraftConfig.getRecipeConfig("ic2.refinedIron.disable")) {
            reIron = OreDictionary.getOres((String)"ingotRefinedIron");
            reIron.clear();
        }
        if (RailcraftConfig.getRecipeConfig("ic2.refinedIron.useSteel")) {
            reIron = OreDictionary.getOres((String)"ingotRefinedIron");
            reIron.addAll(OreDictionary.getOres((String)"ingotSteel"));
        }
        ModuleIC2.createRecipes();
    }

    private static void createRecipes() {
        int id;
        ur mfsu;
        ur mfe;
        ur batbox;
        amq blockDetector = RailcraftBlocks.getBlockDetector();
        if (blockDetector != null) {
            ur stack = new ur(blockDetector, 1, BlockDetector.Detector.ENERGY.ordinal());
            CraftingPlugin.addShapedOreRecipe(stack, false, "XXX", "XPX", "XXX", Character.valueOf('X'), "ingotTin", Character.valueOf('P'), amq.aN);
        }
        if ((batbox = IC2Plugin.getItem("batBox")) != null) {
            EnumCart.BATBOX.setContents(batbox);
            ur cart = MinecartRegistry.getItemForCart(EntityCartEnergy.class, (int)0);
            if (cart != null) {
                CraftingPlugin.addShapedRecipe(cart, "E", "M", Character.valueOf('E'), batbox, Character.valueOf('M'), up.az);
                CraftingPlugin.addShapelessRecipe(new ur(up.az), cart);
            }
        }
        if ((mfe = IC2Plugin.getItem("mfeUnit")) != null) {
            EnumCart.MFE.setContents(mfe);
            ur cart = MinecartRegistry.getItemForCart(EntityCartEnergy.class, (int)1);
            if (cart != null) {
                CraftingPlugin.addShapedRecipe(cart, "E", "M", Character.valueOf('E'), mfe, Character.valueOf('M'), up.az);
                CraftingPlugin.addShapelessRecipe(new ur(up.az), cart);
            }
        }
        if ((mfsu = IC2Plugin.getItem("mfsUnit")) != null) {
            EnumCart.MFSU.setContents(mfsu);
            ur cart = MinecartRegistry.getItemForCart(EntityCartEnergy.class, (int)2);
            if (cart != null) {
                CraftingPlugin.addShapedRecipe(cart, "E", "M", Character.valueOf('E'), mfsu, Character.valueOf('M'), up.az);
                CraftingPlugin.addShapelessRecipe(new ur(up.az), cart);
            }
        }
        ur battery = IC2Plugin.getItem("reBattery");
        ur machine = IC2Plugin.getItem("machine");
        ur detector = null;
        detector = blockDetector != null ? new ur(blockDetector, 1, BlockDetector.Detector.ENERGY.ordinal()) : new ur(amq.aN);
        if (battery != null && machine != null) {
            if (EnumMachineGamma.ENERGY_LOADER.isEnabled()) {
                Ic2Recipes.addCraftingRecipe(EnumMachineGamma.ENERGY_LOADER.getItem(), "BLB", "BIB", "BDB", Character.valueOf('D'), detector, Character.valueOf('B'), battery, Character.valueOf('I'), machine, Character.valueOf('L'), new ur(amq.S, 1, 0));
            }
            if (EnumMachineGamma.ENERGY_UNLOADER.isEnabled()) {
                Ic2Recipes.addCraftingRecipe(EnumMachineGamma.ENERGY_UNLOADER.getItem(), "BDB", "BIB", "BLB", Character.valueOf('D'), detector, Character.valueOf('B'), battery, Character.valueOf('I'), machine, Character.valueOf('L'), new ur(amq.S, 1, 0));
            }
        }
        if ((id = RailcraftConfig.getItemId("ic2.upgrade.lapotron")) > 0) {
            ur lapotron = IC2Plugin.getItem("lapotronCrystal");
            ur glassCable = IC2Plugin.getItem("glassFiberCableItem");
            ur circuit = IC2Plugin.getItem("advancedCircuit");
            if (lapotron != null && glassCable != null && circuit != null) {
                lapotron.l();
                Ic2Recipes.addCraftingRecipe(new ur(lapotronUpgrade), "GGG", "wLw", "GCG", Character.valueOf('G'), new ur(amq.P, 1, 0), Character.valueOf('w'), glassCable, Character.valueOf('C'), circuit, Character.valueOf('L'), lapotron);
            }
        }
    }

    public static ur getLapotronUpgrade() {
        if (lapotronUpgrade == null) {
            return null;
        }
        return new ur(lapotronUpgrade);
    }
}

