/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.modules;

import cpw.mods.fml.common.ICraftingHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import net.minecraftforge.common.IMinecartCollisionHandler;
import net.minecraftforge.common.MinecartRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.oredict.ShapedOreRecipe;
import railcraft.common.api.crafting.RailcraftCraftingManager;
import railcraft.common.api.fuel.FuelManager;
import railcraft.common.api.signals.SignalTools;
import railcraft.common.blocks.machine.MachineTileRegistery;
import railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import railcraft.common.carts.EntityCartBasic;
import railcraft.common.carts.EntityCartChest;
import railcraft.common.carts.EntityCartFurnace;
import railcraft.common.carts.EnumCart;
import railcraft.common.carts.ItemCartVanilla;
import railcraft.common.carts.LinkageHandler;
import railcraft.common.carts.LinkageManager;
import railcraft.common.carts.MinecartHooks;
import railcraft.common.core.Railcraft;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.gui.GuiHandler;
import railcraft.common.items.CrowbarHandler;
import railcraft.common.items.FuelHandler;
import railcraft.common.items.ItemGoggles;
import railcraft.common.items.ItemMagnifyingGlass;
import railcraft.common.items.ItemNugget;
import railcraft.common.items.RailcraftPartItems;
import railcraft.common.items.RailcraftToolItems;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.liquids.LiquidItems;
import railcraft.common.modules.RailcraftModule;
import railcraft.common.plugins.buildcraft.BuildcraftPlugin;
import railcraft.common.plugins.forestry.ForestryPlugin;
import railcraft.common.plugins.forge.CraftingPlugin;
import railcraft.common.plugins.forge.Creeper$Plugin;
import railcraft.common.plugins.forge.LootPlugin;
import railcraft.common.util.crafting.BlastFurnaceCraftingManager;
import railcraft.common.util.crafting.CokeOvenCraftingManager;
import railcraft.common.util.crafting.CraftingHandler;
import railcraft.common.util.crafting.RockCrusherCraftingManager;
import railcraft.common.util.crafting.RollingMachineCraftingManager;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;
import railcraft.common.util.network.PacketBuilder;

public class ModuleCore
extends RailcraftModule {
    @Override
    public void preInit() {
        LinkageManager.reset();
        RailcraftCraftingManager.cokeOven = new CokeOvenCraftingManager();
        RailcraftCraftingManager.blastFurnace = new BlastFurnaceCraftingManager();
        RailcraftCraftingManager.rockCrusher = new RockCrusherCraftingManager();
        RailcraftCraftingManager.rollingMachine = new RollingMachineCraftingManager();
        SignalTools.packetBuilder = PacketBuilder.getInstance();
        LiquidItems.initialize();
    }

    @Override
    public void initFirst() {
        ShapedOreRecipe recipe;
        NetworkRegistry.instance().registerGuiHandler((Object)Railcraft.getMod(), (IGuiHandler)new GuiHandler());
        LootPlugin.increaseLootGen(1, 2, "mineshaftCorridor", "villageBlacksmith");
        RailcraftToolItems.registerCrowbar();
        MinecraftForge.EVENT_BUS.register((Object)CrowbarHandler.getInstance());
        ItemMagnifyingGlass.register();
        RailcraftToolItems.initializeToolsArmor();
        ItemNugget.getNuggetIron();
        qd.d[amq.I.cm] = false;
        BuildcraftPlugin.init();
        MinecraftForge.EVENT_BUS.register((Object)MinecartHooks.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)LinkageHandler.getInstance());
        if (RailcraftConfig.useCollisionHandler()) {
            if (py.getCollisionHandler() != null) {
                Game.log(Level.CONFIG, "Existing Minecart Collision Handler detected, overwriting. Please check your configs to ensure this is desired behavior.", new Object[0]);
            }
            py.setCollisionHandler((IMinecartCollisionHandler)MinecartHooks.getInstance());
        }
        GameRegistry.registerCraftingHandler((ICraftingHandler)new CraftingHandler());
        HashSet<Integer> testSet = new HashSet<Integer>();
        if (!RailcraftConfig.useOldRecipes()) {
            testSet.add(amq.aJ.cm);
            testSet.add(amq.W.cm);
            testSet.add(amq.X.cm);
        }
        if (RailcraftConfig.getRecipeConfig("railcraft.cart.furnace")) {
            testSet.add(up.aO.cj);
        }
        Iterator it = wn.a().b().iterator();
        while (it.hasNext()) {
            wp r = (wp)it.next();
            ur output = r.b();
            if (output == null || !testSet.contains(output.c)) continue;
            it.remove();
        }
        int itemIdOffset = up.f.cj;
        int itemIdCartBasic = up.az.cj;
        int itemIdCartChest = up.aN.cj;
        int itemIdCartSteam = up.aO.cj;
        up.e[itemIdCartBasic] = null;
        up.e[itemIdCartChest] = null;
        up.e[itemIdCartSteam] = null;
        ItemCartVanilla itemCartBasic = new ItemCartVanilla(itemIdCartBasic - itemIdOffset, EnumCart.BASIC);
        ItemCartVanilla itemCartChest = new ItemCartVanilla(itemIdCartChest - itemIdOffset, EnumCart.CHEST);
        ItemCartVanilla itemCartPower = new ItemCartVanilla(itemIdCartSteam - itemIdOffset, EnumCart.FURNACE);
        GameRegistry.registerItem((up)itemCartBasic, (String)EnumCart.BASIC.getItemTag());
        GameRegistry.registerItem((up)itemCartChest, (String)EnumCart.CHEST.getItemTag());
        GameRegistry.registerItem((up)itemCartPower, (String)EnumCart.FURNACE.getItemTag());
        MinecartRegistry.removeMinecart(py.class, (int)0);
        MinecartRegistry.removeMinecart(py.class, (int)1);
        MinecartRegistry.removeMinecart(py.class, (int)2);
        MinecartRegistry.registerMinecart(EntityCartBasic.class, (ur)new ur((up)itemCartBasic));
        MinecartRegistry.registerMinecart(EntityCartChest.class, (int)1, (ur)new ur((up)itemCartChest));
        MinecartRegistry.registerMinecart(EntityCartFurnace.class, (int)2, (ur)new ur((up)itemCartPower));
        MiscTools.registerMinecart(Railcraft.getMod(), EntityCartBasic.class, "cart.basic", EnumCart.BASIC.getId());
        MiscTools.registerMinecart(Railcraft.getMod(), EntityCartChest.class, "cart.chest", EnumCart.CHEST.getId());
        MiscTools.registerMinecart(Railcraft.getMod(), EntityCartFurnace.class, "cart.furnace", EnumCart.FURNACE.getId());
        MinecraftForge.setBlockHarvestLevel((amq)amq.aJ, (String)"crowbar", (int)0);
        MinecraftForge.setBlockHarvestLevel((amq)amq.aJ, (String)"pickaxe", (int)0);
        MinecraftForge.setBlockHarvestLevel((amq)amq.W, (String)"crowbar", (int)0);
        MinecraftForge.setBlockHarvestLevel((amq)amq.W, (String)"pickaxe", (int)0);
        MinecraftForge.setBlockHarvestLevel((amq)amq.X, (String)"crowbar", (int)0);
        MinecraftForge.setBlockHarvestLevel((amq)amq.X, (String)"pickaxe", (int)0);
        if (RailcraftConfig.getRecipeConfig("railcraft.cart.bronze")) {
            recipe = new ShapedOreRecipe(new ur(up.az), new Object[]{false, new Object[]{"I I", "III", Character.valueOf('I'), "ingotBronze"}});
            wn.a().b().add(recipe);
        }
        if (RailcraftConfig.getRecipeConfig("railcraft.cart.steel")) {
            recipe = new ShapedOreRecipe(new ur(up.az, 2), new Object[]{false, new Object[]{"I I", "III", Character.valueOf('I'), "ingotSteel"}});
            wn.a().b().add(recipe);
        }
        if (!RailcraftConfig.useOldRecipes()) {
            ur stackRailNormal = new ur(amq.aJ, 32);
            ur stackRailBooster = new ur(amq.W, 16);
            ur stackRailDetector = new ur(amq.X, 16);
            CraftingPlugin.addShapedRecipe(stackRailNormal, "I I", "I#I", "I I", Character.valueOf('I'), RailcraftPartItems.getRailStandard(), Character.valueOf('#'), RailcraftPartItems.getRailbedWood());
            CraftingPlugin.addShapedRecipe(stackRailBooster, "I I", "I#I", "IrI", Character.valueOf('I'), RailcraftPartItems.getRailAdvanced(), Character.valueOf('#'), RailcraftPartItems.getRailbedWood(), Character.valueOf('r'), up.aC);
            CraftingPlugin.addShapedRecipe(stackRailDetector, "IsI", "I#I", "IrI", Character.valueOf('I'), RailcraftPartItems.getRailStandard(), Character.valueOf('#'), amq.aN, Character.valueOf('r'), up.aC, Character.valueOf('s'), RailcraftPartItems.getRailbedWood());
            CraftingPlugin.addShapelessRecipe(RailcraftPartItems.getRailStandard(), amq.aJ, amq.aJ, amq.aJ, amq.aJ, amq.aJ, amq.aJ, amq.aJ, amq.aJ);
            RailcraftLanguage.getInstance().registerItemName(stackRailNormal, "track.standard");
            RailcraftLanguage.getInstance().registerItemName(stackRailBooster, "track.powered");
            RailcraftLanguage.getInstance().registerItemName(stackRailDetector, "track.detector");
        }
        ur stackCartBasic = new ur((up)itemCartBasic, 1);
        ur stackCartChest = new ur((up)itemCartChest, 1);
        ur stackCartPower = new ur((up)itemCartPower, 1);
        wn.a().b(new ur(up.az), new Object[]{itemCartChest});
        wn.a().b(new ur(up.az), new Object[]{itemCartPower});
        RailcraftLanguage.getInstance().registerItemName(stackCartBasic, EnumCart.BASIC.getTag());
        RailcraftLanguage.getInstance().registerItemName(stackCartChest, EnumCart.CHEST.getTag());
        RailcraftLanguage.getInstance().registerItemName(stackCartPower, EnumCart.FURNACE.getTag());
        LootPlugin.addLootMineshaft(stackCartBasic, 1, 1, "cart.basic");
        LootPlugin.addLootMineshaft(stackCartChest, 1, 1, "cart.chest");
        LootPlugin.addLootMineshaft(new ur(amq.aJ), 8, 32, "track.basic");
        MachineTileRegistery.registerTileEntities();
    }

    @Override
    public void initSecond() {
        if (RailcraftConfig.useCreosoteFurnaceRecipes() || !EnumMachineAlpha.COKE_OVEN.isEnabled()) {
            wj.a().addSmelting(up.m.cj, 0, LiquidItems.getCreosoteOilBottle(2), 0.0f);
            wj.a().addSmelting(up.m.cj, 1, LiquidItems.getCreosoteOilBottle(1), 0.0f);
        }
        ItemGoggles.registerItem();
    }

    @Override
    public void postInit() {
        GameRegistry.registerFuelHandler((IFuelHandler)new FuelHandler());
        ModuleCore.addLiquidFuels();
        Creeper$Plugin.postSetup();
    }

    public static void addLiquidFuels() {
        ur bioFuel = ForestryPlugin.getItem("liquidBiofuel");
        if (bioFuel != null) {
            FuelManager.addBoilerFuel(new LiquidStack(bioFuel.c, 1000), 32000);
            Game.log(Level.FINER, "Registered Forestry BioFuel as a valid fuel source.", new Object[0]);
        }
        up fuel = null;
        try {
            fuel = (up)Class.forName("buildcraft.BuildCraftEnergy").getField("fuel").get(null);
        }
        catch (Exception ex) {
            Game.log(Level.FINER, "Buildcraft Fuel not found.", new Object[0]);
        }
        if (fuel != null) {
            FuelManager.addBoilerFuel(new LiquidStack(fuel, 1000), 96000);
            Game.log(Level.FINER, "Registered Buildcraft Fuel as a valid fuel source.", new Object[0]);
        }
    }
}

