/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.gui.containers;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import railcraft.common.carts.EntityLocomotiveSteam;
import railcraft.common.gui.containers.RailcraftContainer;
import railcraft.common.gui.indicator.Indicator;
import railcraft.common.gui.slots.SlotFuel;
import railcraft.common.gui.slots.SlotOutput;
import railcraft.common.gui.slots.SlotWaterLimited;
import railcraft.common.liquids.LiquidGauge;
import railcraft.common.liquids.TankManager;

public class ContainerLocomotiveSteam
extends RailcraftContainer {
    private EntityLocomotiveSteam loco;
    private sr fuel;
    private sr input;
    private sr output;
    private float lastBurnTime;
    private float lastItemBurnTime;
    private float lastHeat;

    public ContainerLocomotiveSteam(qw inventoryplayer, EntityLocomotiveSteam loco) {
        super(loco);
        this.loco = loco;
        this.addGauge(new LiquidGauge(loco.getTanks(null)[0], 116, 23, 16, 47));
        this.addGauge(new LiquidGauge(loco.getTanks(null)[1], 17, 23, 16, 47));
        this.addIndicator(new Indicator(loco.getHeatIndicator(), 40, 25, 6, 43, 176, 61));
        this.input = new SlotWaterLimited(loco, 0, 143, 21);
        this.addSlot(this.input);
        this.output = new SlotOutput(loco, 1, 143, 56);
        this.addSlot(this.output);
        this.fuel = new SlotFuel(loco, 2, 62, 39);
        this.addSlot(this.fuel);
        this.addSlot(new SlotFuel(loco, 3, 89, 20));
        this.addSlot(new SlotFuel(loco, 4, 89, 38));
        this.addSlot(new SlotFuel(loco, 5, 89, 56));
        for (int i = 0; i < 3; ++i) {
            for (int k = 0; k < 9; ++k) {
                this.addSlot(new sr((la)inventoryplayer, k + i * 9 + 9, 8 + k * 18, 123 + i * 18));
            }
        }
        for (int j = 0; j < 9; ++j) {
            this.addSlot(new sr((la)inventoryplayer, j, 8 + j * 18, 181));
        }
    }

    public void a(rw icrafting) {
        super.a(icrafting);
        TankManager tMan = this.loco.getTankManager();
        if (tMan != null) {
            tMan.initGuiData(this, icrafting, 0);
            tMan.initGuiData(this, icrafting, 1);
        }
        icrafting.a((rq)this, 10, Math.round(this.loco.burnTime));
        icrafting.a((rq)this, 11, Math.round(this.loco.currentItemBurnTime));
        icrafting.a((rq)this, 12, Math.round(this.loco.heat));
    }

    public void b() {
        super.b();
        TankManager tMan = this.loco.getTankManager();
        if (tMan != null) {
            tMan.updateGuiData(this, this.e, 0);
            tMan.updateGuiData(this, this.e, 1);
        }
        for (int var1 = 0; var1 < this.e.size(); ++var1) {
            rw var2 = (rw)this.e.get(var1);
            if (this.lastBurnTime != this.loco.burnTime) {
                var2.a((rq)this, 10, Math.round(this.loco.burnTime));
            }
            if (this.lastItemBurnTime != this.loco.currentItemBurnTime) {
                var2.a((rq)this, 11, Math.round(this.loco.currentItemBurnTime));
            }
            if (this.lastHeat == this.loco.heat) continue;
            var2.a((rq)this, 12, Math.round(this.loco.heat));
        }
        this.lastBurnTime = this.loco.burnTime;
        this.lastItemBurnTime = this.loco.currentItemBurnTime;
        this.lastHeat = this.loco.heat;
    }

    @SideOnly(value=Side.CLIENT)
    public void b(int id, int value) {
        TankManager tMan = this.loco.getTankManager();
        if (tMan != null) {
            tMan.processGuiUpdate(id, value);
        }
        switch (id) {
            case 10: {
                this.loco.burnTime = value;
                break;
            }
            case 11: {
                this.loco.currentItemBurnTime = value;
                break;
            }
            case 12: {
                this.loco.heat = value;
            }
        }
    }
}

