/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.carts;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import railcraft.common.api.carts.CartBase;
import railcraft.common.api.carts.ILinkableCart;
import railcraft.common.carts.CartUtils;
import railcraft.common.carts.DamageSourceTrain;
import railcraft.common.carts.IDirectionalCart;
import railcraft.common.carts.ItemLocomotive;
import railcraft.common.carts.LinkageManager;
import railcraft.common.carts.Train;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.items.ItemOveralls;
import railcraft.common.items.ItemWhistleTuner;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.misc.EnumColor;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;
import railcraft.common.util.network.IGuiReturnHandler;

public abstract class EntityLocomotive
extends CartBase
implements IDirectionalCart,
IGuiReturnHandler,
ILinkableCart {
    private static final byte PRIMARY_COLOR_DATA_ID = 20;
    private static final byte SECONDARY_COLOR_DATA_ID = 21;
    private static final byte LOCOMOTIVE_MODE_DATA_ID = 22;
    private static final byte LOCOMOTIVE_SPEED_DATA_ID = 23;
    private static final double DRAG_FACTOR = 0.9;
    private static final float NORMAL_FORCE = 0.15f;
    private static final float HS_FORCE = 0.52500004f;
    private static final byte IDLE_FUEL_USE_INTERVAL = 8;
    private static final int WHISTLE_INTERVAL = 256;
    private static final int WHISTLE_DELAY = 160;
    private static final int WHISTLE_CHANCE = 4;
    private int update = MiscTools.getRand().nextInt();
    private int whistleDelay;
    private int tempIdle;
    private float whistlePitch = this.getNewWhistlePitch();
    protected float renderYaw;
    public LocoMode clientMode = LocoMode.SHUTDOWN;
    public LocoSpeed clientSpeed = LocoSpeed.MAX;

    public EntityLocomotive(yc world) {
        super(world);
        this.setPrimaryColor(EnumColor.LIGHT_GRAY.ordinal());
        this.setSecondaryColor(EnumColor.GRAY.ordinal());
    }

    public EntityLocomotive(yc world, double x, double y, double z) {
        this(world);
        this.b(x, y + (double)this.M, z);
        this.q = x;
        this.r = y;
        this.s = z;
        this.e = 0;
    }

    protected void a() {
        super.a();
        this.ag.a(20, (Object)0);
        this.ag.a(21, (Object)0);
        this.ag.a(22, (Object)0);
        this.ag.a(23, (Object)0);
    }

    public void initEntityFromItem(ur item) {
        bq nbt = item.p();
        if (nbt == null) {
            return;
        }
        if (nbt.b("primaryColor")) {
            this.setPrimaryColor(nbt.c("primaryColor"));
        }
        if (nbt.b("secondaryColor")) {
            this.setSecondaryColor(nbt.c("secondaryColor"));
        }
        if (nbt.b("whistlePitch")) {
            this.whistlePitch = nbt.g("whistlePitch");
        }
    }

    private float getNewWhistlePitch() {
        return 1.0f + (float)this.aa.nextGaussian() * 0.2f;
    }

    public List getItemsDropped() {
        ArrayList<ur> items = new ArrayList<ur>();
        items.add(this.getCartItem());
        return items;
    }

    public ur getCartItem() {
        ur item = this.getCartItemBase();
        ItemLocomotive.setItemColorData(item, this.getPrimaryColor(), this.getSecondaryColor());
        ItemLocomotive.setItemWhistleData(item, this.whistlePitch);
        return item;
    }

    protected abstract ur getCartItemBase();

    public LocoMode getMode() {
        return LocoMode.VALUES[this.ag.a(22)];
    }

    public void setMode(LocoMode mode) {
        if (this.getMode() != mode) {
            this.ag.b(22, (Object)((byte)mode.ordinal()));
        }
    }

    public LocoSpeed getSpeed() {
        return LocoSpeed.VALUES[this.ag.a(23)];
    }

    public void setSpeed(LocoSpeed speed) {
        if (this.getSpeed() != speed) {
            this.ag.b(23, (Object)((byte)speed.ordinal()));
        }
    }

    public boolean isRunning() {
        return this.e > 0 && this.getMode() == LocoMode.RUNNING && !this.isIdle() && !this.isShutdown();
    }

    public boolean isIdle() {
        if (this.isShutdown()) {
            return false;
        }
        return this.tempIdle > 0 || this.getMode() == LocoMode.IDLE || Train.isTrainLockedDown(this);
    }

    public boolean isShutdown() {
        return this.getMode() == LocoMode.SHUTDOWN;
    }

    public void forceIdle(int ticks) {
        this.tempIdle = Math.max(this.tempIdle, ticks);
    }

    @Override
    public void reverse() {
        this.z += 180.0f;
        this.w = -this.w;
        this.y = -this.y;
    }

    @Override
    public void setRenderYaw(float yaw) {
        this.renderYaw = yaw;
    }

    public abstract String getWhistle();

    public final void whistle() {
        if (RailcraftConfig.playSounds() && this.whistleDelay <= 0) {
            this.p.a((lq)this, this.getWhistle(), 1.0f, this.whistlePitch);
            this.whistleDelay = 160;
        }
    }

    public void j_() {
        super.j_();
        ++this.update;
        if (Game.isNotHost(this.p)) {
            return;
        }
        if (this.whistleDelay > 0) {
            --this.whistleDelay;
        }
        if (this.tempIdle > 0) {
            --this.tempIdle;
        }
        if (this.update % 256 == 0 && this.isRunning() && this.aa.nextInt(4) == 0) {
            this.whistle();
        }
        if (this.isShutdown()) {
            double yaw = (double)this.z * Math.PI / 180.0;
            double cos = Math.cos(yaw);
            double sin = Math.sin(yaw);
            float limit = 0.05f;
            if (this.w > (double)limit && cos < 0.0) {
                this.z += 180.0f;
            } else if (this.w < (double)(-limit) && cos > 0.0) {
                this.z += 180.0f;
            } else if (this.y > (double)limit && sin < 0.0) {
                this.z += 180.0f;
            } else if (this.y < (double)(-limit) && sin > 0.0) {
                this.z += 180.0f;
            }
        }
    }

    protected void applyDragAndPushForces() {
        LocoSpeed speed;
        this.w *= this.getDrag();
        this.x *= 0.0;
        this.y *= this.getDrag();
        if (this.isRunning()) {
            boolean highSpeed = this.getEntityData().n("HighSpeed");
            double yaw = (double)this.z * Math.PI / 180.0;
            this.w += Math.cos(yaw) * (double)(highSpeed ? 0.52500004f : 0.15f);
            this.y += Math.sin(yaw) * (double)(highSpeed ? 0.52500004f : 0.15f);
        }
        if ((speed = this.getSpeed()) != LocoSpeed.MAX) {
            float limit = 0.4f;
            switch (speed) {
                case SLOWEST: {
                    limit = 0.1f;
                    break;
                }
                case SLOWER: {
                    limit = 0.2f;
                    break;
                }
                case SLOW: {
                    limit = 0.3f;
                }
            }
            this.w = Math.copySign(Math.min(Math.abs(this.w), (double)limit), this.w);
            this.y = Math.copySign(Math.min(Math.abs(this.y), (double)limit), this.y);
        }
    }

    protected void updateFuel() {
        if (this.e > 0) {
            if (this.isRunning() || this.isIdle() && this.update % 8 == 0) {
                --this.e;
            } else if (this.isShutdown()) {
                this.e = 0;
            }
        }
        if (this.e <= 0 && !this.isShutdown()) {
            this.e = this.getMoreGoJuice();
        }
        this.e(this.e > 0);
    }

    private boolean cartVelocityIsGreaterThan(float vel) {
        return Math.abs(this.w) > (double)vel || Math.abs(this.y) > (double)vel;
    }

    private boolean isKillabledEntity(lq entity) {
        if (entity.o instanceof py) {
            return false;
        }
        if (!(entity instanceof md)) {
            return false;
        }
        return ((md)entity).aT() < 100;
    }

    public int getDamageToRoadKill(md entity) {
        if (entity instanceof qx && ItemOveralls.isPlayerWearing((qx)entity)) {
            ur pants = ((qx)entity).p(2);
            InvTools.damageItem(pants, 5);
            return 4;
        }
        return 50;
    }

    public void f(lq entity) {
        if (Game.isHost(this.p)) {
            EntityLocomotive otherLoco;
            LinkageManager lm;
            if (entity.L) {
                return;
            }
            if (entity != this.n && this.cartVelocityIsGreaterThan(0.2f) && this.isKillabledEntity(entity)) {
                md living = (md)entity;
                living.a((lh)new DamageSourceTrain(this), this.getDamageToRoadKill(living));
                return;
            }
            if (entity instanceof EntityLocomotive && !(lm = LinkageManager.getInstance(this.p)).areLinked(this, otherLoco = (EntityLocomotive)entity) && this.cartVelocityIsGreaterThan(0.2f) && otherLoco.cartVelocityIsGreaterThan(0.2f) && (Math.abs(this.w - entity.w) > (double)0.3f || Math.abs(this.y - entity.y) > (double)0.3f)) {
                this.explode();
                if (!otherLoco.L) {
                    otherLoco.explode();
                }
                return;
            }
        }
        super.f(entity);
    }

    protected void explode() {
        CartUtils.explodeCart(this);
        this.x();
    }

    public abstract int getMoreGoJuice();

    protected void updatePushForces() {
    }

    public double getDrag() {
        return 0.9;
    }

    @Override
    public boolean doInteract(qx player) {
        ur current = player.bS();
        if (current != null && current.b() instanceof ItemWhistleTuner) {
            if (RailcraftConfig.playSounds() && this.whistleDelay <= 0) {
                this.whistlePitch = this.getNewWhistlePitch();
                this.whistle();
                current.a(1, (md)player);
            }
            return true;
        }
        return false;
    }

    public void b(bq data) {
        super.b(data);
        data.a("isInReverse", this.f);
        data.a("locomode", (byte)this.getMode().ordinal());
        data.a("locospeed", (byte)this.getSpeed().ordinal());
        data.a("primaryColor", this.getPrimaryColor());
        data.a("secondaryColor", this.getSecondaryColor());
        data.a("whistlePitch", this.whistlePitch);
    }

    public void a(bq data) {
        super.a(data);
        this.f = data.n("isInReverse");
        this.setMode(LocoMode.values()[data.c("locomode")]);
        this.setSpeed(LocoSpeed.values()[data.c("locospeed")]);
        this.setPrimaryColor(data.c("primaryColor"));
        this.setSecondaryColor(data.c("secondaryColor"));
        this.whistlePitch = data.g("whistlePitch");
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte(this.clientMode.ordinal());
        data.writeByte(this.clientSpeed.ordinal());
    }

    @Override
    public void readGuiData(DataInputStream data) throws IOException {
        this.setMode(LocoMode.VALUES[data.readByte()]);
        this.setSpeed(LocoSpeed.VALUES[data.readByte()]);
    }

    public boolean canBeRidden() {
        return false;
    }

    public int k_() {
        return 0;
    }

    public boolean isPoweredCart() {
        return true;
    }

    @Override
    public boolean isLinkable() {
        return true;
    }

    @Override
    public boolean canLinkWithCart(py cart) {
        if (cart instanceof EntityLocomotive) {
            return true;
        }
        LinkageManager lm = LinkageManager.getInstance(this.p);
        boolean links = false;
        py linkA = lm.getLinkedCartA(this);
        if (linkA != null && !(linkA instanceof EntityLocomotive)) {
            return false;
        }
        py linkB = lm.getLinkedCartB(this);
        return linkB == null || linkB instanceof EntityLocomotive;
    }

    @Override
    public boolean hasTwoLinks() {
        return true;
    }

    @Override
    public float getLinkageDistance(py cart) {
        return 1.25f;
    }

    @Override
    public float getOptimalDistance(py cart) {
        return 0.9f;
    }

    @Override
    public boolean canBeAdjusted(py cart) {
        return true;
    }

    @Override
    public void onLinkCreated(py cart) {
    }

    @Override
    public void onLinkBroken(py cart) {
    }

    public abstract String[] getLocomotiveTextures();

    public final byte getPrimaryColor() {
        return this.ag.a(20);
    }

    public final byte getSecondaryColor() {
        return this.ag.a(21);
    }

    public final void setPrimaryColor(int color) {
        this.ag.b(20, (Object)((byte)color));
    }

    public final void setSecondaryColor(int color) {
        this.ag.b(21, (Object)((byte)color));
    }

    public static enum LocoSpeed {
        MAX,
        SLOW,
        SLOWER,
        SLOWEST;

        public static final LocoSpeed[] VALUES;

        static {
            VALUES = LocoSpeed.values();
        }
    }

    public static enum LocoMode {
        RUNNING,
        IDLE,
        SHUTDOWN;

        public static final LocoMode[] VALUES;

        static {
            VALUES = LocoMode.values();
        }
    }
}

