/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.carts;

import buildcraft.api.inventory.ISpecialInventory;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.common.MinecartRegistry;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import railcraft.common.api.carts.CartBase;
import railcraft.common.api.carts.ILiquidTransfer;
import railcraft.common.api.carts.IMinecart;
import railcraft.common.carts.EnumCart;
import railcraft.common.carts.ItemCart;
import railcraft.common.carts.LinkageManager;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.liquids.LiquidManager;
import railcraft.common.liquids.TankManager;
import railcraft.common.liquids.tanks.StandardTank;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.inventory.InventoryCopy;
import railcraft.common.util.inventory.InventoryMapper;
import railcraft.common.util.inventory.PhantomInventory;
import railcraft.common.util.inventory.StandaloneInventory;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;

public class EntityCartTank
extends CartBase
implements ITankContainer,
ILiquidTransfer,
IEntityAdditionalSpawnData,
ISidedInventory,
ISpecialInventory,
IMinecart {
    public static up item;
    private static final byte LIQUID_ID_DATA_ID = 20;
    private static final byte LIQUID_META_DATA_ID = 21;
    private static final byte LIQUID_QTY_DATA_ID = 22;
    private static final byte FILLING_DATA_ID = 23;
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_OUTPUT = 1;
    private int update = MiscTools.getRand().nextInt();
    private final TankManager tankManager = new TankManager();
    private StandardTank tank = new StandardTank(RailcraftConfig.getTankCartCapacity());
    private final PhantomInventory invFilter = new PhantomInventory(1, this);
    private final StandaloneInventory invBucket = new StandaloneInventory(2, this);

    public static ur getFilterFromCartItem(ur cart) {
        int filterId;
        ur filter = null;
        bq nbt = cart.p();
        if (nbt != null && (filterId = nbt.e("filterId")) > 0) {
            int filterMeta = nbt.e("filterMeta");
            filter = new ur(filterId, 1, filterMeta);
        }
        return filter;
    }

    public static ur getCartItemForFilter(ur filter) {
        ur stack = new ur(item);
        if (filter != null) {
            bq nbt = new bq("tag");
            nbt.a("filterId", filter.c);
            nbt.a("filterMeta", filter.j());
            stack.d(nbt);
        }
        return stack;
    }

    public EntityCartTank(yc world) {
        super(world);
        this.tankManager.addTank(this.tank);
    }

    public EntityCartTank(yc world, double d, double d1, double d2) {
        this(world);
        this.b(d, d1 + (double)this.M, d2);
        this.w = 0.0;
        this.x = 0.0;
        this.y = 0.0;
        this.q = d;
        this.r = d1;
        this.s = d2;
    }

    protected void a() {
        super.a();
        this.ag.a(20, (Object)new Integer(0));
        this.ag.a(21, (Object)new Integer(0));
        this.ag.a(22, (Object)new Integer(0));
        this.ag.a(23, (Object)0);
    }

    private void setLiquidQty(int qty) {
        this.ag.b(22, (Object)qty);
    }

    private int getLiquidQty() {
        return this.ag.c(22);
    }

    private void setLiquidId(int liquidId) {
        this.ag.b(20, (Object)liquidId);
    }

    private int getLiquidId() {
        return this.ag.c(20);
    }

    private void setLiquidMeta(int liquidId) {
        this.ag.b(21, (Object)liquidId);
    }

    private int getLiquidMeta() {
        return this.ag.c(21);
    }

    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public void x() {
        super.x();
        InvTools.dropInventory(this.invBucket, this.p, (int)this.t, (int)this.u, (int)this.v);
    }

    public void j_() {
        ur bottomSlot;
        super.j_();
        if (Game.isNotHost(this.p)) {
            if (this.getLiquidId() != 0) {
                LiquidStack liquid = new LiquidStack(this.getLiquidId(), this.getLiquidQty(), this.getLiquidMeta());
                this.tank.setLiquid(liquid);
            } else {
                this.tank.setLiquid(null);
            }
            return;
        }
        LiquidStack liquid = this.tank.getLiquid();
        if (liquid != null) {
            if (liquid.itemID != this.getLiquidId()) {
                this.setLiquidId(liquid.itemID);
            }
            if (liquid.itemMeta != this.getLiquidMeta()) {
                this.setLiquidMeta(liquid.itemMeta);
            }
            if (liquid.amount != this.getLiquidQty()) {
                this.setLiquidQty(liquid.amount);
            }
        } else if (this.getLiquidId() != 0) {
            this.setLiquidId(0);
            this.setLiquidMeta(0);
            this.setLiquidQty(0);
        }
        ++this.update;
        ur topSlot = this.invBucket.a(0);
        if (topSlot != null && !LiquidManager.getInstance().isContainer(topSlot)) {
            this.invBucket.a(0, null);
            this.a(topSlot, 1.0f);
        }
        if ((bottomSlot = this.invBucket.a(1)) != null && !LiquidManager.getInstance().isContainer(bottomSlot)) {
            this.invBucket.a(1, null);
            this.a(bottomSlot, 1.0f);
        }
        if (this.update % 8 == 0) {
            LiquidManager.getInstance().processContainers(this, 0, this.invBucket, 0, 1);
        }
    }

    @Override
    public boolean doInteract(qx player) {
        if (Game.isHost(this.getWorld())) {
            if (LiquidManager.getInstance().handleRightClick(this, 0, player, true, true)) {
                return true;
            }
            GuiHandler.openGui(EnumGui.CART_TANK, player, this.p, (lq)this);
        }
        return true;
    }

    public ur getCartItem() {
        ur drop = MinecartRegistry.getItemForCart((py)this);
        if (this.hasFilter()) {
            bq nbt = new bq("tag");
            nbt.a("filterId", this.getFilterItem().c);
            nbt.a("filterMeta", this.getFilterItem().j());
            drop.d(nbt);
        }
        return drop;
    }

    public List getItemsDropped() {
        ArrayList<ur> items = new ArrayList<ur>();
        items.add(this.getCartItem());
        return items;
    }

    protected double getDrag() {
        return 0.991999979019165;
    }

    public boolean isStorageCart() {
        return false;
    }

    public boolean canBeRidden() {
        return false;
    }

    public int k_() {
        return 0;
    }

    public String b() {
        return RailcraftLanguage.translate(EnumCart.TANK.getTag());
    }

    protected void a(bq data) {
        super.a(data);
        this.invFilter.readFromNBT("invFilter", data);
        this.invBucket.readFromNBT("invBucket", data);
        this.tankManager.readTanksFromNBT(data);
    }

    protected void b(bq data) {
        super.b(data);
        this.invFilter.writeToNBT("invFilter", data);
        this.invBucket.writeToNBT("invBucket", data);
        this.tankManager.writeTanksToNBT(data);
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (tankIndex != 0 || resource == null) {
            return 0;
        }
        if (this.getFilterLiquid() == null || resource.isLiquidEqual(this.getFilterLiquid())) {
            return this.tank.fill(resource, doFill);
        }
        return 0;
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(0, maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        if (tankIndex != 0) {
            return null;
        }
        return this.tank.drain(maxDrain, doDrain);
    }

    public ILiquidTank[] getTanks(ForgeDirection side) {
        return new ILiquidTank[]{this.tank};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.tank;
    }

    @Override
    public void setFilling(boolean fill) {
        this.ag.b(23, (Object)(fill ? (byte)1 : 0));
    }

    @Override
    public boolean isFilling() {
        return this.ag.a(23) != 0;
    }

    public boolean hasFilter() {
        return this.getFilterItem() != null;
    }

    public LiquidStack getFilterLiquid() {
        ur filter = this.getFilterItem();
        if (filter == null) {
            return null;
        }
        return LiquidManager.getInstance().getLiquidInContainer(filter);
    }

    public ur getFilterItem() {
        return this.getFilter().a(0);
    }

    public void setFilter(ur filter) {
        this.getFilter().a(0, filter);
    }

    public PhantomInventory getFilter() {
        return this.invFilter;
    }

    public la getInvBucket() {
        return this.invBucket;
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        data.writeInt(this.getFilterItem() != null ? this.getFilterItem().c : 0);
        data.writeInt(this.getFilterItem() != null ? this.getFilterItem().j() : 0);
    }

    public void readSpawnData(ByteArrayDataInput data) {
        int filterId = data.readInt();
        int filterMeta = data.readInt();
        if (filterId > 0) {
            ur filter = new ur(filterId, 1, filterMeta);
            this.setFilter(filter);
        }
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        if (LiquidManager.getInstance().isContainer(stack)) {
            ur result;
            Object slot = new InventoryMapper(this, 0, 1);
            if (!doAdd) {
                slot = new InventoryCopy((la)slot);
            }
            if ((result = InvTools.moveItemStack(stack, slot)) != null && stack.a != result.a) {
                int used = stack.a - result.a;
                return used;
            }
            if (result == null) {
                return stack.a;
            }
        }
        return 0;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        ur result;
        Object slot = new InventoryMapper(this, 1, 1);
        if (!doRemove) {
            slot = new InventoryCopy((la)slot);
        }
        if ((result = slot.a(0, maxItemCount)) == null || result.a <= 0) {
            return new ur[0];
        }
        return new ur[]{result};
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.UP) {
            return 0;
        }
        return 1;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    @Override
    public boolean doesCartMatchFilter(ur stack, py cart) {
        return ItemCart.getCartType(stack) == EnumCart.TANK;
    }

    @Override
    public int offerLiquid(Object source, LiquidStack offer) {
        int qty = offer.amount;
        int used = this.fill(0, offer, true);
        offer.amount = qty - used;
        if (offer.amount <= 0) {
            return used;
        }
        LinkageManager lm = LinkageManager.getInstance(this.p);
        py linkedCart = lm.getLinkedCartA(this);
        if (linkedCart != source && linkedCart instanceof ILiquidTransfer) {
            used += ((ILiquidTransfer)linkedCart).offerLiquid(this, offer);
        }
        offer.amount = qty - used;
        if (offer.amount <= 0) {
            return used;
        }
        linkedCart = lm.getLinkedCartB(this);
        if (linkedCart != source && linkedCart instanceof ILiquidTransfer) {
            used += ((ILiquidTransfer)linkedCart).offerLiquid(this, offer);
        }
        return used;
    }

    @Override
    public int requestLiquid(Object source, LiquidStack request) {
        LiquidStack acquired = this.drain(0, request.amount, false);
        if (acquired == null || !request.isLiquidEqual(acquired)) {
            return 0;
        }
        this.drain(0, request.amount, true);
        if (acquired.amount >= request.amount) {
            return acquired.amount;
        }
        LiquidStack newRequest = request.copy();
        newRequest.amount = request.amount - acquired.amount;
        LinkageManager lm = LinkageManager.getInstance(this.p);
        py linkedCart = lm.getLinkedCartA(this);
        if (linkedCart != source && linkedCart instanceof ILiquidTransfer) {
            acquired.amount += ((ILiquidTransfer)linkedCart).requestLiquid(this, newRequest);
        }
        if (acquired.amount >= request.amount) {
            return acquired.amount;
        }
        newRequest.amount = request.amount - acquired.amount;
        linkedCart = lm.getLinkedCartB(this);
        if (linkedCart != source && linkedCart instanceof ILiquidTransfer) {
            acquired.amount += ((ILiquidTransfer)linkedCart).requestLiquid(this, newRequest);
        }
        return acquired.amount;
    }
}

