/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.carts;

import java.util.ArrayList;
import java.util.List;
import railcraft.common.carts.EntityCartTNT;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.items.RailcraftToolItems;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.misc.Game;

public class EntityCartGift
extends EntityCartTNT {
    private static final byte SPAWN_DIST = 2;
    private static final List gifts = new ArrayList();
    private static final List potions = new ArrayList();

    public static void addGift(ur gift, int chance) {
        if (gift != null) {
            gifts.add(new Gift(gift, chance));
        }
    }

    public EntityCartGift(yc world) {
        super(world);
    }

    public EntityCartGift(yc world, double d, double d1, double d2) {
        this(world);
        this.b(d, d1 + (double)this.M, d2);
        this.w = 0.0;
        this.x = 0.0;
        this.y = 0.0;
        this.q = d;
        this.r = d1;
        this.s = d2;
        this.setBlastRadius(1.5f);
    }

    @Override
    public List getItemsDropped() {
        ArrayList<ur> items = new ArrayList<ur>();
        if (RailcraftConfig.doCartsBreakOnDrop()) {
            items.add(new ur(up.az));
            items.add(new ur(amq.bd));
        } else {
            items.add(this.getCartItem());
        }
        return items;
    }

    @Override
    protected byte getMinBlastRadius() {
        return 1;
    }

    @Override
    protected byte getMaxBlastRadius() {
        return 2;
    }

    @Override
    public void explode() {
        if (Game.isHost(this.getWorld())) {
            this.p.a((lq)this, this.t, this.u, this.v, this.getBlastRadius(), true);
            this.x();
            if (this.aa.nextInt(100) >= 50) {
                this.spawnGift();
                this.spawnGift();
            } else {
                this.spawnCoal();
            }
        }
    }

    private Gift getGift() {
        int weight;
        Gift gift;
        do {
            int index = this.aa.nextInt(gifts.size());
            gift = (Gift)gifts.get(index);
        } while (gift.chance < (weight = this.aa.nextInt(100)));
        return gift;
    }

    private void spawnGift() {
        Gift gift = this.getGift();
        if (gift.stack == null) {
            this.spawnPotion();
            return;
        }
        double x = this.t + (this.aa.nextDouble() - this.aa.nextDouble()) * 2.0;
        double y = this.u + 1.0 + (double)this.aa.nextInt(3) - 1.0;
        double z = this.v + (this.aa.nextDouble() - this.aa.nextDouble()) * 2.0;
        InvTools.dropItem(gift.stack.l(), this.p, x, y, z);
    }

    private void spawnCoal() {
        double x = this.t + (this.aa.nextDouble() - this.aa.nextDouble()) * 2.0;
        double y = this.u + 1.0 + (double)this.aa.nextInt(3) - 1.0;
        double z = this.v + (this.aa.nextDouble() - this.aa.nextDouble()) * 2.0;
        InvTools.dropItem(new ur(up.m), this.p, x, y, z);
    }

    private void spawnPotion() {
        int meta = (Integer)potions.get(this.aa.nextInt(potions.size()));
        ur potion = new ur((up)up.bs, 1, meta);
        double x = this.t + (this.aa.nextDouble() - this.aa.nextDouble()) * 2.0;
        double y = this.u + 1.0 + (double)this.aa.nextInt(3) - 1.0;
        double z = this.v + (this.aa.nextDouble() - this.aa.nextDouble()) * 2.0;
        InvTools.dropItem(potion, this.p, x, y, z);
    }

    @Override
    public String b() {
        return "Gift Cart";
    }

    @Override
    public amq getBlock() {
        return amq.bY;
    }

    @Override
    public int getBlockMetadata() {
        return 0;
    }

    static {
        gifts.add(new Gift(null, 100));
        gifts.add(new Gift(null, 100));
        gifts.add(new Gift(null, 100));
        gifts.add(new Gift(null, 100));
        gifts.add(new Gift(null, 100));
        gifts.add(new Gift(new ur(up.aD, 16), 50));
        gifts.add(new Gift(new ur(amq.bj), 25));
        gifts.add(new Gift(new ur(up.F), 25));
        gifts.add(new Gift(new ur(up.bc, 15), 75));
        gifts.add(new Gift(new ur(up.bc, 10), 75));
        gifts.add(new Gift(new ur(up.bc, 5), 75));
        gifts.add(new Gift(new ur(up.bT), 20));
        gifts.add(new Gift(new ur(amq.U), 5));
        gifts.add(new Gift(new ur(up.as), 10));
        gifts.add(new Gift(new ur(up.bJ), 25));
        gifts.add(new Gift(new ur(up.aQ), 25));
        gifts.add(new Gift(new ur(up.aS), 25));
        EntityCartGift.addGift(RailcraftToolItems.getCrowbar(), 20);
        gifts.add(new Gift(new ur(up.bD, 32), 5));
        gifts.add(new Gift(new ur(up.bD, 16), 10));
        gifts.add(new Gift(new ur(up.bD, 8), 20));
        gifts.add(new Gift(new ur(up.bD, 4), 40));
        gifts.add(new Gift(new ur(up.bD, 2), 80));
        gifts.add(new Gift(new ur(amq.aA), 1));
        gifts.add(new Gift(new ur(amq.bY), 2));
        gifts.add(new Gift(new ur(up.bH), 30));
        gifts.add(new Gift(new ur(up.n), 20));
        gifts.add(new Gift(new ur(up.p), 30));
        gifts.add(new Gift(new ur(up.p, 2), 30));
        gifts.add(new Gift(new ur(up.bq, 8), 80));
        gifts.add(new Gift(new ur(up.bq, 16), 40));
        gifts.add(new Gift(new ur(up.bq, 32), 20));
        gifts.add(new Gift(new ur(up.bn), 30));
        gifts.add(new Gift(new ur(up.bS), 2));
        int recordChance = 1;
        gifts.add(new Gift(new ur(up.ch), recordChance));
        gifts.add(new Gift(new ur(up.bX), recordChance));
        gifts.add(new Gift(new ur(up.bZ), recordChance));
        gifts.add(new Gift(new ur(up.bY), recordChance));
        gifts.add(new Gift(new ur(up.ca), recordChance));
        gifts.add(new Gift(new ur(up.cb), recordChance));
        gifts.add(new Gift(new ur(up.cc), recordChance));
        gifts.add(new Gift(new ur(up.cd), recordChance));
        gifts.add(new Gift(new ur(up.ce), recordChance));
        gifts.add(new Gift(new ur(up.cf), recordChance));
        gifts.add(new Gift(new ur(up.cg), recordChance));
        gifts.add(new Gift(new ur(up.cg), recordChance));
        int toolChance = 10;
        gifts.add(new Gift(new ur(up.aR), toolChance));
        gifts.add(new Gift(new ur(up.k), toolChance));
        gifts.add(new Gift(new ur((up)up.be), toolChance));
        gifts.add(new Gift(new ur(up.C), toolChance));
        gifts.add(new Gift(new ur(up.B), toolChance));
        gifts.add(new Gift(new ur(up.A), toolChance));
        gifts.add(new Gift(new ur(up.z), toolChance));
        gifts.add(new Gift(new ur(up.Q), toolChance));
        gifts.add(new Gift(new ur(up.J), toolChance));
        gifts.add(new Gift(new ur(up.I), toolChance));
        gifts.add(new Gift(new ur(up.H), toolChance));
        gifts.add(new Gift(new ur(up.G), toolChance));
        gifts.add(new Gift(new ur(up.R), toolChance));
        gifts.add(new Gift(new ur(up.h), toolChance));
        gifts.add(new Gift(new ur(up.g), toolChance));
        gifts.add(new Gift(new ur(up.f), toolChance));
        gifts.add(new Gift(new ur(up.q), toolChance));
        gifts.add(new Gift(new ur(up.P), toolChance));
        EntityCartGift.addGift(RailcraftToolItems.getSteelAxe(), toolChance);
        EntityCartGift.addGift(RailcraftToolItems.getSteelPickaxe(), toolChance);
        EntityCartGift.addGift(RailcraftToolItems.getSteelSword(), toolChance);
        EntityCartGift.addGift(RailcraftToolItems.getSteelShovel(), toolChance);
        EntityCartGift.addGift(RailcraftToolItems.getSteelHoe(), toolChance);
        int armorChance = 5;
        gifts.add(new Gift(new ur(up.ah), armorChance));
        gifts.add(new Gift(new ur(up.ai), armorChance));
        gifts.add(new Gift(new ur(up.aj), armorChance));
        gifts.add(new Gift(new ur(up.ak), armorChance));
        gifts.add(new Gift(new ur(up.al), armorChance));
        gifts.add(new Gift(new ur(up.am), armorChance));
        gifts.add(new Gift(new ur(up.an), armorChance));
        gifts.add(new Gift(new ur(up.ao), armorChance));
        gifts.add(new Gift(new ur(up.ad), armorChance));
        gifts.add(new Gift(new ur(up.ae), armorChance));
        gifts.add(new Gift(new ur(up.af), armorChance));
        gifts.add(new Gift(new ur(up.ag), armorChance));
        gifts.add(new Gift(new ur(up.V), armorChance));
        gifts.add(new Gift(new ur(up.W), armorChance));
        gifts.add(new Gift(new ur(up.X), armorChance));
        gifts.add(new Gift(new ur(up.Y), armorChance));
        EntityCartGift.addGift(RailcraftToolItems.getSteelHelm(), armorChance);
        EntityCartGift.addGift(RailcraftToolItems.getSteelArmor(), armorChance);
        EntityCartGift.addGift(RailcraftToolItems.getSteelLegs(), armorChance);
        EntityCartGift.addGift(RailcraftToolItems.getSteelBoots(), armorChance);
        for (int meta = 0; meta <= Short.MAX_VALUE; ++meta) {
            List effects = vx.b((int)meta, (boolean)false);
            if (effects == null || effects.isEmpty()) continue;
            potions.add(meta);
        }
    }

    private static class Gift {
        public final int chance;
        public final ur stack;

        public Gift(ur stack, int chance) {
            this.stack = stack;
            this.chance = chance;
        }
    }
}

