/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.tracks;

import railcraft.common.api.tracks.ITrackLockdown;
import railcraft.common.api.tracks.ITrackPowered;
import railcraft.common.blocks.tracks.EnumTrack;
import railcraft.common.blocks.tracks.TrackLockingBase;
import railcraft.common.util.misc.Game;

public class TrackLockdown
extends TrackLockingBase
implements ITrackPowered,
ITrackLockdown {
    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.LOCKDOWN;
    }

    @Override
    public void updateEntity() {
        if (this.getCurrentCart() != null && this.getCurrentCart().L) {
            this.setCurrentCart(null);
        }
        if (Game.isHost(this.getWorld())) {
            if (this.isPowered()) {
                this.delay = this.getDelayTime();
            } else if (this.delay > 0) {
                this.delay = (byte)(this.delay - 1);
                if (this.delay == 0) {
                    this.setCurrentCart(null);
                }
            }
        }
        if (this.prevDelay == 0 ^ this.delay == 0) {
            this.sendUpdateToClient();
        }
        this.prevDelay = this.delay;
    }

    @Override
    public void onMinecartPass(py cart) {
        this.checkCart(cart);
        if (!this.isPowered() && this.delay <= 0) {
            if (this.getCurrentCart() == null) {
                this.setCurrentCart(cart);
            }
            if (this.getCurrentCart() == cart) {
                this.lockCart(cart);
                cart.w = 0.0;
                cart.y = 0.0;
                int meta = this.tileEntity.p();
                if (meta == 0 || meta == 4 || meta == 5) {
                    cart.v = (double)this.tileEntity.n + 0.5;
                } else {
                    cart.t = (double)this.tileEntity.l + 0.5;
                }
            }
        } else {
            this.releaseCart(cart);
        }
    }
}

