/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraftforge.common.ForgeDirection;
import railcraft.common.api.core.IPostConnection;
import railcraft.common.api.tracks.ITrackBlocksMovement;
import railcraft.common.api.tracks.ITrackCustomShape;
import railcraft.common.api.tracks.ITrackPowered;
import railcraft.common.api.tracks.ITrackReversable;
import railcraft.common.blocks.tracks.EnumTrack;
import railcraft.common.blocks.tracks.TrackBaseRailcraft;
import railcraft.common.util.misc.MiscTools;
import railcraft.common.util.sounds.SoundHelper;

public class TrackGated
extends TrackBaseRailcraft
implements ITrackReversable,
ITrackPowered,
ITrackCustomShape,
IPostConnection,
ITrackBlocksMovement {
    protected boolean powered;
    protected boolean open;
    protected boolean reversed;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.GATED;
    }

    @Override
    public int getTextureIndex() {
        return this.getTrackType().getTextureIndex();
    }

    @Override
    public boolean blockActivated(qx player) {
        if (!super.blockActivated(player)) {
            this.setOpen(!this.open);
        }
        return true;
    }

    @Override
    public aoe getSelectedBoundingBoxFromPool() {
        return aoe.a().a((double)this.tileEntity.l, (double)this.tileEntity.m, (double)this.tileEntity.n, (double)(this.tileEntity.l + 1), (double)(this.tileEntity.m + 1), (double)(this.tileEntity.n + 1));
    }

    @Override
    public aoh collisionRayTrace(aoj vec3d, aoj vec3d1) {
        return MiscTools.collisionRayTrace(vec3d, vec3d1, this.getX(), this.getY(), this.getZ());
    }

    @Override
    public aoe getCollisionBoundingBoxFromPool() {
        int meta = this.tileEntity.p();
        if (this.isGateOpen()) {
            return null;
        }
        if (meta == 0) {
            return aoe.a().a((double)this.tileEntity.l, (double)this.tileEntity.m, (double)((float)this.tileEntity.n + 0.375f), (double)(this.tileEntity.l + 1), (double)((float)this.tileEntity.m + 1.5f), (double)((float)this.tileEntity.n + 0.625f));
        }
        return aoe.a().a((double)((float)this.tileEntity.l + 0.375f), (double)this.tileEntity.m, (double)this.tileEntity.n, (double)((float)this.tileEntity.l + 0.625f), (double)((float)this.tileEntity.m + 1.5f), (double)(this.tileEntity.n + 1));
    }

    @Override
    public boolean canMakeSlopes() {
        return false;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void setOpen(boolean open) {
        boolean state = this.isGateOpen();
        this.open = open;
        if (state != this.isGateOpen()) {
            this.playSound();
            this.sendUpdateToClient();
        }
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("powered", this.powered);
        nbttagcompound.a("open", this.open);
        nbttagcompound.a("reversed", this.reversed);
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.powered = nbttagcompound.n("powered");
        this.open = nbttagcompound.n("open");
        this.reversed = nbttagcompound.n("reversed");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
        data.writeBoolean(this.reversed);
        data.writeBoolean(this.open);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.setPowered(data.readBoolean());
        this.setReversed(data.readBoolean());
        this.setOpen(data.readBoolean());
        this.markBlockNeedsUpdate();
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        boolean state = this.isGateOpen();
        this.powered = powered;
        if (state != this.isGateOpen()) {
            this.playSound();
            this.sendUpdateToClient();
        }
    }

    private void playSound() {
        SoundHelper.playFX(this.getWorld(), null, 1003, this.tileEntity.l, this.tileEntity.m, this.tileEntity.n, 0);
    }

    public boolean isGateOpen() {
        return this.isPowered() || this.isOpen();
    }

    @Override
    public boolean connectsAt(yc world, int i, int j, int k, ForgeDirection side) {
        switch (side) {
            case UP: 
            case DOWN: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean blocksMovement() {
        return !this.isGateOpen();
    }
}

