/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.tracks;

import java.util.ArrayList;
import net.minecraftforge.common.ForgeDirection;
import railcraft.common.api.carts.CartTools;
import railcraft.common.blocks.tracks.MaterialElevator;
import railcraft.common.util.misc.Game;

public class BlockTrackElevator
extends amq {
    public static double CLIMB_UP_VELOCITY = 0.2;
    public static double CLIMB_DOWN_VELOCITY = -0.3;
    public static double FALL_DOWN_CORRECTION = 0.04f;
    public static final int FACING_EAST_METADATA_VALUE = 2;
    public static final int FACING_WEST_METADATA_VALUE = 3;
    public static final int FACING_NORTH_METADATA_VALUE = 4;
    public static final int FACING_SOUTH_METADATA_VALUE = 5;
    public static final double RIDE_UP_VELOCITY = 0.4;
    public static final double RIDE_DOWN_VELOCITY = -0.4;
    public static final int BLOCK_FACING_DATA_METADATA_MASK = 7;
    private int renderType;

    public BlockTrackElevator(int blockId, int renderId) {
        super(blockId, 84, (agi)new MaterialElevator());
        this.c(1.05f);
        this.a(i);
        this.renderType = renderId;
        this.a(tj.e);
    }

    public aoh a(yc world, int i, int j, int k, aoj vec3d, aoj vec3d1) {
        this.a((ym)world, i, j, k);
        return super.a(world, i, j, k, vec3d, vec3d1);
    }

    public void a(ym world, int i, int j, int k) {
        int meta = this.getLadderFacingMetadata(world, i, j, k);
        float f = 0.125f;
        if (meta == 2) {
            this.a(0.0f, 0.0f, 1.0f - f, 1.0f, 1.0f, 1.0f);
        }
        if (meta == 3) {
            this.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f);
        }
        if (meta == 4) {
            this.a(1.0f - f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
        if (meta == 5) {
            this.a(0.0f, 0.0f, 0.0f, f, 1.0f, 1.0f);
        }
    }

    public aoe e(yc world, int i, int j, int k) {
        return null;
    }

    public aoe b_(yc world, int i, int j, int k) {
        this.a((ym)world, i, j, k);
        return aoe.a().a((double)i + this.ct, (double)j + this.cu, (double)k + this.cv, (double)i + this.cw, (double)j + this.cx, (double)k + this.cy);
    }

    public String getTextureFile() {
        return "/railcraft/client/textures/tracks.png";
    }

    public int d() {
        return this.renderType;
    }

    public boolean isLadder(yc world, int i, int j, int k) {
        return true;
    }

    public boolean c() {
        return false;
    }

    public boolean b() {
        return false;
    }

    public boolean isACube() {
        return false;
    }

    public void addCreativeItems(ArrayList itemList) {
        itemList.add(new ur((amq)this));
    }

    public int a(int side, int meta) {
        boolean powered;
        boolean bl = powered = (meta & 8) != 0;
        if (!powered) {
            return this.cl + 1;
        }
        return this.cl;
    }

    public boolean b(yc world, int i, int j, int k) {
        if (world.isBlockSolidOnSide(i - 1, j, k, ForgeDirection.EAST)) {
            return true;
        }
        if (world.isBlockSolidOnSide(i + 1, j, k, ForgeDirection.WEST)) {
            return true;
        }
        if (world.isBlockSolidOnSide(i, j, k - 1, ForgeDirection.SOUTH)) {
            return true;
        }
        return world.isBlockSolidOnSide(i, j, k + 1, ForgeDirection.NORTH);
    }

    public int a(yc world, int x, int y, int z, int side, float par6, float par7, float par8, int meta) {
        if ((meta == 0 || side == 2) && world.isBlockSolidOnSide(x, y, z + 1, ForgeDirection.NORTH)) {
            meta = 2;
        }
        if ((meta == 0 || side == 3) && world.isBlockSolidOnSide(x, y, z - 1, ForgeDirection.SOUTH)) {
            meta = 3;
        }
        if ((meta == 0 || side == 4) && world.isBlockSolidOnSide(x + 1, y, z, ForgeDirection.WEST)) {
            meta = 4;
        }
        if ((meta == 0 || side == 5) && world.isBlockSolidOnSide(x - 1, y, z, ForgeDirection.EAST)) {
            meta = 5;
        }
        return meta;
    }

    public void g(yc world, int x, int y, int z, int meta) {
        boolean powered;
        int id;
        alr railBlock;
        this.a((ym)world, x, y, z);
        if (alr.e_((yc)world, (int)x, (int)(y - 1), (int)z) && (railBlock = (alr)amq.p[id = world.a(x, y - 1, z)]).canMakeSlopes(world, x, y - 1, z)) {
            int trackMeta = railBlock.getBasicRailMetadata((ym)world, null, x, y - 1, z);
            int ladderMeta = this.getLadderFacingMetadata((ym)world, x, y, z);
            int outputMeta = 0;
            if (trackMeta == 0 && ladderMeta == 2) {
                outputMeta = 5;
            } else if (trackMeta == 0 && ladderMeta == 3) {
                outputMeta = 4;
            } else if (trackMeta == 1 && ladderMeta == 4) {
                outputMeta = 2;
            } else if (trackMeta == 1 && ladderMeta == 5) {
                outputMeta = 3;
            }
            if (outputMeta != 0) {
                if (railBlock.hasPowerBit(world, x, y - 1, z)) {
                    outputMeta |= world.h(x, y - 1, z) & 8;
                }
                world.c(x, y - 1, z, outputMeta);
            }
        }
        boolean bl = powered = ((meta = world.h(x, y, z)) & 8) != 0;
        if (powered ^ this.isPowered(world, x, y, z)) {
            world.c(x, y, z, meta ^ 8);
        }
        world.i(x, y, z);
    }

    public void a(yc world, int i, int j, int k, int l, float f, int i1) {
        super.a(world, i, j, k, l, f, i1);
    }

    public void a(yc world, int i, int j, int k, int l) {
        int meta = world.h(i, j, k);
        int ladderMeta = this.getLadderFacingMetadata((ym)world, i, j, k);
        boolean valid = false;
        if (ladderMeta == 2 && world.isBlockSolidOnSide(i, j, k + 1, ForgeDirection.NORTH)) {
            valid = true;
        }
        if (ladderMeta == 3 && world.isBlockSolidOnSide(i, j, k - 1, ForgeDirection.SOUTH)) {
            valid = true;
        }
        if (ladderMeta == 4 && world.isBlockSolidOnSide(i + 1, j, k, ForgeDirection.WEST)) {
            valid = true;
        }
        if (ladderMeta == 5 && world.isBlockSolidOnSide(i - 1, j, k, ForgeDirection.EAST)) {
            valid = true;
        }
        if (!valid) {
            this.c(world, i, j, k, ladderMeta, 0);
            world.e(i, j, k, 0);
        } else {
            boolean powered;
            boolean bl = powered = (meta & 8) != 0;
            if (powered ^ this.isPowered(world, i, j, k)) {
                world.c(i, j, k, meta ^ 8);
                world.i(i, j, k);
            }
        }
    }

    public void a(yc world, int i, int j, int k, lq entity) {
        entity.S = 0.0f;
        if (Game.isNotHost(world) || !(entity instanceof py)) {
            return;
        }
        this.minecartInteraction(world, (py)entity, i, j, k);
    }

    public int getLadderFacingMetadata(ym world, int i, int j, int k) {
        return world.h(i, j, k) & 7;
    }

    public boolean getPoweredBit(yc world, int i, int j, int k) {
        return (world.h(i, j, k) & 8) != 0;
    }

    protected boolean isPowered(yc world, int x, int y, int z) {
        int meta = this.getLadderFacingMetadata((ym)world, x, y, z);
        if (world.a(x, y - 1, z) == this.cm && meta == this.getLadderFacingMetadata((ym)world, x, y - 1, z) && (world.A(x, y - 1, z) || world.B(x, y - 1, z))) {
            return true;
        }
        if (world.A(x, y, z) || world.B(x, y, z)) {
            return true;
        }
        return world.a(x, y + 1, z) == this.cm && meta == this.getLadderFacingMetadata((ym)world, x, y + 1, z) && this.isPowered(world, x, y + 1, z);
    }

    protected void minecartInteraction(yc world, py cart, int i, int j, int k) {
        cart.getEntityData().a("elevator", (byte)20);
        boolean powered = this.getPoweredBit(world, i, j, k);
        if (powered) {
            if (world.a(i, j + 1, k) == this.cm || this.isOffloadRail(world, i, j + 1, k)) {
                boolean empty = true;
                for (py c : CartTools.getMinecartsAt(world, i, j + 1, k, 0.2f)) {
                    if (c == cart) continue;
                    empty = false;
                }
                if ((this.getPoweredBit(world, i, j + 1, k) || this.isOffloadRail(world, i, j + 1, k)) && empty) {
                    cart.x = 0.4 + FALL_DOWN_CORRECTION;
                } else {
                    if (this.pushMinecartOntoRail(world, i, j, k, cart)) {
                        return;
                    }
                    cart.b(cart.t, (double)((float)j + 0.5f), cart.v);
                    cart.x = FALL_DOWN_CORRECTION;
                }
            } else {
                cart.b(cart.t, (double)((float)j + 0.5f), cart.v);
            }
        } else {
            if (world.a(i, j - 1, k) != this.cm) {
                this.pushMinecartOntoRail(world, i, j, k, cart);
                return;
            }
            boolean empty = true;
            for (py c : CartTools.getMinecartsAt(world, i, j - 1, k, 0.2f)) {
                if (c == cart) continue;
                empty = false;
            }
            if (empty) {
                cart.x = -0.4 + FALL_DOWN_CORRECTION;
            } else {
                cart.b(cart.t, (double)((float)j + 0.5f), cart.v);
                cart.x = FALL_DOWN_CORRECTION;
            }
        }
        if (powered || !alr.e_((yc)world, (int)i, (int)(j - 1), (int)k)) {
            if (alr.e_((yc)world, (int)i, (int)(j - 1), (int)k) || alr.e_((yc)world, (int)i, (int)(j - 2), (int)k)) {
                cart.setCanUseRail(false);
            } else {
                cart.setCanUseRail(true);
            }
            this.keepMinecartConnected(world, i, j, k, cart);
        } else {
            cart.setCanUseRail(true);
        }
        if (powered) {
            this.pushMinecartOnSupportingBlockIfPossible(world, i, j, k, cart);
        }
    }

    protected void keepMinecartConnected(yc world, int i, int j, int k, py minecart) {
        minecart.w = (double)i + 0.5 - minecart.t;
        minecart.y = (double)k + 0.5 - minecart.v;
        this.allignMinecart(world, i, j, k, minecart);
    }

    protected void allignMinecart(yc world, int i, int j, int k, py minecart) {
        switch (this.getLadderFacingMetadata((ym)world, i, j, k)) {
            case 4: 
            case 5: {
                minecart.z = minecart.z <= 90.0f || minecart.z > 270.0f ? 0.0f : 180.0f;
                return;
            }
            case 2: 
            case 3: {
                minecart.z = minecart.z > 180.0f ? 270.0f : 90.0f;
                return;
            }
        }
    }

    private boolean isOffloadRail(yc world, int i, int j, int k) {
        if (world.a(i, j, k) != this.cm) {
            switch (world.h(i, j - 1, k) & 7) {
                case 2: {
                    if (alr.e_((yc)world, (int)i, (int)j, (int)(k + 1))) {
                        return true;
                    }
                }
                case 3: {
                    if (alr.e_((yc)world, (int)i, (int)j, (int)(k - 1))) {
                        return true;
                    }
                }
                case 4: {
                    if (alr.e_((yc)world, (int)(i + 1), (int)j, (int)k)) {
                        return true;
                    }
                }
                case 5: {
                    if (!alr.e_((yc)world, (int)(i - 1), (int)j, (int)k)) break;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean pushMinecartOnSupportingBlockIfPossible(yc world, int i, int j, int k, py minecart) {
        if (!world.g(i, j, k).a()) {
            switch (world.h(i, j, k) & 7) {
                case 2: {
                    if (alr.e_((yc)world, (int)i, (int)(j + 1), (int)(k + 1))) {
                        minecart.x = 0.4;
                        minecart.y = 0.4;
                    }
                    return true;
                }
                case 3: {
                    if (alr.e_((yc)world, (int)i, (int)(j + 1), (int)(k - 1))) {
                        minecart.x = 0.4;
                        minecart.y = -0.4;
                    }
                    return true;
                }
                case 4: {
                    if (alr.e_((yc)world, (int)(i + 1), (int)(j + 1), (int)k)) {
                        minecart.x = 0.4;
                        minecart.w = 0.4;
                    }
                    return true;
                }
                case 5: {
                    if (alr.e_((yc)world, (int)(i - 1), (int)(j + 1), (int)k)) {
                        minecart.x = 0.4;
                        minecart.w = -0.4;
                    }
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private boolean pushMinecartOntoRail(yc world, int i, int j, int k, py cart) {
        cart.setCanUseRail(true);
        switch (world.h(i, j, k) & 7) {
            case 2: {
                if (!alr.e_((yc)world, (int)i, (int)j, (int)(k - 1))) break;
                cart.b(cart.t, (double)((float)j + 0.6f), cart.v);
                cart.x = FALL_DOWN_CORRECTION;
                cart.y = -0.4;
                return true;
            }
            case 3: {
                if (!alr.e_((yc)world, (int)i, (int)j, (int)(k + 1))) break;
                cart.b(cart.t, (double)((float)j + 0.6f), cart.v);
                cart.x = FALL_DOWN_CORRECTION;
                cart.y = 0.4;
                return true;
            }
            case 4: {
                if (!alr.e_((yc)world, (int)(i - 1), (int)j, (int)k)) break;
                cart.b(cart.t, (double)((float)j + 0.6f), cart.v);
                cart.x = FALL_DOWN_CORRECTION;
                cart.w = -0.4;
                return true;
            }
            case 5: {
                if (!alr.e_((yc)world, (int)(i + 1), (int)j, (int)k)) break;
                cart.b(cart.t, (double)((float)j + 0.6f), cart.v);
                cart.x = FALL_DOWN_CORRECTION;
                cart.w = 0.4;
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    public boolean canBeReplacedByLeaves(yc world, int x, int y, int z) {
        return false;
    }
}

