/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraftforge.common.ForgeDirection;
import railcraft.common.api.tracks.ITrackInstance;
import railcraft.common.api.tracks.ITrackSwitch;
import railcraft.common.blocks.signals.TileSignalFoundation;
import railcraft.common.blocks.tracks.TileTrack;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;
import railcraft.common.util.sounds.SoundHelper;

public abstract class TileSwitchBase
extends TileSignalFoundation {
    private byte facing = (byte)ForgeDirection.NORTH.ordinal();
    private boolean powered;
    private ITrackSwitch switchTrack;
    private boolean lastSwitchState;

    @Override
    public void setBlockBoundsBasedOnState(ym world, int i, int j, int k) {
        this.getBlock().a(0.2f, 0.0f, 0.2f, 0.8f, 0.8f, 0.8f);
    }

    @Override
    public aoe getCollisionBoundingBoxFromPool(yc world, int i, int j, int k) {
        return aoe.a().a((double)((float)i + 0.2f), (double)j, (double)((float)k + 0.2f), (double)((float)i + 0.8f), (double)((float)j + 0.4f), (double)((float)k + 0.8f));
    }

    @Override
    public aoe getSelectedBoundingBoxFromPool(yc world, int i, int j, int k) {
        return aoe.a().a((double)((float)i + 0.2f), (double)j, (double)((float)k + 0.2f), (double)((float)i + 0.8f), (double)((float)j + 0.8f), (double)((float)k + 0.8f));
    }

    @Override
    public boolean blockActivated(int side, qx player) {
        this.powered = !this.powered;
        this.switchTrack(this.powered);
        return true;
    }

    @Override
    public void onBlockPlaced() {
        this.findTrack();
    }

    public ITrackSwitch getSwitchTrack() {
        if (this.switchTrack != null && this.switchTrack.getTile().r()) {
            this.switchTrack = null;
        }
        if (this.switchTrack == null) {
            this.findTrack();
        }
        return this.switchTrack;
    }

    private void findTrack() {
        for (byte side = 2; side < 6; side = (byte)(side + 1)) {
            any tile = MiscTools.getBlockTileEntityOnSide(this.k, this.l, this.m, this.n, ForgeDirection.getOrientation((int)side));
            if (tile instanceof TileTrack) {
                ITrackInstance track = ((TileTrack)tile).getTrackInstance();
                if (!(track instanceof ITrackSwitch)) continue;
                if (this.facing != side) {
                    this.facing = side;
                    this.markBlockForUpdate();
                }
                this.switchTrack = (ITrackSwitch)track;
                continue;
            }
            if (!(tile instanceof ITrackSwitch)) continue;
            if (this.facing != side) {
                this.facing = side;
                this.markBlockForUpdate();
            }
            this.switchTrack = (ITrackSwitch)tile;
        }
    }

    protected void switchTrack(boolean switched) {
        ITrackSwitch track = this.getSwitchTrack();
        if (track == null) {
            return;
        }
        track.setSwitched(switched);
    }

    public boolean canUpdate() {
        return true;
    }

    public void g() {
        ITrackSwitch track = this.getSwitchTrack();
        if (track == null) {
            return;
        }
        boolean isSwitched = track.isSwitched();
        if (this.lastSwitchState != isSwitched) {
            this.lastSwitchState = isSwitched;
            if (isSwitched) {
                SoundHelper.playSound(this.k, this.getX(), this.getY(), this.getZ(), "tile.piston.in", 0.25f, this.k.t.nextFloat() * 0.25f + 0.7f);
            } else {
                SoundHelper.playSound(this.k, this.getX(), this.getY(), this.getZ(), "tile.piston.out", 0.25f, this.k.t.nextFloat() * 0.25f + 0.7f);
            }
            if (Game.isNotHost(this.k)) {
                this.markBlockForUpdate();
            }
        }
    }

    @Override
    public void b(bq data) {
        super.b(data);
        data.a("Powered", this.isPowered());
        data.a("lastSwitchState", this.lastSwitchState);
        data.a("Facing", this.facing);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.powered = data.n("Powered");
        this.lastSwitchState = data.n("lastSwitchState");
        this.facing = data.c("Facing");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.facing);
        data.writeBoolean(this.powered);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.facing = data.readByte();
        this.powered = data.readBoolean();
    }

    public byte getFacing() {
        return this.facing;
    }

    public void setFacing(byte facing) {
        this.facing = facing;
    }

    public boolean isPowered() {
        return this.powered;
    }

    protected void setPowered(boolean p) {
        this.powered = p;
    }

    public boolean isSwitched() {
        ITrackSwitch track = this.getSwitchTrack();
        if (track == null) {
            return false;
        }
        return track.isSwitched();
    }
}

