/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import railcraft.common.api.signals.IControllerTile;
import railcraft.common.api.signals.SignalAspect;
import railcraft.common.api.signals.SimpleSignalController;
import railcraft.common.blocks.signals.EnumSignal;
import railcraft.common.blocks.signals.ISignalBlockTile;
import railcraft.common.blocks.signals.ISignalTile;
import railcraft.common.blocks.signals.SignalBlock;
import railcraft.common.blocks.signals.SignalBlockSimple;
import railcraft.common.blocks.signals.TileSignalBase;
import railcraft.common.util.misc.Game;

public class TileSignalBlockSignal
extends TileSignalBase
implements IControllerTile,
ISignalTile,
ISignalBlockTile {
    private boolean prevBlinkState;
    private final SimpleSignalController controller = new SimpleSignalController(this.b(), this);
    private final SignalBlock signalBlock = new SignalBlockSimple(this);

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.BLOCK_SIGNAL;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void g() {
        ++this.update;
        if (Game.isNotHost(this.k)) {
            this.controller.tickClient();
            this.signalBlock.tickClient();
            if (this.update % 4 == 0 && this.controller.getAspect().isBlinkAspect() && this.prevBlinkState != SignalAspect.isBlinkOn()) {
                this.prevBlinkState = SignalAspect.isBlinkOn();
                this.k.c(yo.b, this.getX(), this.getY(), this.getZ());
                this.markBlockForUpdate();
            }
            return;
        }
        this.controller.tickServer();
        this.signalBlock.tickServer();
        SignalAspect prevAspect = this.controller.getAspect();
        if (this.controller.isBeingPaired()) {
            this.controller.setAspect(SignalAspect.BLINK_YELLOW);
        } else {
            this.controller.setAspect(this.signalBlock.getSignalAspect());
        }
        if (prevAspect != this.controller.getAspect()) {
            this.sendUpdateToClient();
        }
    }

    @Override
    public SignalAspect getSignalAspect() {
        return this.controller.getAspect();
    }

    @Override
    public void b(bq data) {
        super.b(data);
        this.signalBlock.writeToNBT(data);
        this.controller.writeToNBT(data);
    }

    @Override
    public void a(bq data) {
        int z;
        int y;
        int x;
        super.a(data);
        this.signalBlock.readFromNBT(data);
        if (data.b("BlockPairX")) {
            x = data.e("BlockPairX");
            y = data.e("BlockPairY");
            z = data.e("BlockPairZ");
            this.signalBlock.registerLegacyBlock(x, y, z);
        }
        this.controller.readFromNBT(data);
        if (data.b("ReceiverX")) {
            x = data.e("ReceiverX");
            y = data.e("ReceiverY");
            z = data.e("ReceiverZ");
            this.controller.registerLegacyReceiver(x, y, z);
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.controller.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.controller.readPacketData(data);
    }

    @Override
    public SimpleSignalController getController() {
        return this.controller;
    }

    @Override
    public SignalBlock getSignalBlock() {
        return this.signalBlock;
    }
}

