/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraftforge.common.ForgeDirection;
import railcraft.common.api.signals.IControllerTile;
import railcraft.common.api.signals.SignalAspect;
import railcraft.common.api.signals.SimpleSignalController;
import railcraft.common.blocks.signals.EnumSignal;
import railcraft.common.blocks.signals.ItemSignalTuner;
import railcraft.common.blocks.signals.TileBoxBase;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;
import railcraft.common.util.network.IGuiReturnHandler;

public class TileBoxController
extends TileBoxBase
implements IControllerTile,
IGuiReturnHandler {
    private boolean powered;
    protected int update = MiscTools.getRand().nextInt();
    public SignalAspect defaultAspect = SignalAspect.GREEN;
    public SignalAspect poweredAspect = SignalAspect.RED;
    private boolean prevBlinkState;
    private final SimpleSignalController controller = new SimpleSignalController(this.b(), this);

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.BOX_CONTROLLER;
    }

    @Override
    public boolean blockActivated(int side, qx player) {
        if (player.ah()) {
            return false;
        }
        ur current = player.bS();
        if (current != null && current.b() instanceof ItemSignalTuner) {
            return super.blockActivated(side, player);
        }
        GuiHandler.openGui(EnumGui.BOX_CONTROLLER, player, this.k, this.l, this.m, this.n);
        return true;
    }

    public void g() {
        ++this.update;
        if (Game.isNotHost(this.k)) {
            this.controller.tickClient();
            if (this.controller.getAspect().isBlinkAspect() && this.prevBlinkState != SignalAspect.isBlinkOn()) {
                this.prevBlinkState = SignalAspect.isBlinkOn();
                this.markBlockForUpdate();
            }
            return;
        }
        this.controller.tickServer();
        SignalAspect prevAspect = this.controller.getAspect();
        if (this.controller.isBeingPaired()) {
            this.controller.setAspect(SignalAspect.BLINK_YELLOW);
        } else if (this.controller.isPaired()) {
            this.controller.setAspect(this.determineAspect());
        } else {
            this.controller.setAspect(SignalAspect.BLINK_RED);
        }
        if (prevAspect != this.controller.getAspect()) {
            this.sendUpdateToClient();
        }
    }

    @Override
    public void onNeighborBlockChange(int blockId) {
        boolean p;
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        boolean bl = p = this.k.A(this.l, this.m, this.n) || this.k.A(this.l, this.m - 1, this.n) || this.k.B(this.l, this.m, this.n) || amq.ay.cm == blockId && this.isRedstonePowered();
        if (p != this.powered) {
            this.powered = p;
            this.sendUpdateToClient();
        }
    }

    private SignalAspect determineAspect() {
        SignalAspect newAspect = this.powered ? this.poweredAspect : this.defaultAspect;
        for (int side = 2; side < 6; ++side) {
            TileBoxBase tile;
            any t = MiscTools.getBlockTileEntityOnSide(this.k, this.l, this.m, this.n, ForgeDirection.getOrientation((int)side));
            if (!(t instanceof TileBoxBase) || !(tile = (TileBoxBase)t).canTransferAspect()) continue;
            newAspect = SignalAspect.mostRestrictive(newAspect, tile.getBoxSignalAspect());
        }
        return newAspect;
    }

    @Override
    public void b(bq data) {
        super.b(data);
        data.a("Powered", this.powered);
        data.a("defaultAspect", this.defaultAspect.ordinal());
        data.a("PoweredAspect", this.poweredAspect.ordinal());
        this.controller.writeToNBT(data);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.powered = data.n("Powered");
        this.defaultAspect = SignalAspect.values()[data.e("defaultAspect")];
        this.poweredAspect = SignalAspect.values()[data.e("PoweredAspect")];
        this.controller.readFromNBT(data);
        if (data.b("ReceiverX")) {
            int x = data.e("ReceiverX");
            int y = data.e("ReceiverY");
            int z = data.e("ReceiverZ");
            this.controller.registerLegacyReceiver(x, y, z);
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.defaultAspect.ordinal());
        data.writeByte(this.poweredAspect.ordinal());
        this.controller.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.defaultAspect = SignalAspect.values()[data.readByte()];
        this.poweredAspect = SignalAspect.values()[data.readByte()];
        this.controller.readPacketData(data);
        this.markBlockForUpdate();
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte(this.defaultAspect.ordinal());
        data.writeByte(this.poweredAspect.ordinal());
    }

    @Override
    public void readGuiData(DataInputStream data) throws IOException {
        this.defaultAspect = SignalAspect.values()[data.readByte()];
        this.poweredAspect = SignalAspect.values()[data.readByte()];
    }

    @Override
    public boolean connectToBoxAt(int i, int j, int k, int side) {
        any tile = this.k.q(i, j, k);
        if (tile instanceof TileBoxBase) {
            return ((TileBoxBase)tile).canTransferAspect();
        }
        return false;
    }

    @Override
    public SignalAspect getBoxSignalAspect() {
        return this.controller.getAspect();
    }

    @Override
    public boolean canReceiveAspect() {
        return true;
    }

    @Override
    public SimpleSignalController getController() {
        return this.controller;
    }
}

