/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraftforge.common.ForgeDirection;
import railcraft.common.api.signals.IControllerTile;
import railcraft.common.api.signals.SignalAspect;
import railcraft.common.api.signals.SimpleSignalController;
import railcraft.common.blocks.signals.EnumSignal;
import railcraft.common.blocks.signals.IAspectActionManager;
import railcraft.common.blocks.signals.ISignalBlockTile;
import railcraft.common.blocks.signals.ItemSignalBlockSurveyor;
import railcraft.common.blocks.signals.ItemSignalTuner;
import railcraft.common.blocks.signals.SignalBlock;
import railcraft.common.blocks.signals.SignalBlockRelay;
import railcraft.common.blocks.signals.TileBoxBase;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;
import railcraft.common.util.network.IGuiReturnHandler;

public class TileBoxBlockRelay
extends TileBoxBase
implements IControllerTile,
ISignalBlockTile,
IAspectActionManager,
IGuiReturnHandler {
    private boolean prevBlinkState;
    private boolean[] powerOnAspects = new boolean[SignalAspect.values().length];
    private final SimpleSignalController controller = new SimpleSignalController(this.b(), this);
    private final SignalBlock signalBlock = new SignalBlockRelay(this);
    private int update = MiscTools.getRand().nextInt();

    public TileBoxBlockRelay() {
        this.powerOnAspects[SignalAspect.GREEN.ordinal()] = true;
    }

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.BOX_BLOCK_RELAY;
    }

    @Override
    public boolean blockActivated(int side, qx player) {
        if (player.ah()) {
            return false;
        }
        ur current = player.bS();
        if (current != null && (current.b() instanceof ItemSignalTuner || current.b() instanceof ItemSignalBlockSurveyor)) {
            return super.blockActivated(side, player);
        }
        GuiHandler.openGui(EnumGui.BOX_RELAY, player, this.k, this.l, this.m, this.n);
        return true;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void g() {
        ++this.update;
        if (Game.isNotHost(this.k)) {
            this.controller.tickClient();
            this.signalBlock.tickClient();
            if (this.update % 4 == 0 && this.controller.getAspect().isBlinkAspect() && this.prevBlinkState != SignalAspect.isBlinkOn()) {
                this.prevBlinkState = SignalAspect.isBlinkOn();
                this.k.c(yo.b, this.getX(), this.getY(), this.getZ());
                this.markBlockForUpdate();
            }
            return;
        }
        this.controller.tickServer();
        this.signalBlock.tickServer();
        SignalAspect prevAspect = this.controller.getAspect();
        if (this.controller.isBeingPaired()) {
            this.controller.setAspect(SignalAspect.BLINK_YELLOW);
        } else {
            this.controller.setAspect(this.signalBlock.getSignalAspect());
        }
        if (prevAspect != this.controller.getAspect()) {
            this.updateNeighbors();
            this.sendUpdateToClient();
        }
    }

    private void updateNeighbors() {
        int blockID = this.getBlockId();
        this.k.h(this.l, this.m, this.n, blockID);
        for (int side = 2; side < 6; ++side) {
            ForgeDirection forgeSide = ForgeDirection.getOrientation((int)side);
            any tile = MiscTools.getBlockTileEntityOnSide(this.k, this.l, this.m, this.n, forgeSide);
            if (!(tile instanceof TileBoxBase)) continue;
            TileBoxBase box = (TileBoxBase)tile;
            box.onNeighborStateChange(this);
        }
    }

    @Override
    public boolean isPoweringTo(ym world, int i, int j, int k, int side) {
        any tile = MiscTools.getBlockTileEntityOnSide(this.k, i, j, k, MiscTools.getOppositeSide(side));
        if (tile instanceof TileBoxBase) {
            return false;
        }
        return this.powerOnAspects[this.getBoxSignalAspect().ordinal()];
    }

    @Override
    public boolean isEmitingRedstone() {
        return this.powerOnAspects[this.getBoxSignalAspect().ordinal()];
    }

    @Override
    public void b(bq data) {
        super.b(data);
        this.signalBlock.writeToNBT(data);
        this.controller.writeToNBT(data);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.signalBlock.readFromNBT(data);
        this.controller.readFromNBT(data);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.controller.writePacketData(data);
        this.writeGuiData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.controller.readPacketData(data);
        this.readGuiData(data);
        this.markBlockForUpdate();
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        int bits = 0;
        for (int i = 0; i < this.powerOnAspects.length; ++i) {
            bits = (byte)(bits | (this.powerOnAspects[i] ? 1 : 0) << i);
        }
        data.writeByte(bits);
    }

    @Override
    public void readGuiData(DataInputStream data) throws IOException {
        byte bits = data.readByte();
        for (int bit = 0; bit < this.powerOnAspects.length; ++bit) {
            this.powerOnAspects[bit] = (bits >> bit & 1) == 1;
        }
        this.updateNeighbors();
    }

    @Override
    public SimpleSignalController getController() {
        return this.controller;
    }

    @Override
    public SignalBlock getSignalBlock() {
        return this.signalBlock;
    }

    @Override
    public boolean doesActionOnAspect(SignalAspect aspect) {
        return this.powerOnAspects[aspect.ordinal()];
    }

    @Override
    public void doActionOnAspect(SignalAspect aspect, boolean trigger) {
        this.powerOnAspects[aspect.ordinal()] = trigger;
        this.updateNeighbors();
    }

    @Override
    public boolean connectToBoxAt(int i, int j, int k, int side) {
        any tile = this.k.q(i, j, k);
        if (tile instanceof TileBoxBase) {
            return ((TileBoxBase)tile).canReceiveAspect();
        }
        return false;
    }

    @Override
    public SignalAspect getBoxSignalAspect() {
        return this.controller.getAspect();
    }

    @Override
    public boolean canTransferAspect() {
        return true;
    }
}

