/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.signals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import railcraft.common.blocks.RailcraftBlocks;
import railcraft.common.blocks.signals.TileBoxBlockRelay;
import railcraft.common.blocks.signals.TileBoxCapacitor;
import railcraft.common.blocks.signals.TileBoxController;
import railcraft.common.blocks.signals.TileBoxReceiver;
import railcraft.common.blocks.signals.TileSignalBlockSignal;
import railcraft.common.blocks.signals.TileSignalDistantSignal;
import railcraft.common.blocks.signals.TileSignalDualHeadBlockSignal;
import railcraft.common.blocks.signals.TileSignalDualHeadDistantSignal;
import railcraft.common.blocks.signals.TileSignalFoundation;
import railcraft.common.blocks.signals.TileStructureMetalPost;
import railcraft.common.blocks.signals.TileStructureStonePost;
import railcraft.common.blocks.signals.TileStructureWoodPost;
import railcraft.common.blocks.signals.TileSwitchLever;
import railcraft.common.blocks.signals.TileSwitchMotor;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.modules.ModuleManager;

public enum EnumSignal {
    METAL_POST(null, 169, 240, 3.0f, false, true, "post.metal", TileStructureMetalPost.class),
    DUAL_HEAD_BLOCK_SIGNAL(ModuleManager.Module.SIGNALS, 56, 56, 8.0f, false, false, "block.signal.dual", TileSignalDualHeadBlockSignal.class),
    SWITCH_MOTOR(ModuleManager.Module.SIGNALS, 42, 42, 8.0f, true, false, "switch.motor", TileSwitchMotor.class),
    BLOCK_SIGNAL(ModuleManager.Module.SIGNALS, 55, 55, 8.0f, false, false, "block.signal", TileSignalBlockSignal.class),
    SWITCH_LEVER(ModuleManager.Module.SIGNALS, 42, 42, 8.0f, true, false, "switch.lever", TileSwitchLever.class),
    WOOD_POST(null, 87, 87, 3.0f, false, true, "post.wood", TileStructureWoodPost.class),
    STONE_POST(null, 103, 103, 3.0f, false, true, "post.stone", TileStructureStonePost.class),
    BOX_CAPACITOR(ModuleManager.Module.SIGNALS, 88, 101, 3.0f, true, false, "box.capacitor", TileBoxCapacitor.class),
    BOX_RECEIVER(ModuleManager.Module.SIGNALS, 88, 120, 3.0f, true, false, "box.receiver", TileBoxReceiver.class),
    BOX_CONTROLLER(ModuleManager.Module.SIGNALS, 88, 119, 3.0f, true, false, "box.controller", TileBoxController.class),
    DISTANT_SIGNAL(ModuleManager.Module.SIGNALS, 55, 55, 8.0f, false, false, "distant", TileSignalDistantSignal.class),
    DUAL_HEAD_DISTANT_SIGNAL(ModuleManager.Module.SIGNALS, 56, 56, 8.0f, false, false, "distant.dual", TileSignalDualHeadDistantSignal.class),
    BOX_BLOCK_RELAY(ModuleManager.Module.SIGNALS, 88, 117, 3.0f, true, false, "box.block.relay", TileBoxBlockRelay.class);

    private final ModuleManager.Module module;
    private final int primaryTexture;
    private final int secondaryTexture;
    private final float hardness;
    private final boolean needsSupport;
    private final boolean isPost;
    private final String tag;
    private int altTextureOffset = 0;
    private final Class tile;
    private boolean useAltTexture;
    private int[] textures = new int[6];
    private static Map structures;
    private static final List creativeList;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private EnumSignal(int module3, float primaryTexture, boolean secondaryTexture, boolean hardness, String needsSupport, Class isPost) {
        void tag;
        void tile;
        this.module = (ModuleManager.Module)module3;
        this.primaryTexture = (int)primaryTexture;
        this.secondaryTexture = secondaryTexture ? 1 : 0;
        this.hardness = (float)hardness;
        this.needsSupport = needsSupport;
        this.isPost = isPost;
        this.tile = tile;
        this.tag = tag;
        this.setUseAltTextures(false);
    }

    public ur getItem() {
        return this.getItem(1);
    }

    public ur getItem(int qty) {
        return new ur(RailcraftBlocks.getBlockSignal().cm, qty, this.ordinal());
    }

    public String getTag() {
        return "rc.signal." + this.tag;
    }

    public ModuleManager.Module getModule() {
        return this.module;
    }

    public Class getTileClass() {
        return this.tile;
    }

    public TileSignalFoundation getBlockEntity() {
        if (this.tile == null) {
            return null;
        }
        try {
            return (TileSignalFoundation)this.tile.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public float getHardness() {
        return this.hardness;
    }

    public int getBlockTexture() {
        if (this.useAltTexture) {
            return this.textures[0] + this.altTextureOffset;
        }
        return this.primaryTexture;
    }

    public int getBlockTextureFromSide(int side) {
        if (this.useAltTexture) {
            return this.textures[side] + this.altTextureOffset;
        }
        return this.textures[side];
    }

    public int getOffsetTexture(int offset) {
        return this.primaryTexture + offset;
    }

    public int getPrimaryTexture() {
        return this.primaryTexture;
    }

    public int getSecondaryTexture() {
        return this.secondaryTexture;
    }

    public static EnumSignal fromId(int id) {
        EnumSignal s = (EnumSignal)((Object)structures.get(id));
        if (s != null) {
            return s;
        }
        for (EnumSignal t : EnumSignal.values()) {
            if (t.ordinal() != id) continue;
            structures.put(id, t);
            return t;
        }
        return SWITCH_LEVER;
    }

    public static List getCreativeList() {
        return creativeList;
    }

    public boolean useAltTexture() {
        return this.useAltTexture;
    }

    public void setUseAltTextures(boolean use) {
        for (int i = 0; i < this.textures.length; ++i) {
            this.textures[i] = this.primaryTexture;
        }
        this.altTextureOffset = 0;
        this.useAltTexture = use;
    }

    public void setUseAltTextureOnSide(int side, int texture) {
        this.textures[side] = texture;
    }

    public void setUseOffsetTextureOnSide(int side, int offset) {
        this.textures[side] = this.primaryTexture + offset;
    }

    public void setAltTextureIndex(int index) {
        for (int i = 0; i < this.textures.length; ++i) {
            this.textures[i] = index;
        }
    }

    public void setAltTextureOffset(int altTextureOffset) {
        this.altTextureOffset = altTextureOffset;
    }

    public boolean isPost() {
        return this.isPost;
    }

    public boolean needsSupport() {
        return this.needsSupport;
    }

    public boolean isEnabled() {
        if (this.module == null) {
            return false;
        }
        return ModuleManager.isModuleLoaded(this.getModule()) && RailcraftBlocks.getBlockSignal() != null && RailcraftConfig.isSubBlockEnabled(this.getTag());
    }

    static {
        structures = new HashMap();
        creativeList = new ArrayList();
        creativeList.add(SWITCH_LEVER);
        creativeList.add(SWITCH_MOTOR);
        creativeList.add(BLOCK_SIGNAL);
        creativeList.add(DISTANT_SIGNAL);
        creativeList.add(DUAL_HEAD_BLOCK_SIGNAL);
        creativeList.add(DUAL_HEAD_DISTANT_SIGNAL);
        creativeList.add(BOX_BLOCK_RELAY);
        creativeList.add(BOX_CONTROLLER);
        creativeList.add(BOX_RECEIVER);
        creativeList.add(BOX_CAPACITOR);
    }
}

