/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.ore;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import railcraft.common.blocks.ore.EnumOre;
import railcraft.common.blocks.ore.ItemOre;
import railcraft.common.core.Railcraft;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.items.RailcraftPartItems;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.plugins.forestry.ForestryPlugin;
import railcraft.common.util.misc.MiscTools;

public class BlockOre
extends amq {
    public static int renderPass;
    private final int renderType;
    private final Random rand = new Random();
    private static BlockOre instance;

    public static BlockOre getBlock() {
        return instance;
    }

    public static void registerBlock() {
        int id;
        if (instance == null && (id = RailcraftConfig.getBlockId("block.ore")) > 0) {
            int renderId = Railcraft.getProxy().getRenderId();
            instance = new BlockOre(id, renderId);
            GameRegistry.registerBlock((amq)instance, ItemOre.class, (String)instance.a());
            for (EnumOre ore : EnumOre.values()) {
                RailcraftLanguage.getInstance().registerItemName(ore.getItem(), ore.getTag());
                ForestryPlugin.addBackpackItem("miner", ore.getItem());
            }
            OreDictionary.registerOre((String)"oreSulfur", (ur)EnumOre.SULFUR.getItem());
            OreDictionary.registerOre((String)"oreSaltpeter", (ur)EnumOre.SALTPETER.getItem());
        }
    }

    public BlockOre(int id, int renderId) {
        super(id, agi.e);
        this.renderType = renderId;
        this.b("rcOres");
        this.b(5.0f);
        this.c(3.0f);
        this.setTextureFile("/railcraft/client/textures/railcraft.png");
        this.a(amq.h);
        this.a(tj.b);
        MinecraftForge.setBlockHarvestLevel((amq)this, (String)"pickaxe", (int)2);
    }

    public int d() {
        return this.renderType;
    }

    public void a(int id, tj tab, List list) {
        for (EnumOre ore : EnumOre.values()) {
            list.add(ore.getItem());
        }
    }

    public ur getPickBlock(aoh target, yc world, int x, int y, int z) {
        int meta = world.h(x, y, z);
        return EnumOre.fromMeta(meta).getItem();
    }

    public void a(yc world, int x, int y, int z, int par5, float par6, int par7) {
        super.a(world, x, y, z, par5, par6, par7);
        int xp = ke.a((Random)world.t, (int)2, (int)5);
        this.f(world, x, y, z, xp);
    }

    public ArrayList getBlockDropped(yc world, int x, int y, int z, int meta, int fortune) {
        switch (EnumOre.fromMeta(meta)) {
            case SULFUR: {
                ArrayList<ur> list = new ArrayList<ur>();
                int qty = 2 + this.rand.nextInt(4) + this.rand.nextInt(fortune + 1);
                list.add(RailcraftPartItems.getDustSulfur(qty));
                return list;
            }
            case SALTPETER: {
                ArrayList<ur> list = new ArrayList<ur>();
                int qty = 1 + this.rand.nextInt(2) + this.rand.nextInt(fortune + 1);
                list.add(RailcraftPartItems.getDustSaltpeter(qty));
                return list;
            }
        }
        return super.getBlockDropped(world, x, y, z, meta, fortune);
    }

    public int a(int side, int meta) {
        if (renderPass == 0) {
            if (meta == EnumOre.SALTPETER.ordinal()) {
                return amq.T.a(ForgeDirection.DOWN.ordinal(), 0);
            }
            return amq.w.a(side, 0);
        }
        return EnumOre.fromMeta(meta).getTexture(side);
    }

    public void f() {
        this.a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockHitEffects(yc worldObj, aoh target, azr effectRenderer) {
        int x = target.b;
        int y = target.c;
        int z = target.d;
        int sideHit = target.e;
        int meta = worldObj.h(x, y, z);
        BlockOre block = instance;
        float b = 0.1f;
        double px2 = (double)x + this.rand.nextDouble() * (block.w() - block.v() - (double)(b * 2.0f)) + (double)b + block.v();
        double py2 = (double)y + this.rand.nextDouble() * (block.y() - block.x() - (double)(b * 2.0f)) + (double)b + block.x();
        double pz = (double)z + this.rand.nextDouble() * (block.A() - block.z() - (double)(b * 2.0f)) + (double)b + block.z();
        if (sideHit == 0) {
            py2 = (double)y + block.x() - (double)b;
        }
        if (sideHit == 1) {
            py2 = (double)y + block.y() + (double)b;
        }
        if (sideHit == 2) {
            pz = (double)z + block.z() - (double)b;
        }
        if (sideHit == 3) {
            pz = (double)z + block.A() + (double)b;
        }
        if (sideHit == 4) {
            px2 = (double)x + block.v() - (double)b;
        }
        if (sideHit == 5) {
            px2 = (double)x + block.w() + (double)b;
        }
        renderPass = 0;
        bac fx = new bac(worldObj, px2, py2, pz, 0.0, 0.0, 0.0, (amq)block, sideHit, worldObj.h(x, y, z));
        effectRenderer.a(fx.a(x, y, z).e(0.2f).f(0.6f));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockDestroyEffects(yc world, int x, int y, int z, int meta, azr effectRenderer) {
        int its = 4;
        for (int i = 0; i < its; ++i) {
            for (int j = 0; j < its; ++j) {
                for (int k = 0; k < its; ++k) {
                    double px2 = (double)x + ((double)i + 0.5) / (double)its;
                    double py2 = (double)y + ((double)j + 0.5) / (double)its;
                    double pz = (double)z + ((double)k + 0.5) / (double)its;
                    int random = MiscTools.getRand().nextInt(6);
                    renderPass = 0;
                    bac fx = new bac(world, px2, py2, pz, px2 - (double)x - 0.5, py2 - (double)y - 0.5, pz - (double)z - 0.5, (amq)instance, random, meta);
                    effectRenderer.a((azq)fx.a(x, y, z));
                }
            }
        }
        return true;
    }
}

