/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.gamma;

import buildcraft.api.tools.IToolWrench;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraftforge.common.ForgeDirection;
import railcraft.common.blocks.machine.IEnumMachine;
import railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import railcraft.common.blocks.machine.gamma.TileItemLoader;
import railcraft.common.util.misc.MiscTools;

public class TileItemLoaderAdvanced
extends TileItemLoader {
    private ForgeDirection direction = ForgeDirection.NORTH;

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineGamma.ITEM_LOADER_ADVANCED;
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("direction", (byte)this.direction.ordinal());
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.direction = ForgeDirection.getOrientation((int)data.c("direction"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.direction.ordinal());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.direction = ForgeDirection.getOrientation((int)data.readByte());
        this.markBlockForUpdate();
    }

    @Override
    public int getBlockTexture(int side) {
        if (this.direction.ordinal() == side) {
            return this.getMachineType().getTexture(3);
        }
        if (side != 0 && side != 1) {
            return this.getMachineType().getTexture(2);
        }
        return this.getMachineType().getTexture(1);
    }

    @Override
    public void onBlockPlacedBy(md entityliving) {
        super.onBlockPlacedBy(entityliving);
        this.direction = MiscTools.getSideClosestToPlayer(this.k, this.l, this.m, this.n, entityliving);
    }

    @Override
    public boolean blockActivated(qx player, int side) {
        IToolWrench wrench;
        ur current = player.bS();
        if (current != null && current.b() instanceof IToolWrench && (wrench = (IToolWrench)current.b()).canWrench(player, this.l, this.m, this.n)) {
            this.direction = this.direction.ordinal() == side ? MiscTools.getOppositeSide(side) : ForgeDirection.getOrientation((int)side);
            wrench.wrenchUsed(player, this.l, this.m, this.n);
            this.markBlockForUpdate();
            return true;
        }
        return super.blockActivated(player, side);
    }

    @Override
    public boolean wrenchCanSetFacing(qx player, int side) {
        return this.direction.ordinal() != side;
    }

    @Override
    public void setFacing(short facing) {
        this.direction = ForgeDirection.getOrientation((int)facing);
        this.sendUpdateToClient();
    }

    @Override
    public short getFacing() {
        return (short)this.direction.ordinal();
    }

    @Override
    public ForgeDirection getOrientation() {
        return this.direction;
    }
}

