/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.gamma;

import ic2.api.Direction;
import ic2.api.energy.tile.IEnergySource;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import railcraft.common.api.carts.CartTools;
import railcraft.common.api.carts.IEnergyTransfer;
import railcraft.common.blocks.machine.IEnumMachine;
import railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import railcraft.common.blocks.machine.gamma.TileLoaderEnergyBase;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.plugins.ic2.IC2Plugin;
import railcraft.common.util.misc.Game;
import railcraft.common.util.network.IGuiReturnHandler;

public class TileEnergyUnloader
extends TileLoaderEnergyBase
implements IEnergySource,
IGuiReturnHandler {
    private static final int[] OUTPUT_LEVELS = new int[]{512, 2048};
    private boolean transferedEnergy;
    private boolean waitTillEmpty = true;

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineGamma.ENERGY_UNLOADER;
    }

    @Override
    public int getBlockTexture(int side) {
        if (this.getFacing() == side) {
            return this.getMachineType().getTexture(3);
        }
        if (side != 0 && side != 1) {
            return this.getMachineType().getTexture(2);
        }
        return this.getMachineType().getTexture(1);
    }

    @Override
    public boolean openGui(qx player) {
        GuiHandler.openGui(EnumGui.UNLOADER_ENERGY, player, this.k, this.l, this.m, this.n);
        return true;
    }

    @Override
    public void g() {
        int emit;
        super.g();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        int n = emit = this.transformerUpgrades > 0 ? OUTPUT_LEVELS[1] : OUTPUT_LEVELS[0];
        if (this.energy > emit) {
            int extra = IC2Plugin.emitEnergy(this, emit);
            this.energy -= emit - extra;
        }
        this.transferedEnergy = false;
        this.transferRate = 0;
        py cart = CartTools.getMinecartOnSide(this.k, this.l, this.m, this.n, 0.1f, this.direction);
        if (cart != this.currentCart) {
            this.setPowered(false);
            this.currentCart = cart;
            this.cartSent();
        }
        if (cart == null) {
            return;
        }
        if (!(cart instanceof IEnergyTransfer)) {
            if (CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
                this.setPowered(true);
            }
            return;
        }
        if (this.isSendCart()) {
            if (CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
                this.setPowered(true);
            }
            return;
        }
        IEnergyTransfer energyCart = (IEnergyTransfer)cart;
        if (!energyCart.canExtractEnergy() || energyCart.getTier() > this.getTier()) {
            if (CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
                this.setPowered(true);
            }
            return;
        }
        if (this.energy < this.getCapacity() && energyCart.getEnergy() > 0) {
            int extract;
            int usage = (int)((double)energyCart.getTransferLimit() * Math.pow(1.5, this.overclockerUpgrades));
            int injection = (int)((double)energyCart.getTransferLimit() * Math.pow(1.3, this.overclockerUpgrades));
            int room = this.getCapacity() - this.getEnergy();
            if (room < injection) {
                double ratio = (double)room / (double)injection;
                injection = room;
                usage = (int)((double)usage * ratio);
            }
            if ((extract = energyCart.extractEnergy(this, usage, this.getTier(), true, false, false)) < usage) {
                double ratio = (double)extract / (double)usage;
                usage = extract;
                injection = (int)((double)injection * ratio);
            }
            this.transferRate = injection;
            this.energy += injection;
            boolean bl = this.transferedEnergy = extract > 0;
        }
        if (!this.transferedEnergy && !this.isPowered() && CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
            if (!this.waitTillEmpty) {
                this.setPowered(true);
            } else if (energyCart.getEnergy() == 0) {
                this.setPowered(true);
            }
        }
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("WaitTillEmpty", this.waitTillEmpty());
    }

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this.setWaitTillEmpty(nbttagcompound.n("WaitTillEmpty"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.waitTillEmpty);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.waitTillEmpty = data.readBoolean();
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeBoolean(this.waitTillEmpty);
    }

    @Override
    public void readGuiData(DataInputStream data) throws IOException {
        this.waitTillEmpty = data.readBoolean();
    }

    public boolean waitTillEmpty() {
        return this.waitTillEmpty;
    }

    public void setWaitTillEmpty(boolean wait) {
        this.waitTillEmpty = wait;
    }

    @Override
    public int getMaxEnergyOutput() {
        return OUTPUT_LEVELS[1];
    }

    @Override
    public boolean emitsEnergyTo(any receiver, Direction direction) {
        return this.getFacing() != direction.toSideValue();
    }
}

