/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.gamma;

import java.util.ArrayList;
import java.util.List;
import railcraft.common.blocks.RailcraftBlocks;
import railcraft.common.blocks.machine.IEnumMachine;
import railcraft.common.blocks.machine.TileMachineBase;
import railcraft.common.blocks.machine.gamma.TileDispenserCart;
import railcraft.common.blocks.machine.gamma.TileDispenserTrain;
import railcraft.common.blocks.machine.gamma.TileEnergyLoader;
import railcraft.common.blocks.machine.gamma.TileEnergyUnloader;
import railcraft.common.blocks.machine.gamma.TileItemLoader;
import railcraft.common.blocks.machine.gamma.TileItemLoaderAdvanced;
import railcraft.common.blocks.machine.gamma.TileItemUnloader;
import railcraft.common.blocks.machine.gamma.TileItemUnloaderAdvanced;
import railcraft.common.blocks.machine.gamma.TileLiquidLoader;
import railcraft.common.blocks.machine.gamma.TileLiquidUnloader;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.modules.ModuleManager;

public enum EnumMachineGamma implements IEnumMachine
{
    ITEM_LOADER(ModuleManager.Module.TRANSPORT, "loader.item", TileItemLoader.class, new int[]{12, 10, 11, 11, 11, 11}),
    ITEM_UNLOADER(ModuleManager.Module.TRANSPORT, "unloader.item", TileItemUnloader.class, new int[]{154, 156, 155, 155, 155, 155}),
    ITEM_LOADER_ADVANCED(ModuleManager.Module.TRANSPORT, "loader.item.advanced", TileItemLoaderAdvanced.class, new int[]{122, 122, 123, 124, 123, 123}),
    ITEM_UNLOADER_ADVANCED(ModuleManager.Module.TRANSPORT, "unloader.item.advanced", TileItemUnloaderAdvanced.class, new int[]{138, 138, 139, 140, 139, 139}),
    LIQUID_LOADER(ModuleManager.Module.TRANSPORT, "loader.liquid", TileLiquidLoader.class, new int[]{28, 26, 27, 27, 27, 27}),
    LIQUID_UNLOADER(ModuleManager.Module.TRANSPORT, "unloader.liquid", TileLiquidUnloader.class, new int[]{26, 28, 27, 27, 27, 27}),
    ENERGY_LOADER(ModuleManager.Module.IC2, "loader.energy", TileEnergyLoader.class, new int[]{202, 202, 203, 204, 203, 203}),
    ENERGY_UNLOADER(ModuleManager.Module.IC2, "unloader.energy", TileEnergyUnloader.class, new int[]{218, 218, 219, 220, 219, 219}),
    DISPENSER_CART(ModuleManager.Module.AUTOMATION, "dispenser.cart", TileDispenserCart.class, new int[]{106, 106, 107, 108, 107, 107}),
    DISPENSER_TRAIN(ModuleManager.Module.TRAIN, "dispenser.train", TileDispenserTrain.class, new int[]{231, 231, 232, 233, 232, 232});

    private final ModuleManager.Module module;
    private final String tag;
    private final Class tile;
    private final int[] texture;
    private static final List creativeList;
    private static final EnumMachineGamma[] VALUES;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private EnumMachineGamma(Class module3, int[] tag) {
        void texture;
        void tile;
        this.module = module3;
        this.tile = tile;
        this.tag = tag;
        this.texture = texture;
    }

    @Override
    public boolean isDepreciated() {
        return this.module == null;
    }

    @Override
    public int getTexture(int index) {
        if (index < 0 || index >= this.texture.length) {
            index = 0;
        }
        return this.texture[index];
    }

    public static EnumMachineGamma fromId(int id) {
        if (id < 0 || id >= VALUES.length) {
            id = 0;
        }
        return VALUES[id];
    }

    public static List getCreativeList() {
        return creativeList;
    }

    @Override
    public String getTag() {
        return "rc.machine.gamma." + this.tag;
    }

    @Override
    public Class getTileClass() {
        return this.tile;
    }

    public TileMachineBase getTileEntity() {
        try {
            return (TileMachineBase)this.tile.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public ur getItem() {
        return this.getItem(1);
    }

    @Override
    public ur getItem(int qty) {
        amq block = this.getBlock();
        if (block == null) {
            return null;
        }
        return new ur(block, qty, this.ordinal());
    }

    public ModuleManager.Module getModule() {
        return this.module;
    }

    @Override
    public amq getBlock() {
        return RailcraftBlocks.getBlockMachineGamma();
    }

    @Override
    public int getBlockId() {
        amq block = this.getBlock();
        if (block != null) {
            return block.cm;
        }
        return 0;
    }

    @Override
    public boolean isEnabled() {
        return ModuleManager.isModuleLoaded(this.getModule()) && this.getBlock() != null && RailcraftConfig.isSubBlockEnabled(this.getTag());
    }

    static {
        creativeList = new ArrayList();
        VALUES = EnumMachineGamma.values();
        creativeList.add(ITEM_LOADER);
        creativeList.add(ITEM_UNLOADER);
        creativeList.add(ITEM_LOADER_ADVANCED);
        creativeList.add(ITEM_UNLOADER_ADVANCED);
        creativeList.add(LIQUID_LOADER);
        creativeList.add(LIQUID_UNLOADER);
        creativeList.add(ENERGY_LOADER);
        creativeList.add(ENERGY_UNLOADER);
        creativeList.add(DISPENSER_CART);
        creativeList.add(DISPENSER_TRAIN);
    }
}

