/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.beta;

import java.util.ArrayList;
import java.util.List;
import railcraft.common.blocks.RailcraftBlocks;
import railcraft.common.blocks.machine.IEnumMachine;
import railcraft.common.blocks.machine.TileMachineBase;
import railcraft.common.blocks.machine.beta.TileBoilerFireboxLiquid;
import railcraft.common.blocks.machine.beta.TileBoilerFireboxSolid;
import railcraft.common.blocks.machine.beta.TileBoilerTankHigh;
import railcraft.common.blocks.machine.beta.TileBoilerTankLow;
import railcraft.common.blocks.machine.beta.TileEngineSteamHigh;
import railcraft.common.blocks.machine.beta.TileEngineSteamHobby;
import railcraft.common.blocks.machine.beta.TileEngineSteamLow;
import railcraft.common.blocks.machine.beta.TileSentinel;
import railcraft.common.blocks.machine.beta.TileTankIronGauge;
import railcraft.common.blocks.machine.beta.TileTankIronValve;
import railcraft.common.blocks.machine.beta.TileTankIronWall;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.modules.ModuleManager;

public enum EnumMachineBeta implements IEnumMachine
{
    TANK_IRON_WALL(ModuleManager.Module.TRANSPORT, "tank.iron.wall", TileTankIronWall.class, new int[]{19, 19, 20, 20, 20, 20}),
    TANK_IRON_GAUGE(ModuleManager.Module.TRANSPORT, "tank.iron.gauge", TileTankIronGauge.class, new int[]{36, 36, 36, 36, 36, 36, 52, 53, 37, 21}),
    TANK_IRON_VALVE(ModuleManager.Module.TRANSPORT, "tank.iron.valve", TileTankIronValve.class, new int[]{35, 35, 51, 51, 51, 51, 19, 20}),
    BOILER_TANK_LOW_PRESSURE(ModuleManager.Module.ENERGY, "boiler.tank.pressure.low", TileBoilerTankLow.class, new int[]{97, 97, 98, 98, 98, 98}),
    BOILER_TANK_HIGH_PRESSURE(ModuleManager.Module.ENERGY, "boiler.tank.pressure.high", TileBoilerTankHigh.class, new int[]{113, 113, 114, 114, 114, 114}),
    BOILER_FIREBOX_SOLID(ModuleManager.Module.ENERGY, "boiler.firebox.solid", TileBoilerFireboxSolid.class, new int[]{99, 99, 100, 100, 100, 100}),
    BOILER_FIREBOX_LIQUID(ModuleManager.Module.ENERGY, "boiler.firebox.liquid", TileBoilerFireboxLiquid.class, new int[]{115, 115, 116, 116, 116, 116}),
    ENGINE_STEAM_HOBBY(ModuleManager.Module.ENERGY, "engine.steam.hobby", TileEngineSteamHobby.class, new int[]{83}),
    ENGINE_STEAM_LOW(ModuleManager.Module.ENERGY, "engine.steam.low", TileEngineSteamLow.class, new int[]{84}),
    ENGINE_STEAM_HIGH(ModuleManager.Module.ENERGY, "engine.steam.high", TileEngineSteamHigh.class, new int[]{85}),
    SENTINEL(ModuleManager.Module.CHUNK_LOADING, "anchor.sentinel", TileSentinel.class, new int[]{200, 200, 184, 184, 184, 184});

    private final ModuleManager.Module module;
    private final String tag;
    private final Class tile;
    private final int[] texture;
    private static final List creativeList;
    private static final EnumMachineBeta[] VALUES;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private EnumMachineBeta(Class module3, int[] tag) {
        void texture;
        void tile;
        this.module = module3;
        this.tile = tile;
        this.tag = tag;
        this.texture = texture;
    }

    @Override
    public boolean isDepreciated() {
        return this.module == null;
    }

    public int[] getTexture() {
        return this.texture;
    }

    @Override
    public int getTexture(int index) {
        if (index < 0 || index >= this.texture.length) {
            index = 0;
        }
        return this.texture[index];
    }

    public static EnumMachineBeta fromId(int id) {
        if (id < 0 || id >= VALUES.length) {
            id = 0;
        }
        return VALUES[id];
    }

    public static List getCreativeList() {
        return creativeList;
    }

    @Override
    public String getTag() {
        return "rc.machine.beta." + this.tag;
    }

    @Override
    public Class getTileClass() {
        return this.tile;
    }

    public TileMachineBase getTileEntity() {
        try {
            return (TileMachineBase)this.tile.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public ur getItem() {
        return this.getItem(1);
    }

    @Override
    public ur getItem(int qty) {
        amq block = this.getBlock();
        if (block == null) {
            return null;
        }
        return new ur(block, qty, this.ordinal());
    }

    public ModuleManager.Module getModule() {
        return this.module;
    }

    @Override
    public amq getBlock() {
        return RailcraftBlocks.getBlockMachineBeta();
    }

    @Override
    public int getBlockId() {
        amq block = this.getBlock();
        if (block != null) {
            return block.cm;
        }
        return 0;
    }

    @Override
    public boolean isEnabled() {
        return ModuleManager.isModuleLoaded(this.getModule()) && this.getBlock() != null && RailcraftConfig.isSubBlockEnabled(this.getTag());
    }

    public void addItemInfo(ur stack, qx player, List info, boolean adv) {
        switch (this) {
            default: 
        }
        String tipTag = "gui.tip." + this.tag;
        if (RailcraftLanguage.hasTag(tipTag)) {
            info.add(RailcraftLanguage.translate(tipTag));
        }
    }

    static {
        creativeList = new ArrayList();
        VALUES = EnumMachineBeta.values();
        creativeList.add(TANK_IRON_WALL);
        creativeList.add(TANK_IRON_GAUGE);
        creativeList.add(TANK_IRON_VALVE);
        creativeList.add(BOILER_FIREBOX_SOLID);
        creativeList.add(BOILER_FIREBOX_LIQUID);
        creativeList.add(BOILER_TANK_LOW_PRESSURE);
        creativeList.add(BOILER_TANK_HIGH_PRESSURE);
        creativeList.add(ENGINE_STEAM_HOBBY);
        creativeList.add(ENGINE_STEAM_LOW);
        creativeList.add(ENGINE_STEAM_HIGH);
        creativeList.add(SENTINEL);
    }
}

