/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.alpha;

import buildcraft.api.gates.IAction;
import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import railcraft.common.api.crafting.IRockCrusherRecipe;
import railcraft.common.api.crafting.RailcraftCraftingManager;
import railcraft.common.blocks.machine.IEnumMachine;
import railcraft.common.blocks.machine.MultiBlockPattern;
import railcraft.common.blocks.machine.TileMultiBlock;
import railcraft.common.blocks.machine.TileMultiBlockInventory;
import railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.gui.indicator.IIndicatorController;
import railcraft.common.gui.util.ToolTip;
import railcraft.common.liquids.LiquidManager;
import railcraft.common.plugins.buildcraft.actions.EnumTriggerActions;
import railcraft.common.plugins.buildcraft.triggers.IHasWork;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.inventory.InventoryCopy;
import railcraft.common.util.inventory.InventoryMapper;
import railcraft.common.util.misc.Game;
import railcraft.common.util.sounds.SoundHelper;

public class TileRockCrusher
extends TileMultiBlockInventory
implements IPowerReceptor,
ISidedInventory,
IHasWork,
ISpecialInventory {
    private static final int PROCESS_TIME = 100;
    private static final int POWER = 16;
    private static final int MAX_RECEIVE = 500;
    private static final int MAX_ENERGY = 1600;
    private static final List patterns = new ArrayList();
    private int processTime;
    private la invInput = new InventoryMapper(this, 0, 9);
    private la invOutput = new InventoryMapper(this, 9, 9);
    private IPowerProvider provider;
    private boolean isWorking = false;
    private boolean paused = false;
    public int guiEnergy;
    private final Set actions = new HashSet();
    private IIndicatorController energyIndicator = new EnergyIndicator();

    public IIndicatorController getEnergyIndicator() {
        return this.energyIndicator;
    }

    public TileRockCrusher() {
        super(EnumMachineAlpha.ROCK_CRUSHER.getTag(), 18, patterns);
        if (PowerFramework.currentFramework != null) {
            this.provider = PowerFramework.currentFramework.createPowerProvider();
        }
        this.initPowerProvider();
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.ROCK_CRUSHER;
    }

    private void initPowerProvider() {
        if (PowerFramework.currentFramework != null) {
            this.provider.configure(0, 1, 500, 16, 1600);
            this.provider.configurePowerPerdition(1, 10);
        }
    }

    @Override
    public void g() {
        super.g();
        if (Game.isHost(this.getWorld())) {
            if (PowerFramework.currentFramework != null) {
                this.provider.update(this);
            }
            if (this.isMaster()) {
                if (this.update % 16 == 0) {
                    this.processActions();
                }
                if (this.paused) {
                    return;
                }
                ur input = null;
                IRockCrusherRecipe recipe = null;
                for (int i = 0; i < 9 && ((input = this.invInput.a(i)) == null || (recipe = RailcraftCraftingManager.rockCrusher.getRecipe(input)) == null); ++i) {
                }
                if (recipe != null) {
                    if (this.processTime >= 100) {
                        this.isWorking = false;
                        InventoryCopy tempInv = new InventoryCopy(this.invOutput);
                        boolean hasRoom = true;
                        List outputs = recipe.getRandomizedOuput();
                        for (ur output : outputs) {
                            if ((output = InvTools.moveItemStack(output, tempInv)) == null) continue;
                            hasRoom = false;
                            break;
                        }
                        if (hasRoom) {
                            for (ur output : outputs) {
                                InvTools.moveItemStack(output, this.invOutput);
                            }
                            InvTools.removeOneItem(this.invInput, input);
                            SoundHelper.playSound(this.k, this.l, this.m, this.n, "mob.irongolem.death", 1.5f, this.k.t.nextFloat() * 0.25f + 0.7f);
                            this.processTime = 0;
                        }
                    } else {
                        this.isWorking = true;
                        if (PowerFramework.currentFramework != null) {
                            float energy = this.getPowerProvider().useEnergy(16.0f, 16.0f, true);
                            if (energy >= 16.0f) {
                                ++this.processTime;
                            }
                        } else {
                            ++this.processTime;
                        }
                    }
                } else {
                    this.processTime = 0;
                    this.isWorking = false;
                }
            }
        }
    }

    @Override
    protected void onMasterReset() {
        super.onMasterReset();
        this.processTime = 0;
        if (PowerFramework.currentFramework != null) {
            this.provider = PowerFramework.currentFramework.createPowerProvider();
        }
        this.initPowerProvider();
    }

    @Override
    public boolean openGui(qx player) {
        TileMultiBlock mBlock = this.getMasterBlock();
        if (mBlock != null) {
            GuiHandler.openGui(EnumGui.ROCK_CRUSHER, player, this.k, mBlock.l, mBlock.m, mBlock.n);
            return true;
        }
        return false;
    }

    @Override
    public int getBlockTexture(int side) {
        return EnumMachineAlpha.ROCK_CRUSHER.getTexture(side);
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.UP) {
            return 0;
        }
        return 9;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 9;
    }

    @Override
    public void b(bq data) {
        super.b(data);
        data.a("processTime", this.processTime);
        if (this.provider != null) {
            PowerFramework.currentFramework.savePowerProvider(this, data);
        }
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.processTime = data.e("processTime");
        if (PowerFramework.currentFramework != null) {
            PowerFramework.currentFramework.loadPowerProvider(this, data);
            this.initPowerProvider();
        }
    }

    public int getProcessTime() {
        TileRockCrusher mBlock = (TileRockCrusher)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.processTime;
        }
        return -1;
    }

    public void setProcessTime(int processTime) {
        TileRockCrusher mBlock = (TileRockCrusher)this.getMasterBlock();
        if (mBlock != null) {
            mBlock.processTime = processTime;
        }
    }

    public int getProgressScaled(int i) {
        return this.getProcessTime() * i / 100;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        TileRockCrusher mBlock = (TileRockCrusher)this.getMasterBlock();
        if (mBlock != null) {
            mBlock.provider = provider;
        }
        this.provider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        TileRockCrusher mBlock = (TileRockCrusher)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.provider;
        }
        return this.provider;
    }

    @Override
    public int powerRequest() {
        TileRockCrusher mBlock = (TileRockCrusher)this.getMasterBlock();
        if (mBlock != null && mBlock.provider != null) {
            return (int)Math.ceil(Math.min((float)mBlock.provider.getMaxEnergyReceived(), (float)mBlock.provider.getMaxEnergyStored() - mBlock.provider.getEnergyStored()));
        }
        return 0;
    }

    @Override
    public void doWork() {
    }

    @Override
    public boolean hasWork() {
        TileRockCrusher mBlock = (TileRockCrusher)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.isWorking;
        }
        return false;
    }

    public void setPaused(boolean p) {
        TileRockCrusher mBlock = (TileRockCrusher)this.getMasterBlock();
        if (mBlock != null) {
            mBlock.paused = p;
        }
    }

    private void processActions() {
        this.paused = false;
        for (IAction action : this.actions) {
            if (action != EnumTriggerActions.PAUSE.getAction()) continue;
            this.paused = true;
        }
        this.actions.clear();
    }

    @Override
    public void actionActivated(IAction action) {
        TileRockCrusher mBlock = (TileRockCrusher)this.getMasterBlock();
        if (mBlock != null) {
            mBlock.actions.add(action);
        }
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        if (stack == null || from != ForgeDirection.UP) {
            return 0;
        }
        LiquidManager lm = LiquidManager.getInstance();
        if (RailcraftCraftingManager.rockCrusher.getRecipe(stack) != null) {
            ur remainder;
            la inv = this.invInput;
            if (!doAdd) {
                inv = new InventoryCopy(inv);
            }
            if ((remainder = InvTools.moveItemStack(stack, inv)) == null) {
                return stack.a;
            }
            return stack.a - remainder.a;
        }
        return 0;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        if (from == ForgeDirection.UP) {
            return new ur[0];
        }
        la inv = this.invOutput;
        if (!doRemove) {
            inv = new InventoryCopy(inv);
        }
        return InvTools.removeItems(inv, maxItemCount);
    }

    static {
        char[][][] map1 = new char[][][]{new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'D', 'B', 'O'}, {'O', 'B', 'D', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'B', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}};
        patterns.add(new MultiBlockPattern(map1));
        char[][][] map2 = new char[][][]{new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'O'}, {'O', 'D', 'D', 'O'}, {'O', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'O'}, {'O', 'B', 'B', 'O'}, {'O', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}}};
        patterns.add(new MultiBlockPattern(map2));
    }

    private class EnergyIndicator
    implements IIndicatorController {
        List tips = new ArrayList();
        ToolTip tip = new ToolTip();

        private EnergyIndicator() {
            this.tips.add(this.tip);
        }

        @Override
        public List getToolTip() {
            this.tip.text = String.format("%d MJ", TileRockCrusher.this.guiEnergy);
            return this.tips;
        }

        @Override
        public int getScaledLevel(int size) {
            float e = Math.min(TileRockCrusher.this.guiEnergy, 1600);
            return (int)(e * (float)size / 1600.0f);
        }
    }
}

