/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.aesthetics.wall;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraftforge.common.MinecraftForge;
import railcraft.client.sounds.RailcraftSound;
import railcraft.common.api.core.items.ItemRegistry;
import railcraft.common.blocks.aesthetics.cube.EnumCube;
import railcraft.common.blocks.aesthetics.wall.EnumWall;
import railcraft.common.blocks.aesthetics.wall.ItemWall;
import railcraft.common.core.Railcraft;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.plugins.forestry.ForestryPlugin;
import railcraft.common.util.misc.MiscTools;

public class BlockRailcraftWall
extends ane {
    private static BlockRailcraftWall instance;
    public static int currentRenderPass;
    private final int renderId;

    public static BlockRailcraftWall getBlock() {
        return instance;
    }

    public static void registerBlock() {
        int id;
        if (instance == null && (id = RailcraftConfig.getBlockId("block.wall")) > 0) {
            int renderId = Railcraft.getProxy().getRenderId();
            instance = new BlockRailcraftWall(id, renderId);
            GameRegistry.registerBlock((amq)instance, ItemWall.class, (String)instance.a());
            for (EnumWall wall : EnumWall.values()) {
                switch (wall) {
                    case SNOW: {
                        MinecraftForge.setBlockHarvestLevel((amq)instance, (int)wall.ordinal(), (String)"shovel", (int)0);
                        break;
                    }
                    case OBSIDIAN: {
                        MinecraftForge.setBlockHarvestLevel((amq)instance, (int)wall.ordinal(), (String)"pickaxe", (int)3);
                        break;
                    }
                    default: {
                        MinecraftForge.setBlockHarvestLevel((amq)instance, (int)wall.ordinal(), (String)"pickaxe", (int)2);
                    }
                }
                RailcraftLanguage.getInstance().registerItemName(wall.getItem(), wall.getTag());
                ItemRegistry.registerItem(wall.getTag(), wall.getItem());
                if (wall == EnumWall.SNOW && wall == EnumWall.ICE) continue;
                ForestryPlugin.addBackpackItem("builder", wall.getItem());
            }
        }
    }

    public BlockRailcraftWall(int id, int renderId) {
        super(id, amq.bp);
        this.renderId = renderId;
        this.b("rc.wall");
        this.a(RailcraftSound.getInstance());
        this.a(tj.b);
    }

    public int a(int side, int meta) {
        return EnumWall.fromMeta(meta).getTexture();
    }

    public String getTextureFile() {
        return "/railcraft/client/textures/railcraft.png";
    }

    public int d() {
        return this.renderId;
    }

    public int n() {
        return 1;
    }

    public boolean canRenderInPass(int pass) {
        currentRenderPass = pass;
        return pass == 0 || pass == 1;
    }

    public boolean d(ym world, int x, int y, int z) {
        int blockId = world.a(x, y, z);
        if (blockId != this.cm && blockId != amq.by.cm) {
            amq block = amq.p[blockId];
            return block != null && block.cB.k() && block.b() ? block.cB != agi.A : false;
        }
        return true;
    }

    public boolean canPlaceTorchOnTop(yc world, int x, int y, int z) {
        return true;
    }

    public void a(int id, tj tab, List list) {
        for (EnumWall wall : EnumWall.VALUES) {
            if (!wall.isEnabled()) continue;
            list.add(wall.getItem());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockHitEffects(yc worldObj, aoh target, azr effectRenderer) {
        int x = target.b;
        int y = target.c;
        int z = target.d;
        int sideHit = target.e;
        int meta = worldObj.h(x, y, z);
        Random rand = MiscTools.getRand();
        BlockRailcraftWall block = instance;
        float b = 0.1f;
        double px2 = (double)x + rand.nextDouble() * (block.w() - block.v() - (double)(b * 2.0f)) + (double)b + block.v();
        double py2 = (double)y + rand.nextDouble() * (block.y() - block.x() - (double)(b * 2.0f)) + (double)b + block.x();
        double pz = (double)z + rand.nextDouble() * (block.A() - block.z() - (double)(b * 2.0f)) + (double)b + block.z();
        if (sideHit == 0) {
            py2 = (double)y + block.x() - (double)b;
        }
        if (sideHit == 1) {
            py2 = (double)y + block.y() + (double)b;
        }
        if (sideHit == 2) {
            pz = (double)z + block.z() - (double)b;
        }
        if (sideHit == 3) {
            pz = (double)z + block.A() + (double)b;
        }
        if (sideHit == 4) {
            px2 = (double)x + block.v() - (double)b;
        }
        if (sideHit == 5) {
            px2 = (double)x + block.w() + (double)b;
        }
        bac fx = new bac(worldObj, px2, py2, pz, 0.0, 0.0, 0.0, (amq)block, sideHit, worldObj.h(x, y, z));
        if (EnumWall.fromMeta(meta).useBlockTexture()) {
            effectRenderer.addEffect(fx.a(x, y, z).e(0.2f).f(0.6f), (Object)block);
        } else {
            effectRenderer.a(fx.a(x, y, z).e(0.2f).f(0.6f));
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockDestroyEffects(yc world, int x, int y, int z, int meta, azr effectRenderer) {
        int its = 4;
        for (int i = 0; i < its; ++i) {
            for (int j = 0; j < its; ++j) {
                for (int k = 0; k < its; ++k) {
                    double px2 = (double)x + ((double)i + 0.5) / (double)its;
                    double py2 = (double)y + ((double)j + 0.5) / (double)its;
                    double pz = (double)z + ((double)k + 0.5) / (double)its;
                    int rand = MiscTools.getRand().nextInt(6);
                    bac fx = new bac(world, px2, py2, pz, px2 - (double)x - 0.5, py2 - (double)y - 0.5, pz - (double)z - 0.5, (amq)instance, rand, meta);
                    if (EnumWall.fromMeta(meta).useBlockTexture()) {
                        effectRenderer.addEffect((azq)fx.a(x, y, z), (Object)instance);
                        continue;
                    }
                    effectRenderer.a((azq)fx.a(x, y, z));
                }
            }
        }
        return true;
    }

    public float m(yc world, int x, int y, int z) {
        int meta = world.h(x, y, z);
        EnumWall wall = EnumWall.fromMeta(meta);
        switch (wall) {
            case INFERNAL: {
                return EnumCube.INFERNAL_BRICK.getHardness();
            }
            case SANDY: {
                return EnumCube.SANDY_BRICK.getHardness();
            }
            case CONCRETE: {
                return EnumCube.CONCRETE_BLOCK.getHardness();
            }
        }
        int id = wall.getSourceId();
        amq block = amq.p[id];
        if (id <= 0 || block == null) {
            return amq.ao.m(world, x, y, z);
        }
        return block.m(world, x, y, z);
    }

    public float getExplosionResistance(lq entity, yc world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        int meta = world.h(x, y, z);
        EnumWall wall = EnumWall.fromMeta(meta);
        switch (wall) {
            case INFERNAL: {
                return EnumCube.INFERNAL_BRICK.getResistance() * 3.0f / 5.0f;
            }
            case SANDY: {
                return EnumCube.SANDY_BRICK.getResistance() * 3.0f / 5.0f;
            }
            case CONCRETE: {
                return EnumCube.CONCRETE_BLOCK.getResistance() * 3.0f / 5.0f;
            }
        }
        int id = wall.getSourceId();
        amq block = amq.p[id];
        if (id <= 0 || block == null) {
            return amq.ao.a(entity);
        }
        return block.a(entity);
    }
}

