/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.api.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraftforge.common.ForgeDirection;
import railcraft.common.api.core.items.IToolCrowbar;
import railcraft.common.api.tracks.ITrackInstance;
import railcraft.common.api.tracks.ITrackPowered;
import railcraft.common.api.tracks.ITrackReversable;
import railcraft.common.api.tracks.ITrackTile;
import railcraft.common.api.tracks.TrackSpec;

public abstract class TrackInstanceBase
implements ITrackInstance {
    private amq block;
    public any tileEntity;

    private amq getBlock() {
        if (this.block == null) {
            int id = this.getWorld().a(this.getX(), this.getY(), this.getZ());
            this.block = amq.p[id];
        }
        return this.block;
    }

    @Override
    public void setTile(any tile) {
        this.tileEntity = tile;
    }

    @Override
    public any getTile() {
        return this.tileEntity;
    }

    @Override
    public int getBasicRailMetadata(py cart) {
        return this.tileEntity.p();
    }

    @Override
    public void onMinecartPass(py cart) {
    }

    @Override
    public boolean blockActivated(qx player) {
        IToolCrowbar crowbar;
        ur current;
        if (this instanceof ITrackReversable && (current = player.bS()) != null && current.b() instanceof IToolCrowbar && (crowbar = (IToolCrowbar)current.b()).canWhack(player, current, this.getX(), this.getY(), this.getZ())) {
            ITrackReversable track;
            track.setReversed(!(track = (ITrackReversable)((Object)this)).isReversed());
            this.markBlockNeedsUpdate();
            crowbar.onWhack(player, current, this.getX(), this.getY(), this.getZ());
            return true;
        }
        return false;
    }

    @Override
    public void onBlockPlaced() {
        this.switchTrack(true);
        this.testPower();
        this.markBlockNeedsUpdate();
    }

    @Override
    public void onBlockPlacedBy(md entityliving) {
        if (entityliving == null) {
            return;
        }
        if (this instanceof ITrackReversable) {
            int dir = ke.c((double)((double)(entityliving.z * 4.0f / 360.0f) + 0.5)) & 3;
            ((ITrackReversable)((Object)this)).setReversed(dir == 0 || dir == 1);
        }
        this.markBlockNeedsUpdate();
    }

    @Override
    public void onBlockRemoved() {
    }

    public void sendUpdateToClient() {
        ((ITrackTile)this.tileEntity).sendUpdateToClient();
    }

    public void markBlockNeedsUpdate() {
        this.getWorld().i(this.tileEntity.l, this.tileEntity.m, this.tileEntity.n);
    }

    protected boolean isRailValid(yc world, int i, int j, int k, int meta) {
        boolean valid = true;
        if (!world.isBlockSolidOnSide(i, j - 1, k, ForgeDirection.UP)) {
            valid = false;
        }
        if (meta == 2 && !world.isBlockSolidOnSide(i + 1, j, k, ForgeDirection.UP)) {
            valid = false;
        } else if (meta == 3 && !world.isBlockSolidOnSide(i - 1, j, k, ForgeDirection.UP)) {
            valid = false;
        } else if (meta == 4 && !world.isBlockSolidOnSide(i, j, k - 1, ForgeDirection.UP)) {
            valid = false;
        } else if (meta == 5 && !world.isBlockSolidOnSide(i, j, k + 1, ForgeDirection.UP)) {
            valid = false;
        }
        return valid;
    }

    @Override
    public void onNeighborBlockChange(int id) {
        int meta = this.tileEntity.p();
        boolean valid = this.isRailValid(this.getWorld(), this.tileEntity.l, this.tileEntity.m, this.tileEntity.n, meta);
        if (!valid) {
            amq blockTrack = this.getBlock();
            blockTrack.c(this.getWorld(), this.tileEntity.l, this.tileEntity.m, this.tileEntity.n, 0, 0);
            this.getWorld().e(this.tileEntity.l, this.tileEntity.m, this.tileEntity.n, 0);
            return;
        }
        alr blockTrack = (alr)this.getBlock();
        if (id > 0 && amq.p[id].i() && this.isFlexibleRail() && als.a((als)new als(blockTrack, this.getWorld(), this.tileEntity.l, this.tileEntity.m, this.tileEntity.n)) == 3) {
            this.switchTrack(false);
        }
        this.testPower();
    }

    protected void switchTrack(boolean flag) {
        int i = this.tileEntity.l;
        int j = this.tileEntity.m;
        int k = this.tileEntity.n;
        alr blockTrack = (alr)this.getBlock();
        new als(blockTrack, this.getWorld(), i, j, k).a(this.getWorld().B(i, j, k), flag);
    }

    protected void testPower() {
        boolean powered;
        if (!(this instanceof ITrackPowered)) {
            return;
        }
        int i = this.tileEntity.l;
        int j = this.tileEntity.m;
        int k = this.tileEntity.n;
        ITrackPowered r = (ITrackPowered)((Object)this);
        int meta = this.tileEntity.p();
        boolean bl = powered = this.getWorld().B(i, j, k) || this.testPowerPropagation(this.getWorld(), i, j, k, this.getTrackSpec(), meta, r.getPowerPropagation());
        if (powered != r.isPowered()) {
            r.setPowered(powered);
            amq blockTrack = this.getBlock();
            this.getWorld().h(i, j, k, blockTrack.cm);
            this.getWorld().h(i, j - 1, k, blockTrack.cm);
            if (meta == 2 || meta == 3 || meta == 4 || meta == 5) {
                this.getWorld().h(i, j + 1, k, blockTrack.cm);
            }
            this.sendUpdateToClient();
        }
    }

    protected boolean testPowerPropagation(yc world, int i, int j, int k, TrackSpec spec, int meta, int maxDist) {
        return this.isConnectedRailPowered(world, i, j, k, spec, meta, true, 0, maxDist) || this.isConnectedRailPowered(world, i, j, k, spec, meta, false, 0, maxDist);
    }

    protected boolean isConnectedRailPowered(yc world, int i, int j, int k, TrackSpec spec, int meta, boolean dir, int dist, int maxDist) {
        if (dist >= maxDist) {
            return false;
        }
        boolean powered = true;
        switch (meta) {
            case 0: {
                if (dir) {
                    ++k;
                    break;
                }
                --k;
                break;
            }
            case 1: {
                if (dir) {
                    --i;
                    break;
                }
                ++i;
                break;
            }
            case 2: {
                if (dir) {
                    --i;
                } else {
                    ++i;
                    ++j;
                    powered = false;
                }
                meta = 1;
                break;
            }
            case 3: {
                if (dir) {
                    --i;
                    ++j;
                    powered = false;
                } else {
                    ++i;
                }
                meta = 1;
                break;
            }
            case 4: {
                if (dir) {
                    ++k;
                } else {
                    --k;
                    ++j;
                    powered = false;
                }
                meta = 0;
                break;
            }
            case 5: {
                if (dir) {
                    ++k;
                    ++j;
                    powered = false;
                } else {
                    --k;
                }
                meta = 0;
            }
        }
        if (this.testPowered(world, i, j, k, spec, dir, dist, maxDist, meta)) {
            return true;
        }
        return powered && this.testPowered(world, i, j - 1, k, spec, dir, dist, maxDist, meta);
    }

    protected boolean testPowered(yc world, int i, int j, int k, TrackSpec spec, boolean dir, int dist, int maxDist, int orientation) {
        int id = world.a(i, j, k);
        amq blockTrack = this.getBlock();
        if (id == blockTrack.cm) {
            int meta = world.h(i, j, k);
            any tile = world.q(i, j, k);
            if (tile instanceof ITrackTile) {
                ITrackInstance track = ((ITrackTile)tile).getTrackInstance();
                if (!(track instanceof ITrackPowered) || track.getTrackSpec() != spec) {
                    return false;
                }
                if (orientation == 1 && (meta == 0 || meta == 4 || meta == 5)) {
                    return false;
                }
                if (orientation == 0 && (meta == 1 || meta == 2 || meta == 3)) {
                    return false;
                }
                if (((ITrackPowered)track).isPowered()) {
                    if (world.B(i, j, k) || world.B(i, j + 1, k)) {
                        return true;
                    }
                    return this.isConnectedRailPowered(world, i, j, k, spec, meta, dir, dist + 1, maxDist);
                }
            }
        }
        return false;
    }

    @Override
    public int getTextureIndex() {
        return this.getTrackSpec().getTextureIndex();
    }

    @Override
    public void writeToNBT(bq data) {
    }

    @Override
    public void readFromNBT(bq data) {
    }

    @Override
    public boolean canUpdate() {
        return false;
    }

    @Override
    public void updateEntity() {
    }

    @Override
    public float getExplosionResistance(double srcX, double srcY, double srcZ, lq exploder) {
        return 3.5f;
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
    }

    @Override
    public yc getWorld() {
        return this.tileEntity.k;
    }

    @Override
    public int getX() {
        return this.tileEntity.l;
    }

    @Override
    public int getY() {
        return this.tileEntity.m;
    }

    @Override
    public int getZ() {
        return this.tileEntity.n;
    }

    @Override
    public boolean isFlexibleRail() {
        return false;
    }

    @Override
    public boolean canMakeSlopes() {
        return true;
    }

    @Override
    public float getRailMaxSpeed(py cart) {
        return 0.4f;
    }
}

