/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.api.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import railcraft.common.api.core.WorldCoordinate;
import railcraft.common.api.signals.SignalAspect;
import railcraft.common.api.signals.SignalController;
import railcraft.common.api.signals.SignalReceiver;

public class SimpleSignalController
extends SignalController {
    private SignalAspect aspect = SignalAspect.BLINK_RED;

    public SimpleSignalController(String desc, any tile) {
        super(desc, tile, 1);
    }

    public SignalAspect getAspect() {
        return this.aspect;
    }

    @Override
    public SignalAspect getAspectFor(WorldCoordinate receiver) {
        if (!this.pairings.contains(receiver)) {
            return null;
        }
        return this.aspect;
    }

    private void updateReceiver() {
        for (WorldCoordinate recv : this.pairings) {
            SignalReceiver receiver = this.getReceiverAt(recv);
            if (receiver == null) continue;
            receiver.onControllerAspectChange(this, this.aspect);
        }
        this.cleanPairings();
    }

    public void setAspect(SignalAspect aspect) {
        if (this.aspect != aspect) {
            this.aspect = aspect;
            this.updateReceiver();
        }
    }

    @Override
    protected void saveNBT(bq data) {
        super.saveNBT(data);
        data.a("aspect", (byte)this.aspect.ordinal());
    }

    @Override
    protected void loadNBT(bq data) {
        super.loadNBT(data);
        this.aspect = SignalAspect.values()[data.c("aspect")];
    }

    public void writePacketData(DataOutputStream data) throws IOException {
        data.writeByte(this.aspect.ordinal());
    }

    public void readPacketData(DataInputStream data) throws IOException {
        this.aspect = SignalAspect.values()[data.readByte()];
    }
}

