/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.api.signals;

import railcraft.common.api.core.WorldCoordinate;
import railcraft.common.api.signals.AbstractPair;
import railcraft.common.api.signals.IControllerTile;
import railcraft.common.api.signals.IReceiverTile;
import railcraft.common.api.signals.SignalAspect;
import railcraft.common.api.signals.SignalController;

public abstract class SignalReceiver
extends AbstractPair {
    protected boolean needsInit = true;

    public SignalReceiver(String name, any tile, int maxPairings) {
        super(name, tile, maxPairings);
    }

    public SignalController getControllerAt(WorldCoordinate coord) {
        any con = this.getPairAt(coord);
        if (con != null) {
            return ((IControllerTile)con).getController();
        }
        return null;
    }

    @Override
    protected String getTagName() {
        return "receiver";
    }

    @Override
    public boolean isValidPair(any tile) {
        if (tile instanceof IControllerTile) {
            SignalController controller = ((IControllerTile)tile).getController();
            return controller.isPairedWith(this.getCoords());
        }
        return false;
    }

    public void onControllerAspectChange(SignalController con, SignalAspect aspect) {
        ((IReceiverTile)this.tile).onControllerAspectChange(con, aspect);
    }

    protected void registerController(SignalController controller) {
        this.addPairing(controller.getCoords());
    }

    @Deprecated
    public void registerLegacyController(int x, int y, int z) {
        this.pairings.add(new WorldCoordinate(0, x, y, z));
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.needsInit) {
            this.needsInit = false;
            for (WorldCoordinate pair : this.pairings) {
                SignalAspect aspect;
                SignalController controller = this.getControllerAt(pair);
                if (controller == null || (aspect = controller.getAspectFor(this.getCoords())) == null) continue;
                this.onControllerAspectChange(controller, aspect);
            }
        }
    }
}

