/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.api.signals;

import railcraft.common.api.core.WorldCoordinate;
import railcraft.common.api.signals.AbstractPair;
import railcraft.common.api.signals.IReceiverTile;
import railcraft.common.api.signals.SignalAspect;
import railcraft.common.api.signals.SignalReceiver;
import railcraft.common.api.signals.SignalTools;

public abstract class SignalController
extends AbstractPair {
    public SignalController(String name, any tile, int maxPairings) {
        super(name, tile, maxPairings);
    }

    public SignalReceiver getReceiverAt(WorldCoordinate coord) {
        any recv = this.getPairAt(coord);
        if (recv != null) {
            return ((IReceiverTile)recv).getReceiver();
        }
        return null;
    }

    public abstract SignalAspect getAspectFor(WorldCoordinate var1);

    public boolean sendAspectTo(WorldCoordinate receiver, SignalAspect aspect) {
        SignalReceiver recv = this.getReceiverAt(receiver);
        if (recv != null) {
            recv.onControllerAspectChange(this, aspect);
            return true;
        }
        return false;
    }

    @Override
    protected String getTagName() {
        return "controller";
    }

    @Override
    public boolean isValidPair(any tile) {
        if (tile instanceof IReceiverTile) {
            SignalReceiver receiver = ((IReceiverTile)tile).getReceiver();
            return receiver.isPairedWith(this.getCoords());
        }
        return false;
    }

    @Deprecated
    public void registerLegacyReceiver(int x, int y, int z) {
        this.pairings.add(new WorldCoordinate(0, x, y, z));
    }

    public void registerReceiver(SignalReceiver receiver) {
        WorldCoordinate coords = receiver.getCoords();
        this.addPairing(coords);
        receiver.registerController(this);
        receiver.onControllerAspectChange(this, this.getAspectFor(coords));
    }

    @Override
    public void tickClient() {
        super.tickClient();
        if (SignalTools.effectManager != null && SignalTools.effectManager.isTuningAuraActive()) {
            for (WorldCoordinate coord : this.pairings) {
                SignalReceiver receiver = this.getReceiverAt(coord);
                if (receiver == null) continue;
                SignalTools.effectManager.tuningEffect(this.getTile(), receiver.getTile());
            }
        }
    }
}

