/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.api.carts;

import cpw.mods.fml.common.registry.EntityRegistry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import railcraft.common.api.carts.IItemTransfer;
import railcraft.common.api.carts.ILinkageManager;
import railcraft.common.api.carts.IMinecart;
import railcraft.common.api.core.items.IMinecartItem;

public abstract class CartTools {
    public static ILinkageManager serverLinkageManager;

    public static void registerMinecart(Object mod, Class type, String tag, int internalId) {
        EntityRegistry.registerModEntity((Class)type, (String)tag, (int)internalId, (Object)mod, (int)80, (int)3, (boolean)true);
    }

    public static ILinkageManager getLinkageManager(yc world) {
        return serverLinkageManager;
    }

    public static void setCartOwner(py cart, qx owner) {
        cart.getEntityData().a("owner", owner.bR);
    }

    public static void setCartOwner(py cart, String owner) {
        cart.getEntityData().a("owner", owner);
    }

    public static String getCartOwner(py cart) {
        return cart.getEntityData().i("owner");
    }

    public static boolean doesCartMatchFilter(ur stack, py cart) {
        if (stack == null) {
            return false;
        }
        if (cart instanceof IMinecart) {
            return ((IMinecart)cart).doesCartMatchFilter(stack, cart);
        }
        ur cartItem = cart.getCartItem();
        return cartItem != null && CartTools.isItemEqual(stack, cartItem);
    }

    private static boolean isItemEqual(ur a, ur b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.c != b.c) {
            return false;
        }
        if (a.d != null && !a.d.equals((Object)b.d)) {
            return false;
        }
        if (a.g() && (a.j() == -1 || b.j() == -1)) {
            return true;
        }
        return !a.g() || a.j() == b.j();
    }

    public static py placeCart(String owner, ur cart, yc world, int i, int j, int k) {
        if (cart == null) {
            return null;
        }
        if ((cart = cart.l()).b() instanceof IMinecartItem) {
            IMinecartItem mi = (IMinecartItem)cart.b();
            return mi.placeCart(owner, cart, world, i, j, k);
        }
        if (cart.b() instanceof uv) {
            try {
                List carts;
                boolean placed = cart.b().a(cart, null, world, i, j, k, 0, 0.0f, 0.0f, 0.0f);
                if (placed && (carts = CartTools.getMinecartsAt(world, i, j, k, 0.3f)).size() > 0) {
                    CartTools.setCartOwner((py)carts.get(0), owner);
                    return (py)carts.get(0);
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static void offerOrDropItem(py cart, ur stack) {
        py link_A = CartTools.getLinkageManager(cart.p).getLinkedCartA(cart);
        py link_B = CartTools.getLinkageManager(cart.p).getLinkedCartB(cart);
        if (stack != null && stack.a > 0 && link_A instanceof IItemTransfer) {
            stack = ((IItemTransfer)link_A).offerItem(cart, stack);
        }
        if (stack != null && stack.a > 0 && link_B instanceof IItemTransfer) {
            stack = ((IItemTransfer)link_B).offerItem(cart, stack);
        }
        if (stack != null && stack.a > 0) {
            cart.a(stack, 1.0f);
        }
    }

    public static boolean isMinecartOnRailAt(yc world, int i, int j, int k, float sensitivity) {
        return CartTools.isMinecartOnRailAt(world, i, j, k, sensitivity, null, true);
    }

    public static boolean isMinecartOnRailAt(yc world, int i, int j, int k, float sensitivity, Class type, boolean subclass) {
        if (alr.e_((yc)world, (int)i, (int)j, (int)k)) {
            return CartTools.isMinecartAt(world, i, j, k, sensitivity, type, subclass);
        }
        return false;
    }

    public static boolean isMinecartOnAnySide(yc world, int i, int j, int k, float sensitivity) {
        return CartTools.isMinecartOnAnySide(world, i, j, k, sensitivity, null, true);
    }

    public static boolean isMinecartOnAnySide(yc world, int i, int j, int k, float sensitivity, Class type, boolean subclass) {
        ArrayList list = new ArrayList();
        for (int side = 0; side < 6; ++side) {
            list.addAll(CartTools.getMinecartsOnSide(world, i, j, k, sensitivity, ForgeDirection.getOrientation((int)side)));
        }
        if (type == null) {
            return !list.isEmpty();
        }
        for (py cart : list) {
            if ((!subclass || !type.isInstance(cart)) && cart.getClass() != type) continue;
            return true;
        }
        return false;
    }

    public static boolean isMinecartAt(yc world, int i, int j, int k, float sensitivity) {
        return CartTools.isMinecartAt(world, i, j, k, sensitivity, null, true);
    }

    public static boolean isMinecartAt(yc world, int i, int j, int k, float sensitivity, Class type, boolean subclass) {
        List list = CartTools.getMinecartsAt(world, i, j, k, sensitivity);
        if (type == null) {
            return !list.isEmpty();
        }
        for (py cart : list) {
            if ((!subclass || !type.isInstance(cart)) && cart.getClass() != type) continue;
            return true;
        }
        return false;
    }

    public static List getMinecartsOnAllSides(yc world, int i, int j, int k, float sensitivity) {
        ArrayList carts = new ArrayList();
        for (int side = 0; side < 6; ++side) {
            carts.addAll(CartTools.getMinecartsOnSide(world, i, j, k, sensitivity, ForgeDirection.getOrientation((int)side)));
        }
        return carts;
    }

    public static List getMinecartsOnAllSides(yc world, int i, int j, int k, float sensitivity, Class type, boolean subclass) {
        ArrayList list = new ArrayList();
        ArrayList<py> carts = new ArrayList<py>();
        for (int side = 0; side < 6; ++side) {
            list.addAll(CartTools.getMinecartsOnSide(world, i, j, k, sensitivity, ForgeDirection.getOrientation((int)side)));
        }
        for (py cart : list) {
            if ((!subclass || !type.isInstance(cart)) && cart.getClass() != type) continue;
            carts.add(cart);
        }
        return carts;
    }

    private static int getYOnSide(int y, ForgeDirection side) {
        switch (side) {
            case UP: {
                return y + 1;
            }
            case DOWN: {
                return y - 1;
            }
        }
        return y;
    }

    private static int getXOnSide(int x, ForgeDirection side) {
        switch (side) {
            case EAST: {
                return x + 1;
            }
            case WEST: {
                return x - 1;
            }
        }
        return x;
    }

    private static int getZOnSide(int z, ForgeDirection side) {
        switch (side) {
            case NORTH: {
                return z - 1;
            }
            case SOUTH: {
                return z + 1;
            }
        }
        return z;
    }

    public static List getMinecartsOnSide(yc world, int i, int j, int k, float sensitivity, ForgeDirection side) {
        return CartTools.getMinecartsAt(world, CartTools.getXOnSide(i, side), CartTools.getYOnSide(j, side), CartTools.getZOnSide(k, side), sensitivity);
    }

    public static boolean isMinecartOnSide(yc world, int i, int j, int k, float sensitivity, ForgeDirection side) {
        return CartTools.getMinecartOnSide(world, i, j, k, sensitivity, side) != null;
    }

    public static py getMinecartOnSide(yc world, int i, int j, int k, float sensitivity, ForgeDirection side) {
        Iterator i$ = CartTools.getMinecartsOnSide(world, i, j, k, sensitivity, side).iterator();
        if (i$.hasNext()) {
            py cart = (py)i$.next();
            return cart;
        }
        return null;
    }

    public static boolean isMinecartOnSide(yc world, int i, int j, int k, float sensitivity, ForgeDirection side, Class type, boolean subclass) {
        return CartTools.getMinecartOnSide(world, i, j, k, sensitivity, side, type, subclass) != null;
    }

    public static py getMinecartOnSide(yc world, int i, int j, int k, float sensitivity, ForgeDirection side, Class type, boolean subclass) {
        for (py cart : CartTools.getMinecartsOnSide(world, i, j, k, sensitivity, side)) {
            if (type != null && (!subclass || !type.isInstance(cart)) && cart.getClass() != type) continue;
            return cart;
        }
        return null;
    }

    public static List getMinecartsAt(yc world, int i, int j, int k, float sensitivity) {
        sensitivity = Math.min(sensitivity, 0.49f);
        List entities = world.a(py.class, aoe.a().a((double)((float)i + sensitivity), (double)((float)j + sensitivity), (double)((float)k + sensitivity), (double)((float)(i + 1) - sensitivity), (double)((float)(j + 1) - sensitivity), (double)((float)(k + 1) - sensitivity)));
        ArrayList<py> carts = new ArrayList<py>();
        for (Object o : entities) {
            carts.add((py)o);
        }
        return carts;
    }

    public static List getMinecartsIn(yc world, int i1, int j1, int k1, int i2, int j2, int k2) {
        List entities = world.a(py.class, aoe.a().a((double)i1, (double)j1, (double)k1, (double)i2, (double)j2, (double)k2));
        ArrayList<py> carts = new ArrayList<py>();
        for (Object o : entities) {
            carts.add((py)o);
        }
        return carts;
    }

    public static double getCartSpeedUncapped(py cart) {
        return Math.sqrt(cart.w * cart.w + cart.y * cart.y);
    }

    public static boolean cartVelocityIsLessThan(py cart, float vel) {
        return Math.abs(cart.w) < (double)vel && Math.abs(cart.y) < (double)vel;
    }
}

