/*
 * Decompiled with CFR 0.152.
 */
package railcraft.client.sounds;

import java.net.URL;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import railcraft.common.core.Railcraft;
import railcraft.common.util.misc.Game;
import railcraft.common.util.sounds.SoundRegistry;

public class SoundHandler {
    private static SoundHandler instance;

    public static SoundHandler getInstance() {
        if (instance == null) {
            instance = new SoundHandler();
        }
        return instance;
    }

    private SoundHandler() {
    }

    @ForgeSubscribe
    public void loadSounds(SoundLoadEvent event) {
        bex pool = event.manager.b;
        this.addSound(pool, "locomotive/steam/whistle1.ogg");
        this.addSound(pool, "locomotive/steam/whistle2.ogg");
        this.addSound(pool, "locomotive/steam/whistle3.ogg");
        this.addSound(pool, "machine/steamburst.ogg");
    }

    private void addSound(bex pool, String path) {
        try {
            URL sound = Railcraft.class.getResource("/railcraft/client/sounds/" + path);
            if (sound == null) {
                throw new RuntimeException("Resource not found");
            }
            pool.addSound(path, sound);
        }
        catch (Exception ex) {
            Game.logError("Failed to load sound: " + path, ex);
        }
    }

    @ForgeSubscribe
    public void onPlaySound(PlaySoundEvent event) {
        int meta;
        int iz;
        int iy;
        int ix;
        int blockID;
        amu sound;
        yc world;
        String soundName = event.name;
        if (soundName != null && (soundName.equals("dig.railcraft") || soundName.equals("place.railcraft")) && (world = Railcraft.getProxy().getClientWorld()) != null && (sound = SoundRegistry.getSound(blockID = world.a(ix = ke.d((float)event.x), iy = ke.d((float)event.y), iz = ke.d((float)event.z)), meta = world.h(ix, iy, iz))) != null) {
            String newName = soundName.contains("dig") ? sound.a() : sound.b();
            event.manager.a(newName, event.x, event.y, event.z, event.volume, event.pitch * sound.d());
            event.result = null;
        }
    }

    @ForgeSubscribe
    public void onPlaySoundAtEntity(PlaySoundAtEntityEvent event) {
        int meta;
        int iz;
        int iy;
        int ix;
        int blockID;
        amu sound;
        yc world;
        String soundName = event.name;
        lq entity = event.entity;
        if (soundName != null && soundName.equals("step.railcraft") && (world = entity.p) != null && (sound = SoundRegistry.getSound(blockID = world.a(ix = ke.c((double)entity.t), iy = ke.c((double)(entity.u - 0.2 - (double)entity.M)), iz = ke.c((double)entity.v)), meta = world.h(ix, iy, iz))) != null) {
            world.a(entity, sound.e(), event.volume, event.pitch * sound.d());
            event.setCanceled(true);
        }
    }
}

